/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.ebservice.service.arrival;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.arrival.ArrivalFileDownloadResponseBody;
import kd.tmc.lc.business.opservice.ebservice.request.ArrivalFileDownloadRequestBuilder;
import kd.tmc.lc.business.opservice.ebservice.request.datasource.arrival.ArrivalFileDownloadDataSource;
import kd.tmc.lc.common.enums.FileDownloadStatusEnum;

public class ArrivalFileDownloadService
implements IEBService<SyncStatusResult> {
    private final DynamicObject arrOnline;
    private SyncStatusResult ebResult;

    public ArrivalFileDownloadService(DynamicObject arrOnline) {
        this.arrOnline = arrOnline;
        this.ebResult = new SyncStatusResult();
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
        this.dealFailCase(EBResultStatusCode.ROLLBACK, errMsg);
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        this.dealFailCase(EBResultStatusCode.ERROR, errMsg);
    }

    public void handleResultBody(String resultBody) {
        ArrivalFileDownloadResponseBody responseBody = (ArrivalFileDownloadResponseBody)JSON.parseObject((String)resultBody, ArrivalFileDownloadResponseBody.class);
        List fileList = responseBody.getFileList();
        if (EmptyUtil.isEmpty((Collection)fileList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u94f6\u4f01\u8fd4\u56de\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\uff01\u8be6\u60c5\u8bf7\u67e5\u770b\u540c\u6b65\u65e5\u5fd7\u3002", (String)"ArrivalFileDownloadService_1", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
        this.arrOnline.set("filelistres_tag", (Object)SerializationUtils.toJsonString((Object)fileList));
        this.arrOnline.set("filestatus", (Object)FileDownloadStatusEnum.SUCCESS.getValue());
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.arrOnline});
        }
        this.ebResult.setStatusCode(EBResultStatusCode.SUCCESS);
    }

    public IEBRequestBuilder getRequestBuilder() {
        ArrivalFileDownloadDataSource fileDownloadDataSource = new ArrivalFileDownloadDataSource(this.arrOnline);
        return new ArrivalFileDownloadRequestBuilder(fileDownloadDataSource, "downloadBankFile", "downloadBankFile");
    }

    public String getEntityName() {
        return this.arrOnline.getDynamicObjectType().getName();
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo logInfo = new BankLogInfo();
        logInfo.setSourceId(Long.valueOf(this.arrOnline.getLong("id")));
        logInfo.setBillNo(this.arrOnline.getString("billno"));
        logInfo.setEntityName(this.getEntityName());
        logInfo.setOrgid((Long)this.arrOnline.getDynamicObject("org").getPkValue());
        return logInfo;
    }

    public SyncStatusResult getEBResult() {
        return this.ebResult;
    }

    public Long getBankCateId() {
        return Optional.ofNullable(this.arrOnline.getDynamicObject("banktype")).map(r -> r.getLong("id")).orElse(0L);
    }

    private void dealFailCase(EBResultStatusCode code, String errMsg) {
        this.ebResult.setStatusCode(code);
        this.ebResult.setErrMsg(errMsg);
        this.ebResult.setBankBillId(Long.valueOf(this.arrOnline.getLong("id")));
        try (TXHandle tx = TX.requiresNew();){
            this.arrOnline.set("filestatus", null);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.arrOnline});
        }
    }
}

