/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.ebservice.service.lettercredit;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.PageQueryCreditResult;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.lettercredit.QueryCreditResponseBody;
import kd.tmc.fbp.webapi.ebentity.biz.lettercredit.QueryCreditResponseDetail;
import kd.tmc.lc.business.opservice.ebservice.request.QueryCreditRequestBuilder;
import kd.tmc.lc.business.opservice.ebservice.request.datasource.lettercredit.QueryCreditDataSource;
import org.apache.commons.lang3.tuple.Pair;

public class QueryCreditService
implements IEBService<PageQueryCreditResult> {
    private Map paraMap;
    private PageQueryCreditResult ebResult;
    private static final Log LOG = LogFactory.getLog(QueryCreditService.class);

    public QueryCreditService(Map paraMap) {
        this.paraMap = paraMap;
        this.ebResult = new PageQueryCreditResult();
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        this.ebResult.setStatusCode(EBResultStatusCode.ERROR);
        this.ebResult.setKeepFlag("1");
        LOG.info("\u672c\u6279\u6b21\u4ece\u94f6\u884c\u540c\u6b65\u6570\u636e\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)errMsg);
        JSONObject bodyJson = JSON.parseObject((String)resultBody);
        String msg = ResManager.loadKDString((String)"\u5728\u7ebf\u83b7\u53d6\u4fe1\u7528\u8bc1\u4fe1\u606f\u65f6\uff0c\u94f6\u4f01\u8fd4\u56de\u7684\u660e\u7ec6\u4e3a\u7a7a\uff01\u8be6\u60c5\u8bf7\u67e5\u770b\u540c\u6b65\u65e5\u5fd7\u3002", (String)"QueryCreditService_0", (String)"tmc-lc-business", (Object[])new Object[0]);
        if (EmptyUtil.isEmpty((Object)bodyJson)) {
            throw new KDBizException(msg);
        }
        String detailStr = JSONObject.toJSONString((Object)bodyJson.get((Object)"details"));
        List detailList = JSONObject.parseArray((String)detailStr, JSONObject.class);
        if (EmptyUtil.isEmpty((Collection)detailList)) {
            throw new KDBizException(msg);
        }
    }

    public void handleResultBody(String resultBody) {
        List<QueryCreditResponseDetail> detailList = this.getQueryCreditResponseDetails(resultBody);
        if (EmptyUtil.isEmpty(detailList)) {
            return;
        }
        LOG.info("\u672c\u6279\u6b21\u4ece\u94f6\u884c\u62c9\u56de\u6570\u636e{}\u6761", (Object)detailList.size());
        Map<String, Long> currencyNumToIdMap = this.turnCurrencyNumToId(detailList);
        Map<String, Pair<Long, String>> swiftCodeMap = this.turnSwiftCodeToId(detailList);
        ArrayList<DynamicObject> updateLetterCreditList = new ArrayList<DynamicObject>(detailList.size());
        Long orgId = Optional.ofNullable((String)this.paraMap.get("org")).filter(r -> EmptyUtil.isNoEmpty((String)r)).map(r -> Long.valueOf(r)).orElse(0L);
        LOG.info("\u672c\u6279\u6b21\u5904\u7406\u7ec4\u7ec7id={}", (Object)orgId);
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        Long bankType = Optional.ofNullable((String)this.paraMap.get("bank")).filter(r -> EmptyUtil.isNoEmpty((String)r)).map(r -> Long.valueOf(r)).orElse(0L);
        qFilter.and(new QFilter("bank.bank_cate", "=", (Object)bankType));
        Date startDate = DateUtils.stringToDate((String)((String)this.paraMap.get("startdate")), (String)"yyyyMMdd");
        qFilter.and(new QFilter("bizdate", ">=", (Object)startDate));
        Date enddate = DateUtils.stringToDate((String)((String)this.paraMap.get("enddate")), (String)"yyyyMMdd");
        qFilter.and(new QFilter("bizdate", "<=", (Object)enddate));
        DeleteServiceHelper.delete((String)"lc_onlineresult", (QFilter[])qFilter.toArray());
        Map<String, String> lcBillNoMap = this.getDbLcBillNo(detailList, orgId, bankType, startDate, enddate);
        for (QueryCreditResponseDetail detail : detailList) {
            this.buildOnlineResultMapping(currencyNumToIdMap, swiftCodeMap, detail, updateLetterCreditList, lcBillNoMap);
        }
        SaveServiceHelper.save((DynamicObject[])updateLetterCreditList.toArray(new DynamicObject[0]));
        this.ebResult.setStatusCode(EBResultStatusCode.SUCCESS);
        LOG.info("\u672c\u6279\u6b21\u4ece\u94f6\u884c\u540c\u6b65\u66f4\u65b0\u6570\u636e\u6210\u529f\u3002");
    }

    public IEBRequestBuilder getRequestBuilder() {
        QueryCreditDataSource openCreditDataSource = new QueryCreditDataSource(this.paraMap);
        return new QueryCreditRequestBuilder(openCreditDataSource, "queryCredit", "hold");
    }

    public String getEntityName() {
        return "lc_onlineresult";
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo logInfo = new BankLogInfo();
        logInfo.setEntityName(this.getEntityName());
        return logInfo;
    }

    public PageQueryCreditResult getEBResult() {
        return this.ebResult;
    }

    public Long getBankCateId() {
        return null;
    }

    private Map<String, Long> turnCurrencyNumToId(List<QueryCreditResponseDetail> detailList) {
        Set currencyNumber = detailList.stream().map(r -> r.getCurrency()).collect(Collectors.toSet());
        QFilter currencyFilter = new QFilter("number", "in", currencyNumber);
        DynamicObjectCollection bdCurrency = QueryServiceHelper.query((String)"bd_currency", (String)"id,number", (QFilter[])new QFilter[]{currencyFilter});
        return bdCurrency.stream().collect(Collectors.toMap(r -> r.getString("number"), r -> r.getLong("id")));
    }

    private Map<String, Pair<Long, String>> turnSwiftCodeToId(List<QueryCreditResponseDetail> detailList) {
        Set adviCnapsCode = detailList.stream().map(r -> r.getIssuingBankBIC()).filter(r -> EmptyUtil.isNoEmpty((String)r)).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(adviCnapsCode)) {
            QFilter adviCnapsCodeFilter = new QFilter("swift_code", "in", adviCnapsCode);
            DynamicObjectCollection finoOrg = QueryServiceHelper.query((String)"bd_finorginfo", (String)"swift_code,id,name", (QFilter[])new QFilter[]{adviCnapsCodeFilter});
            return finoOrg.stream().collect(Collectors.toMap(r -> r.getString("swift_code"), r -> Pair.of((Object)r.getLong("id"), (Object)r.getString("name"))));
        }
        return new HashMap<String, Pair<Long, String>>(8);
    }

    private void buildOnlineResultMapping(Map<String, Long> currencyNumToIdMap, Map<String, Pair<Long, String>> swiftCodeMap, QueryCreditResponseDetail detail, List<DynamicObject> updateLetterCreditList, Map<String, String> lcBillNoMap) {
        String lcBillNo;
        DynamicObject onlineLc = BusinessDataServiceHelper.newDynamicObject((String)"lc_onlineresult");
        onlineLc.set("creditno", (Object)detail.getCreditNo());
        onlineLc.set("currency", (Object)detail.getCurrency());
        String amount = Optional.ofNullable(detail.getAmount()).filter(r -> EmptyUtil.isNoEmpty((String)r)).orElse("0");
        onlineLc.set("amount", (Object)new BigDecimal(amount));
        onlineLc.set("contractno", (Object)detail.getContractNo());
        onlineLc.set("opendate", (Object)detail.getOpenDate());
        String contractAmount = Optional.ofNullable(detail.getContractAmount()).filter(r -> EmptyUtil.isNoEmpty((String)r)).orElse("0");
        onlineLc.set("contractamount", (Object)new BigDecimal(contractAmount));
        onlineLc.set("credittype", (Object)detail.getCreditType());
        onlineLc.set("creditForm", (Object)detail.getCreditForm());
        onlineLc.set("creditmode", (Object)detail.getCreditMode());
        onlineLc.set("moreproportion", (Object)detail.getMoreProportion());
        onlineLc.set("lessproportion", (Object)detail.getLessProportion());
        onlineLc.set("duedate", (Object)detail.getDueDate());
        onlineLc.set("dueaddress", (Object)detail.getDueAddress());
        onlineLc.set("applicantname", (Object)detail.getApplicantName());
        onlineLc.set("applicantaddressen", (Object)detail.getApplicantAddressEN());
        onlineLc.set("countername", (Object)detail.getCounterName());
        onlineLc.set("counteraddress", (Object)detail.getCounterAddress());
        onlineLc.set("characcno", (Object)detail.getCharAccNo());
        onlineLc.set("charcurrency", (Object)detail.getCharCurrency());
        onlineLc.set("costbear", (Object)detail.getCostBear());
        onlineLc.set("advicnapscode", (Object)detail.getAdviCnapsCode());
        onlineLc.set("adviaddress", (Object)detail.getAdviAddress());
        onlineLc.set("forwardcnapscode", (Object)detail.getForwardCnapsCode());
        onlineLc.set("forwardaddress", (Object)detail.getForwardAddress());
        onlineLc.set("avwtbank", (Object)detail.getAvWtBank());
        onlineLc.set("avwtbankbic", (Object)detail.getAvWtBankBic());
        onlineLc.set("avwtbanknmadd", (Object)detail.getAvWtBankNmAdd());
        onlineLc.set("coninstructions", (Object)detail.getConInstructions());
        onlineLc.set("acceptorcnapscode", (Object)detail.getAcceptorCnapsCode());
        onlineLc.set("acceptoraddress", (Object)detail.getAcceptorAddress());
        onlineLc.set("draftcustflg", (Object)detail.getDraftCustFlg());
        onlineLc.set("cashway", (Object)detail.getCashWay());
        onlineLc.set("draftproportion", (Object)detail.getDraftProportion());
        String draftAmt = Optional.ofNullable(detail.getDraftAmt()).filter(r -> EmptyUtil.isNoEmpty((String)r)).orElse("0");
        onlineLc.set("draftamt", (Object)new BigDecimal(draftAmt));
        onlineLc.set("paytype", (Object)detail.getPayType());
        onlineLc.set("paydays", (Object)detail.getPayDays());
        onlineLc.set("mixdraftinvproportion", (Object)detail.getMixDraftInvProportion());
        String mixDraftInvAmt = Optional.ofNullable(detail.getMixDraftInvAmt()).filter(r -> EmptyUtil.isNoEmpty((String)r)).orElse("0");
        onlineLc.set("mixdraftinvamt", (Object)new BigDecimal(mixDraftInvAmt));
        onlineLc.set("mixtenortype", (Object)detail.getMixTenorType());
        onlineLc.set("mixtenordays", (Object)detail.getMixTenorDays());
        onlineLc.set("explain_tag", (Object)detail.getExplain());
        onlineLc.set("draweecnapscode", (Object)detail.getDraweeCnapsCode());
        onlineLc.set("draweeaddress", (Object)detail.getDraweeAddress());
        onlineLc.set("ispartship", (Object)detail.getIsPartShip());
        onlineLc.set("istranship", (Object)detail.getIsTranShip());
        onlineLc.set("shipdate", (Object)detail.getShipDate());
        onlineLc.set("lastshipdate", (Object)detail.getLastShipDate());
        onlineLc.set("presentperiod", (Object)detail.getPresentPeriod());
        onlineLc.set("presentday", (Object)detail.getPresentDay());
        onlineLc.set("deliveryport", (Object)detail.getDeliveryPort());
        onlineLc.set("startair", (Object)detail.getStartAir());
        onlineLc.set("terminiair", (Object)detail.getTerminiAir());
        onlineLc.set("gasdescription_tag", (Object)detail.getGasDescription());
        onlineLc.set("termini", (Object)detail.getTermini());
        onlineLc.set("docclause_tag", (Object)detail.getDocClause());
        onlineLc.set("addclause_tag", (Object)detail.getAddClause());
        onlineLc.set("otherbankinstruction_tag", (Object)detail.getOtherBankInstruction());
        onlineLc.set("abtimes", (Object)detail.getAbTimes());
        String spotArriveAmt = Optional.ofNullable(detail.getSpotArriveAmt()).filter(r -> EmptyUtil.isNoEmpty((String)r)).orElse("0");
        onlineLc.set("spotarriveamt", (Object)new BigDecimal(spotArriveAmt));
        String forwardArriveAmt = Optional.ofNullable(detail.getForwardArriveAmt()).filter(r -> EmptyUtil.isNoEmpty((String)r)).orElse("0");
        onlineLc.set("forwardarriveamt", (Object)new BigDecimal(forwardArriveAmt));
        String payAmtDone = Optional.ofNullable(detail.getPayAmtDone()).filter(r -> EmptyUtil.isNoEmpty((String)r)).orElse("0");
        onlineLc.set("payamtdone", (Object)new BigDecimal(payAmtDone));
        onlineLc.set("creditstatus", (Object)detail.getCreditStatus());
        String issuingBankBIC = detail.getIssuingBankBIC();
        onlineLc.set("issuingbankbic", (Object)issuingBankBIC);
        Pair<Long, String> bicPair = swiftCodeMap.get(issuingBankBIC);
        if (EmptyUtil.isNoEmpty(bicPair)) {
            onlineLc.set("bank", bicPair.getLeft());
        }
        onlineLc.set("org", this.paraMap.get("org"));
        onlineLc.set("serialnumber", (Object)detail.getDetailBizNo());
        onlineLc.set("currencyid", (Object)currencyNumToIdMap.get(detail.getCurrency()));
        String openDate = detail.getOpenDate();
        if (EmptyUtil.isNoEmpty((String)openDate)) {
            onlineLc.set("bizdate", (Object)DateUtils.stringToDate((String)openDate, (String)"yyyyMMdd"));
        }
        if (EmptyUtil.isNoEmpty((String)(lcBillNo = lcBillNoMap.get(detail.getCreditNo())))) {
            onlineLc.set("lcbillno", (Object)lcBillNo);
            onlineLc.set("isregister", (Object)Boolean.TRUE);
        }
        updateLetterCreditList.add(onlineLc);
    }

    private List<QueryCreditResponseDetail> getQueryCreditResponseDetails(String resultBody) {
        QueryCreditResponseBody responseBody = (QueryCreditResponseBody)JSON.parseObject((String)resultBody, QueryCreditResponseBody.class);
        List detailList = responseBody.getCredits();
        this.ebResult.setKeepFlag(responseBody.getKeepFlag());
        this.ebResult.setPageNum(responseBody.getPageNum());
        return detailList;
    }

    private Map<String, String> getDbLcBillNo(List<QueryCreditResponseDetail> detailList, Long orgId, Long bankType, Date startDate, Date endDate) {
        HashMap<String, String> result = new HashMap<String, String>(detailList.size());
        List creditNoList = detailList.stream().map(r -> r.getCreditNo()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("creditno", "in", creditNoList);
        qFilter.and(new QFilter("org", "=", (Object)orgId));
        qFilter.and(new QFilter("bank.bank_cate", "=", (Object)bankType));
        qFilter.and("bizdate", ">=", (Object)startDate);
        qFilter.and("bizdate", "<=", (Object)endDate);
        DynamicObjectCollection dbLcCols = QueryServiceHelper.query((String)"lc_lettercredit", (String)"creditno,billno", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dbLcCols)) {
            dbLcCols.stream().forEach(r -> result.put(r.getString("creditno"), r.getString("billno")));
        }
        return result;
    }
}

