/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackOperateEnum;
import kd.tmc.lc.business.validate.resource.LcBusResourceEnum;
import kd.tmc.lc.common.mservice.LcInvokeCasService;

public class LetterCreditOpenHelper {
    private static final Log logger = LogFactory.getLog(LetterCreditOpenHelper.class);

    public static void letterCreditWriteBackPay(List<DynamicObject> letterBills, String operate) {
        if (EmptyUtil.isEmpty(letterBills = LetterCreditOpenHelper.isLetterOpen(letterBills, operate))) {
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                OperationResult result = LetterCreditOpenHelper.writeBackPayInvoke(letterBills, operate);
                if (result != null && !result.isSuccess()) {
                    String errorMsg = result.getMessage();
                    List errorInfos = result.getAllErrorOrValidateInfo();
                    if (EmptyUtil.isNoEmpty((Object)errorInfos)) {
                        errorMsg = ((IOperateInfo)errorInfos.get(0)).getMessage();
                    }
                    throw new KDBizException(LcBusResourceEnum.LetterCreditOpenHelper_0.loadKDString(errorMsg));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public static OperationResult writeBackPayInvoke(List<DynamicObject> letterBills, String operate) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        if (EmptyUtil.isEmpty(letterBills) || EmptyUtil.isEmpty((String)operate)) {
            return null;
        }
        ArrayList payBillInfoList = new ArrayList(letterBills.size());
        HashMap<String, Object> payBillInfo = null;
        for (DynamicObject letterBill : letterBills) {
            payBillInfo = new HashMap<String, Object>();
            payBillInfo.put("payBillId", letterBill.getLong("srcbillid"));
            payBillInfo.put("lcBillId", letterBill.getLong("id"));
            payBillInfo.put("creditNo", letterBill.getString("billno"));
            payBillInfo.put("settletNumber", letterBill.getString("billno"));
            payBillInfo.put("orgId", LetterCreditOpenHelper.getDynPk(letterBill.getDynamicObject("org")));
            payBillInfo.put("bankId", LetterCreditOpenHelper.getDynPk(letterBill.getDynamicObject("bank")));
            payBillInfo.put("currencyId", LetterCreditOpenHelper.getDynPk(letterBill.getDynamicObject("currency")));
            payBillInfo.put("amount", letterBill.getBigDecimal("amount"));
            payBillInfo.put("benefiterType", letterBill.getString("benefitertype"));
            payBillInfo.put("beneficiaryName", letterBill.getString("benefiterother"));
            payBillInfoList.add(payBillInfo);
        }
        params.put("operation", operate);
        params.put("payBillInfoList", payBillInfoList);
        logger.info("writeBackPayInvoke param:{}", (Object)SerializationUtils.toJsonString(params));
        OperationResult result = LcInvokeCasService.invokeLetterOpen((Object[])new Object[]{params});
        logger.info("writeBackPayInvoke result:{}", (Object)result);
        return result;
    }

    private static List<DynamicObject> isLetterOpen(List<DynamicObject> letterBills, String operate) {
        ArrayList<DynamicObject> letters = new ArrayList<DynamicObject>();
        for (DynamicObject letterBill : letterBills) {
            long sourceBillId = letterBill.getLong("srcbillid");
            String sourceBillType = letterBill.getString("sourcebilltype");
            DynamicObjectCollection billEntrys = letterBill.getDynamicObjectCollection("billentry");
            if ((PayBillWriteBackOperateEnum.UNAUDIT.getValue().equals(operate) || PayBillWriteBackOperateEnum.DELETE.getValue().equals(operate)) && EmptyUtil.isNoEmpty((DynamicObjectCollection)billEntrys)) {
                letters.add(letterBill);
                continue;
            }
            if ("cas_paybill".equals(sourceBillType) && EmptyUtil.isNoEmpty((Long)sourceBillId)) {
                DynamicObjectCollection entrys = letterBill.getDynamicObjectCollection("billentry");
                List emptyEntrys = entrys.stream().filter(o -> EmptyUtil.isEmpty((Object)o.get("e_createtime"))).collect(Collectors.toList());
                for (DynamicObject entry : emptyEntrys) {
                    entry.set("e_createtime", (Object)DateUtils.getCurrentTime());
                }
                letters.add(letterBill);
                continue;
            }
            logger.info("sourceBillId:{}, sourceBillType:{}", (Object)sourceBillId, (Object)sourceBillType);
        }
        return letters;
    }

    private static long getDynPk(DynamicObject obj) {
        return obj != null ? obj.getLong("id") : 0L;
    }
}

