/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.init;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.DataSourceEnum;
import kd.tmc.lc.common.enums.TradeChannelEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class LetterCreditFinishInitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("applydate");
        sic.add("creditno");
        sic.add("creditstatus");
        sic.add("bizcontactor");
        sic.add("bizcontactinfo");
        sic.add("applyaddress");
        sic.add("benefitertype");
        sic.add("benefiter");
        sic.add("benefiterother");
        sic.add("benefitcountry");
        sic.add("benefitaddress");
        sic.add("bankaddress");
        sic.add("reimbursingbank");
        sic.add("confirmingbank");
        sic.add("negotiatingbank");
        sic.add("validdate");
        sic.add("dealbillterm");
        sic.add("dealbilltermstart");
        sic.add("validaddress");
        sic.add("dealbilltermend");
        sic.add("lastdate");
        sic.add("cargocountry");
        sic.add("creditlimit");
        sic.add("creditcurrency");
        sic.add("creditamt");
        sic.add("transportway");
        sic.add("startplace");
        sic.add("destination");
        sic.add("unloadplace");
        sic.add("isbatch");
        sic.add("istransfer");
        sic.add("remark");
        sic.add("creator");
        sic.add("createtime");
        sic.add("modifier");
        sic.add("modifytime");
        sic.add("lowstr");
        sic.add("amountscalelow");
        sic.add("upperstr");
        sic.add("amountscaleupper");
        sic.add("noticebank");
        sic.add("basenoticebank");
        sic.add("iscancel");
        sic.add("ismakeover");
        sic.add("isnegotiating");
        sic.add("promisrate");
        sic.add("suretycur");
        sic.add("suretymoney");
        sic.add("totalsuretymoney");
        sic.add("creditamount");
        sic.add("currency");
        sic.add("arrivalentry");
        sic.add("arrivalentry.a_arrivalno");
        sic.add("arrivalentry.a_arrivaldate");
        sic.add("arrivalentry.a_arrivalamount");
        sic.add("arrivalentry.a_arrivalway");
        sic.add("arrivalentry.a_endacceptdate");
        sic.add("arrivalentry.a_endpaydate");
        sic.add("arrivalentry.a_doneamount");
        sic.add("entry_gcontract");
        sic.add("entry_gcontract.gcontract");
        sic.add("entry_gcontract.gamount");
        sic.add("entry_gcontract.gratio");
        sic.add("entry_gcontract.gcontractcurrency");
        sic.add("entry_gcontract.gexchrate");
        sic.add("entry_gcontract.gcomment");
        sic.add("entry_gcontract.gsrcbilltype");
        sic.add("entry_gcontract.gsrcbillid");
        sic.add("entry_surety");
        sic.add("entry_surety.suretybill");
        sic.add("entry_surety.suretyinvestorgtype");
        sic.add("entry_surety.suretyfinorg");
        sic.add("entry_surety.suretyfinorgother");
        sic.add("entry_surety.suretycurrency");
        sic.add("entry_surety.suretyamount");
        sic.add("entry_surety.suretysurplusamount");
        sic.add("entry_surety.suretyaccount");
        sic.add("entry_surety.suretyintdate");
        sic.add("entry_surety.suretyexpiredate");
        sic.add("entry_surety.suretyterm");
        sic.add("entry_surety.suretysource");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> letterCreditList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject letterCreditInit : dataEntities) {
            letterCreditInit.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            letterCreditInit.set("modifier", (Object)RequestContext.get().getCurrUserId());
            letterCreditInit.set("modifytime", (Object)new Date());
            DynamicObject letterCredit = TmcDataServiceHelper.newDynamicObject((String)"lc_lettercredit");
            this.copyProperties(letterCreditInit, letterCredit);
            letterCredit.set("applydate", (Object)new Date());
            letterCredit.set("bizcontactor", (Object)RequestContext.get().getCurrUserId());
            letterCredit.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            letterCredit.set("isinit", (Object)Boolean.TRUE);
            letterCredit.set("buyerint", (Object)BaseEnableEnum.DISABLE.getValue());
            String billNo = CodeRuleServiceHelper.getNumber((String)"lc_lettercredit", (DynamicObject)letterCredit, (String)String.valueOf(letterCredit.getDynamicObject("org").getPkValue()));
            letterCredit.set("billno", (Object)billNo);
            letterCredit.set("datasources", (Object)DataSourceEnum.HAND.getValue());
            letterCredit.set("tradechannel", (Object)TradeChannelEnum.OFFLINE.getValue());
            DynamicObjectCollection arrivalEntryList = letterCreditInit.getDynamicObjectCollection("arrivalentry");
            BigDecimal arrivalAmountSum = Constants.ZERO;
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)arrivalEntryList)) {
                for (DynamicObject arrivalEntry : arrivalEntryList) {
                    arrivalAmountSum = arrivalAmountSum.add(arrivalEntry.getBigDecimal("a_arrivalamount"));
                }
            }
            letterCredit.set("totalarramount", (Object)arrivalAmountSum);
            BigDecimal actualAmount = LetterCreditHelper.getAmount((DynamicObject)letterCredit);
            DynamicObject currency = letterCredit.getDynamicObject("currency");
            actualAmount = actualAmount.setScale(LetterCreditHelper.getAmtprecision((DynamicObject)currency), RoundingMode.HALF_UP);
            letterCredit.set("notarramount", (Object)actualAmount.subtract(arrivalAmountSum));
            LetterCreditHelper.setIsSurety((DynamicObject)letterCredit);
            letterCreditList.add(letterCredit);
        }
        SaveServiceHelper.update((DynamicObject[])dataEntities);
        SaveServiceHelper.save((DynamicObject[])letterCreditList.toArray(new DynamicObject[0]));
        HashMap<String, DynamicObject> letterCreditMap = new HashMap<String, DynamicObject>(letterCreditList.size());
        for (DynamicObject letterCredit : letterCreditList) {
            letterCreditMap.put(letterCredit.getString("creditno"), letterCredit);
        }
        this.saveArrivalBillList(dataEntities, letterCreditMap);
        GuaranteeUseHelper.saveGuaranteeUse((DynamicObject[])letterCreditList.toArray(new DynamicObject[0]), (String[])new String[0]);
        GuaranteeUseHelper.confirmGuaranteeUse((DynamicObject[])letterCreditList.toArray(new DynamicObject[0]));
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbd", (String)"suretyService", (String)"generate", (Object[])new Object[]{letterCreditList.toArray(new DynamicObject[0]), "lc_lettercredit"});
    }

    private void saveArrivalBillList(DynamicObject[] dataEntities, Map<String, DynamicObject> letterCreditMap) {
        ArrayList<Object> arrivalBillList = new ArrayList<Object>();
        for (DynamicObject letterCreditInit : dataEntities) {
            DynamicObject letterCredit = letterCreditMap.get(letterCreditInit.getString("creditno"));
            if (EmptyUtil.isEmpty((DynamicObject)letterCredit)) continue;
            DynamicObjectCollection arrivalEntryList = letterCreditInit.getDynamicObjectCollection("arrivalentry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)arrivalEntryList)) {
                DynamicObject creditLimit = letterCredit.getDynamicObject("creditlimit");
                if (!EmptyUtil.isNoEmpty((DynamicObject)creditLimit)) continue;
                Iterator useBean = LetterCreditHelper.getCreditLimitUseInfo((DynamicObject)letterCredit, null, (BigDecimal)Constants.ZERO);
                useBean.setCreditLimitNo(creditLimit.getString("number"));
                useBean.setPreOccupy(false);
                CreditLimitServiceHelper.autoUseCreditLimit((CreditLimitUseBean)useBean);
                CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)letterCredit, null, (boolean)false, (Date)letterCredit.getDate("bizdate"));
                continue;
            }
            BigDecimal doneAmountSum = Constants.ZERO;
            for (DynamicObject arrivalEntry : arrivalEntryList) {
                Object[] arrivalBills = TmcBotpHelper.push((DynamicObject)letterCredit, (String)"lc_arrival");
                if (EmptyUtil.isEmpty((Object[])arrivalBills)) continue;
                for (Object arrivalBill : arrivalBills) {
                    String billNo = CodeRuleServiceHelper.getNumber((String)"lc_arrival", (DynamicObject)arrivalBill, (String)String.valueOf(arrivalBill.getDynamicObject("org").getPkValue()));
                    arrivalBill.set("billno", (Object)billNo);
                    arrivalBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                    arrivalBill.set("arrivalno", arrivalEntry.get("a_arrivalno"));
                    arrivalBill.set("arrivaldate", arrivalEntry.get("a_arrivaldate"));
                    BigDecimal arrivalAmt = arrivalEntry.getBigDecimal("a_arrivalamount");
                    arrivalBill.set("arrivalamount", (Object)arrivalAmt);
                    arrivalBill.set("arrivalway", arrivalEntry.get("a_arrivalway"));
                    arrivalBill.set("endacceptdate", arrivalEntry.get("a_endacceptdate"));
                    arrivalBill.set("endpaydate", arrivalEntry.get("a_endpaydate"));
                    BigDecimal doneAmt = arrivalEntry.getBigDecimal("a_doneamount");
                    arrivalBill.set("doneamount", (Object)doneAmt);
                    arrivalBill.set("todoamount", (Object)arrivalAmt.subtract(doneAmt));
                    arrivalBill.set("isinit", (Object)Boolean.TRUE);
                    doneAmountSum = doneAmountSum.add(doneAmt);
                    if (arrivalAmt.compareTo(doneAmt) == 0) {
                        arrivalBill.set("arrivalstatus", (Object)ArrivalStatusEnum.ARRIVAL_PAY.getValue());
                    } else if (arrivalAmt.compareTo(doneAmt) > 0) {
                        arrivalBill.set("arrivalstatus", (Object)ArrivalStatusEnum.ARRIVAL_CONFIRM.getValue());
                    }
                    arrivalBillList.add(arrivalBill);
                    TmcBotpHelper.saveRelation((DynamicObject)letterCredit, (DynamicObject)arrivalBill);
                }
            }
            DynamicObject creditLimit = letterCredit.getDynamicObject("creditlimit");
            if (!EmptyUtil.isNoEmpty((DynamicObject)creditLimit)) continue;
            BigDecimal creditAmount = letterCredit.getBigDecimal("creditamount");
            BigDecimal amount = LetterCreditHelper.getAmount((DynamicObject)letterCredit);
            doneAmountSum = doneAmountSum.multiply(creditAmount).divide(amount, LetterCreditHelper.getAmtprecision((DynamicObject)letterCredit.getDynamicObject("currency")), RoundingMode.DOWN);
            CreditLimitUseBean useBean = LetterCreditHelper.getCreditLimitUseInfo((DynamicObject)letterCredit, null, (BigDecimal)doneAmountSum);
            useBean.setCreditLimitNo(creditLimit.getString("number"));
            useBean.setPreOccupy(Boolean.valueOf(false));
            CreditLimitServiceHelper.autoUseCreditLimit((CreditLimitUseBean)useBean);
            CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)letterCredit, null, (boolean)false, (Date)letterCredit.getDate("bizdate"));
        }
        SaveServiceHelper.save((DynamicObject[])arrivalBillList.toArray(new DynamicObject[0]));
    }

    private void copyProperties(DynamicObject srcObj, DynamicObject targetObj) {
        DataEntityPropertyCollection properties = targetObj.getDynamicObjectType().getProperties();
        List srcObjProps = srcObj.getDynamicObjectType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toList());
        for (IDataEntityProperty property : properties) {
            if (property instanceof DynamicLocaleProperty) continue;
            String propName = property.getName();
            if (Arrays.asList("id", "seq", "number").contains(propName) || !srcObjProps.contains(propName)) continue;
            targetObj.set(propName, srcObj.get(propName));
        }
    }
}

