/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.init;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.PresentStatusEnum;

public class ReceiptBillFinishInitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("creditno");
        sic.add("creditstatus");
        sic.add("bizcontactor");
        sic.add("bizcontactinfo");
        sic.add("applyaddress");
        sic.add("benefitertype");
        sic.add("benefiter");
        sic.add("benefiterother");
        sic.add("benefitcountry");
        sic.add("benefitaddress");
        sic.add("bankaddress");
        sic.add("reimbursingbank");
        sic.add("confirmingbank");
        sic.add("negotiatingbank");
        sic.add("validdate");
        sic.add("dealbillterm");
        sic.add("dealbilltermstart");
        sic.add("validaddress");
        sic.add("dealbilltermend");
        sic.add("lastdate");
        sic.add("cargocountry");
        sic.add("lowstr");
        sic.add("upperstr");
        sic.add("transportway");
        sic.add("startplace");
        sic.add("destination");
        sic.add("unloadplace");
        sic.add("isbatch");
        sic.add("istransfer");
        sic.add("remark");
        sic.add("creator");
        sic.add("createtime");
        sic.add("modifier");
        sic.add("modifytime");
        sic.add("noticebank");
        sic.add("basenoticebank");
        sic.add("iscancel");
        sic.add("ismakeover");
        sic.add("isnegotiating");
        sic.add("presententry");
        sic.add("presententry.p_presentno");
        sic.add("presententry.p_presentdate");
        sic.add("presententry.p_presentamount");
        sic.add("presententry.p_arrivalway");
        sic.add("presententry.p_endacceptdate");
        sic.add("presententry.p_endpaydate");
        sic.add("presententry.p_doneamount");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> receiptBillList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject receiptBillInit : dataEntities) {
            receiptBillInit.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            receiptBillInit.set("modifier", (Object)RequestContext.get().getCurrUserId());
            receiptBillInit.set("modifytime", (Object)new Date());
            DynamicObject receiptBill = TmcDataServiceHelper.newDynamicObject((String)"lc_receipt");
            this.copyProperties(receiptBillInit, receiptBill);
            receiptBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            receiptBill.set("applydate", (Object)new Date());
            receiptBill.set("isinit", (Object)Boolean.TRUE);
            String billNo = CodeRuleServiceHelper.getNumber((String)"lc_receipt", (DynamicObject)receiptBill, (String)String.valueOf(receiptBill.getDynamicObject("org").getPkValue()));
            receiptBill.set("billno", (Object)billNo);
            DynamicObjectCollection receiptEntryList = receiptBillInit.getDynamicObjectCollection("presententry");
            BigDecimal presentAmountSum = Constants.ZERO;
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)receiptEntryList)) {
                for (DynamicObject receiptEntry : receiptEntryList) {
                    presentAmountSum = presentAmountSum.add(receiptEntry.getBigDecimal("p_presentamount"));
                }
            }
            receiptBill.set("totalarramount", (Object)presentAmountSum);
            BigDecimal amount = receiptBill.getBigDecimal("amount");
            BigDecimal amountUpper = receiptBill.getBigDecimal("amountscaleupper");
            BigDecimal actualAmount = amount.multiply(BigDecimal.ONE.add(amountUpper.divide(Constants.ONE_HUNDRED, 4, 4)));
            receiptBill.set("notarramount", (Object)actualAmount.subtract(presentAmountSum));
            receiptBillList.add(receiptBill);
        }
        SaveServiceHelper.update((DynamicObject[])dataEntities);
        SaveServiceHelper.save((DynamicObject[])receiptBillList.toArray(new DynamicObject[0]));
        HashMap<String, DynamicObject> receiptBillMap = new HashMap<String, DynamicObject>(dataEntities.length);
        for (DynamicObject receiptBill : receiptBillList) {
            receiptBillMap.put(receiptBill.getString("creditno"), receiptBill);
        }
        this.savePresentBillList(dataEntities, receiptBillMap);
    }

    private void savePresentBillList(DynamicObject[] dataEntities, Map<String, DynamicObject> receiptBillMap) {
        ArrayList<Object> presentBillList = new ArrayList<Object>(dataEntities.length);
        for (DynamicObject receiptBillInit : dataEntities) {
            DynamicObject receiptBill;
            DynamicObjectCollection receiptEntryList = receiptBillInit.getDynamicObjectCollection("presententry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)receiptEntryList) || EmptyUtil.isEmpty((DynamicObject)(receiptBill = receiptBillMap.get(receiptBillInit.getString("creditno"))))) continue;
            for (DynamicObject receiptEntry : receiptEntryList) {
                Object[] presentBills = TmcBotpHelper.push((DynamicObject)receiptBill, (String)"lc_present");
                if (EmptyUtil.isEmpty((Object[])presentBills)) continue;
                for (Object presentBill : presentBills) {
                    String billNo = CodeRuleServiceHelper.getNumber((String)"lc_present", (DynamicObject)presentBill, (String)String.valueOf(presentBill.getDynamicObject("org").getPkValue()));
                    presentBill.set("billno", (Object)billNo);
                    presentBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                    presentBill.set("arrivalno", receiptEntry.get("p_presentno"));
                    presentBill.set("arrivaldate", receiptEntry.get("p_presentdate"));
                    BigDecimal presentAmt = receiptEntry.getBigDecimal("p_presentamount");
                    presentBill.set("arrivalamount", (Object)presentAmt);
                    presentBill.set("arrivalway", receiptEntry.get("p_arrivalway"));
                    presentBill.set("endacceptdate", receiptEntry.get("p_endacceptdate"));
                    presentBill.set("endpaydate", receiptEntry.get("p_endpaydate"));
                    BigDecimal doneAmt = receiptEntry.getBigDecimal("p_doneamount");
                    presentBill.set("doneamount", (Object)doneAmt);
                    presentBill.set("todoamount", (Object)presentAmt.subtract(doneAmt));
                    presentBill.set("isinit", (Object)Boolean.TRUE);
                    if (presentAmt.compareTo(doneAmt) == 0) {
                        presentBill.set("arrivalstatus", (Object)PresentStatusEnum.PRESENT_RECIECT.getValue());
                    } else if (presentAmt.compareTo(doneAmt) > 0) {
                        presentBill.set("arrivalstatus", (Object)PresentStatusEnum.PRESENT_CONFIRM.getValue());
                    }
                    presentBillList.add(presentBill);
                    TmcBotpHelper.saveRelation((DynamicObject)receiptBill, (DynamicObject)presentBill);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])presentBillList.toArray(new DynamicObject[0]));
    }

    private void copyProperties(DynamicObject srcObj, DynamicObject targetObj) {
        DataEntityPropertyCollection properties = targetObj.getDynamicObjectType().getProperties();
        List srcObjProps = srcObj.getDynamicObjectType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toList());
        for (IDataEntityProperty property : properties) {
            if (property instanceof DynamicLocaleProperty) continue;
            String propName = property.getName();
            if (Arrays.asList("id", "seq", "number").contains(propName) || !srcObjProps.contains(propName)) continue;
            targetObj.set(propName, srcObj.get(propName));
        }
    }
}

