/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.lettercredit;

import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class LetterCreditAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("org");
        sic.add("benefitertype");
        sic.add("benefiter");
        sic.add("creditapplyno");
        sic.add("isclosed");
        sic.add("applyreason");
        sic.add("tradechannel");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject letterCredit : dataEntities) {
            Object[] receiptBills;
            String creditNo;
            QFilter receiptFilter;
            boolean exists;
            String creditApplyNo = letterCredit.getString("creditapplyno");
            if (EmptyUtil.isNoEmpty((String)creditApplyNo)) {
                QFilter filter = new QFilter("billno", "=", (Object)creditApplyNo);
                DynamicObject applyBill = TmcDataServiceHelper.loadSingle((String)"lc_bizapply", (String)"id,lettercredit", (QFilter[])filter.toArray());
                applyBill.set("lettercredit", (Object)letterCredit);
                TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{applyBill});
            }
            letterCredit.set("isclosed", (Object)false);
            String benefitType = letterCredit.getString("benefitertype");
            if (!"bos_org".equals(benefitType) || !this.recCreditSwitch(letterCredit) || (exists = TmcDataServiceHelper.exists((String)"lc_receipt", (QFilter[])(receiptFilter = new QFilter("creditno", "=", (Object)(creditNo = letterCredit.getString("creditno")))).toArray())) || EmptyUtil.isEmpty((Object[])(receiptBills = TmcBotpHelper.push((DynamicObject)letterCredit, (String)"lc_receipt")))) continue;
            for (Object receiptBill : receiptBills) {
                receiptBill.set("bizcontactor", null);
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("WF", "TRUE");
            OperationResult submitResult = TmcOperateServiceHelper.execOperate((String)"submit", (String)"lc_receipt", (DynamicObject[])receiptBills, (OperateOption)option);
            if (!submitResult.isSuccess() || EmptyUtil.isEmpty((Collection)submitResult.getSuccessPkIds())) continue;
            TmcOperateServiceHelper.execOperate((String)"audit", (String)"lc_receipt", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
            TmcBotpHelper.deleteRation((String)"lc_receipt", (Long)letterCredit.getLong("id"), (Long)((Long)submitResult.getSuccessPkIds().get(0)));
        }
    }

    private boolean recCreditSwitch(DynamicObject letterCredit) {
        Long orgId = letterCredit.getDynamicObject("benefiter").getLong("id");
        return LetterCreditHelper.checkRecCompCredit((DynamicObject)letterCredit, (long)orgId);
    }
}

