/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.lettercredit;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackOperateEnum;
import kd.tmc.lc.business.opservice.helper.LetterCreditOpenHelper;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class LetterCreditDelService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(LetterCreditDelService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billno");
        sic.add("creditlimit");
        sic.add("bank");
        sic.add("currency");
        sic.add("credittype");
        sic.add("amount");
        sic.add("amountscaleupper");
        sic.add("creditapplyno");
        sic.add("sourcebilltype");
        sic.add("srcbillid");
        sic.add("resubmitsrcno");
        sic.add("creditno");
        sic.add("org");
        sic.add("benefitertype");
        sic.add("benefiterother");
        sic.add("e_billtype");
        sic.add("e_billid");
        sic.add("e_createtime");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject letterCredit : dataEntities) {
            if ("lc_lettercredit_init".equals(letterCredit.getDataEntityType().getName())) continue;
            DynamicObject sourceBill = TmcDataServiceHelper.loadSingle((String)"lc_bizapply", (String)"id,billno,creditlimit,amount,amountscaleupper", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)letterCredit.getString("creditapplyno"))});
            if (EmptyUtil.isNoEmpty((DynamicObject)letterCredit.getDynamicObject("creditlimit"))) {
                logger.info("creditlimit is not empty");
                if (EmptyUtil.isNoEmpty((DynamicObject)sourceBill)) {
                    logger.info("sourceBill is not empty");
                    CreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)letterCredit, (DynamicObject)sourceBill, (boolean)true);
                    String message = creditLimitInfo.getMessage();
                    this.getOperationResult().setMessage(message);
                } else {
                    logger.info("sourceBill is empty");
                    CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)letterCredit, null, (boolean)true);
                }
            } else {
                DynamicObject applyCreditLimit;
                logger.info("creditlimit is empty");
                if (EmptyUtil.isNoEmpty((DynamicObject)sourceBill) && EmptyUtil.isNoEmpty((DynamicObject)(applyCreditLimit = sourceBill.getDynamicObject("creditlimit")))) {
                    BigDecimal amt = LetterCreditHelper.getAmount((DynamicObject)sourceBill);
                    CreditLimitServiceHelper.cancelReturnCreditLimit((DynamicObject)letterCredit, (DynamicObject)sourceBill, (boolean)true, (BigDecimal)amt, null);
                }
            }
            LetterCreditHelper.deleteCreditUse((String)"lc_lettercredit", (long)letterCredit.getLong("id"));
            this.removeBillNo(letterCredit);
            this.writeBackSrcBillWhenResubmit(letterCredit);
            DynamicObject sourBill = TmcBotpHelper.getSourceBill((String)"lc_lettercredit", (Object)letterCredit.getPkValue(), (String)"lc_bizapply");
            logger.info("creditlimit sourBill" + (sourBill == null));
            if (!EmptyUtil.isNoEmpty((DynamicObject)sourBill)) continue;
            TmcBotpHelper.deleteRation((String)"lc_lettercredit", (Long)sourBill.getLong("id"), (Long)letterCredit.getLong("id"));
        }
        LetterCreditOpenHelper.letterCreditWriteBackPay(Arrays.stream(dataEntities).collect(Collectors.toList()), PayBillWriteBackOperateEnum.DELETE.getValue());
    }

    private void removeBillNo(DynamicObject letterCredit) {
        String sourceBillType = letterCredit.getString("sourcebilltype");
        if (EmptyUtil.isNoEmpty((String)sourceBillType) && "lc_onlineresult".equals(sourceBillType)) {
            QFilter qFilter = new QFilter("lcbillno", "=", (Object)letterCredit.getString("billno"));
            DynamicObject onlineResult = TmcDataServiceHelper.loadSingle((String)"lc_onlineresult", (String)"lcbillno,isregister", (QFilter[])new QFilter[]{qFilter});
            onlineResult.set("lcbillno", (Object)"");
            onlineResult.set("isregister", (Object)Boolean.FALSE);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{onlineResult});
        }
    }

    private void writeBackSrcBillWhenResubmit(DynamicObject letterCredit) {
        String srcBillNo = letterCredit.getString("resubmitsrcno");
        if (EmptyUtil.isEmpty((String)srcBillNo)) {
            return;
        }
        QFilter qFilter = new QFilter("billno", "=", (Object)srcBillNo);
        qFilter.and(new QFilter("isresubmit", "=", (Object)Boolean.TRUE));
        DynamicObject srcBill = TmcDataServiceHelper.loadSingle((String)"lc_lettercredit", (String)"isresubmit", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((DynamicObject)srcBill)) {
            return;
        }
        srcBill.set("isresubmit", (Object)Boolean.FALSE);
        SaveServiceHelper.update((DynamicObject)srcBill);
    }
}

