/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.lettercredit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LetterCreditSuretyUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(LetterCreditSuretyUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try (TXHandle handle = TX.requiresNew();){
            try {
                logger.info("start upgrade lettercreditsurety type and value");
                this.dataUpgradeLc();
                this.dataUpgradeSurety();
                this.dataUpgradeCreditAmount(new String[]{"t_lc_bizapply", "t_lc_lettercredit", "t_lc_lettercredit_init"});
                logger.info("end upgrade lettercreditsurety type and value");
            }
            catch (Exception e) {
                result.setErrorInfo(e.getMessage());
                result.setSuccess(false);
                logger.info(e.getMessage());
            }
        }
        return result;
    }

    private void dataUpgradeCreditAmount(String[] tableArr) {
        for (String table : tableArr) {
            DataSet dataSet = DB.queryDataSet((String)"LetterCreditSuretyUpgradeService", (DBRoute)DBRouteConst.TMC, (String)("select t.fid,t.famount,t.famountscaleupper from " + table + " t," + table + "_e te where t.fid=te.fid and t.fguarantee not like '%3%' and (te.fcreditamount is null or te.fcreditamount=0)"));
            if (dataSet.isEmpty()) continue;
            ArrayList<Object[]> batchParam = new ArrayList<Object[]>(16);
            for (Row creditDatum : dataSet.copy()) {
                BigDecimal creditAmount = creditDatum.getBigDecimal("famount").multiply(BigDecimal.ONE.add(creditDatum.getBigDecimal("famountscaleupper").divide(Constants.ONE_HUNDRED, 6, RoundingMode.HALF_UP)));
                batchParam.add(new Object[]{creditAmount, creditDatum.getLong("fid")});
            }
            if (batchParam.isEmpty()) continue;
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)("update " + table + "_e set fcreditamount=? where fid=?"), batchParam);
        }
    }

    private void dataUpgradeSurety() {
        String suretyQuerySql = "select tll.fid,tfse.fentryid,tlle.fisinit,tll.fcreditno,tlle.fsuretymoney,tfse.fsuretyamount from t_lc_lettercredit tll,t_lc_lettercredit_e tlle,t_fbd_suretybill_e tfse where tll.fid=tlle.fid and tlle.fid=tfse.fdebtbillid and tfse.fsuretyamount=0";
        DataSet suretyData = DB.queryDataSet((String)"LetterCreditSuretyUpgradeService", (DBRoute)DBRouteConst.TMC, (String)suretyQuerySql);
        if (!suretyData.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder initBuilder = new StringBuilder();
            for (Row debtDatum : suretyData.copy()) {
                stringBuilder.append(debtDatum.getLong("fid")).append(",");
                if (!debtDatum.getBoolean("fisinit").booleanValue()) continue;
                initBuilder.append("'").append(debtDatum.getString("fcreditno")).append("',");
            }
            String idStr = stringBuilder.toString();
            idStr = idStr.length() > 0 ? idStr.substring(0, idStr.length() - 1) : idStr;
            String appendQuerySql = "select tfse.fdebtbillid,tfse.fappendamt,tfse.fdebtcurrencyid,tfsa.fcurrencyid,tfsa.forgid,tfsa.fbizdate from t_fbd_surety_append tfsa,t_fbd_suretybill_e tfse where tfsa.fid=tfse.fid and tfse.fdebtbillid in (" + idStr + ") and tfsa.fbillstatus='C' and tfse.fdebttype='lc_lettercredit'";
            DataSet appendData = DB.queryDataSet((String)"LetterCreditSuretyUpgradeService", (DBRoute)DBRouteConst.TMC, (String)appendQuerySql);
            HashMap<Long, BigDecimal> appendDebitMap = new HashMap<Long, BigDecimal>(16);
            for (Row appendDatum : appendData.copy()) {
                BigDecimal appendAmt = appendDatum.getBigDecimal("fappendamt");
                if (EmptyUtil.isEmpty((BigDecimal)appendAmt)) continue;
                Object temp = (BigDecimal)appendDebitMap.get(appendDatum.getLong("fdebtbillid"));
                temp = temp == null ? Constants.ZERO : temp;
                Long debitCurrencyId = appendDatum.getLong("fdebtcurrencyid");
                BigDecimal exchangeRate = LetterCreditSuretyUpgradeService.getRate(appendDatum.getLong("fcurrencyid"), appendDatum.getLong("forgid"), debitCurrencyId, appendDatum.getDate("fbizdate"));
                appendDebitMap.put(appendDatum.getLong("fdebtbillid"), ((BigDecimal)temp).add(appendAmt.multiply(exchangeRate)));
            }
            String releaseQuerySql = "select tfse.fdebtbillid,tfse.fappendamt,tfse.fdebtcurrencyid,tfs.fcurrencyid,tfs.forgid,tfs.famount from t_fbd_suretyreleasebill tfs,t_fbd_suretybill_e tfse where tfs.fid=tfse.fid and tfse.fdebtbillid in (" + idStr + ") and tfs.fbillstatus='C' and tfse.fdebttype='lc_lettercredit'";
            DataSet releaseData = DB.queryDataSet((String)"LetterCreditSuretyUpgradeService", (DBRoute)DBRouteConst.TMC, (String)releaseQuerySql);
            HashMap<Long, BigDecimal> releaseDebitMap = new HashMap<Long, BigDecimal>(16);
            for (Row releaseDatum : releaseData.copy()) {
                BigDecimal temp = (BigDecimal)releaseDebitMap.get(releaseDatum.getLong("fdebtbillid"));
                temp = temp == null ? Constants.ZERO : temp;
                Long debitCurrencyId = releaseDatum.getLong("fdebtcurrencyid");
                BigDecimal exchangeRate = LetterCreditSuretyUpgradeService.getRate(releaseDatum.getLong("fcurrencyid"), releaseDatum.getLong("forgid"), debitCurrencyId, new Date());
                releaseDebitMap.put(releaseDatum.getLong("fdebtbillid"), temp.subtract(exchangeRate.multiply(releaseDatum.getBigDecimal("famount"))));
            }
            HashMap<String, BigDecimal> initDebitMap = new HashMap<String, BigDecimal>(16);
            String initStr = initBuilder.toString();
            String string = initStr = initStr.length() > 0 ? initStr.substring(0, initStr.length() - 1) : initStr;
            if (initStr.length() > 0) {
                String initQuerySql = "select tlli.fid,tlli.fcreditno,tllie.ftotalsuretymoney from t_lc_lettercredit_init tlli,t_lc_lettercredit_init_e tllie where tlli.fid=tllie.fid and tlli.fbillstatus='C' and tlli.fcreditno in (" + initStr + ")";
                DataSet initData = DB.queryDataSet((String)"LetterCreditSuretyUpgradeService", (DBRoute)DBRouteConst.TMC, (String)initQuerySql);
                for (Row initDatum : initData.copy()) {
                    initDebitMap.put(initDatum.getString("fcreditno"), initDatum.getBigDecimal("ftotalsuretymoney"));
                }
            }
            ArrayList<Object[]> batchParam = new ArrayList<Object[]>(16);
            for (Row debtDatum : suretyData.copy()) {
                BigDecimal appendAmt = (BigDecimal)appendDebitMap.get(debtDatum.getLong("fid"));
                appendAmt = appendAmt == null ? Constants.ZERO : appendAmt;
                BigDecimal releaseAmt = (BigDecimal)releaseDebitMap.get(debtDatum.getLong("fid"));
                releaseAmt = releaseAmt == null ? Constants.ZERO : releaseAmt;
                BigDecimal suretyMoney = debtDatum.getBoolean("fisinit") != false && initDebitMap.get(debtDatum.getString("fcreditno")) != null ? ((BigDecimal)initDebitMap.get(debtDatum.getString("fcreditno"))).add(appendAmt).add(releaseAmt) : debtDatum.getBigDecimal("fsuretymoney").add(appendAmt).add(releaseAmt);
                suretyMoney = suretyMoney.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : suretyMoney;
                batchParam.add(new Object[]{suretyMoney, debtDatum.getLong("fentryid")});
            }
            if (!batchParam.isEmpty()) {
                DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)"update t_fbd_suretybill_e set fsuretyamount=? where fentryid=?", batchParam);
            }
        }
    }

    private void dataUpgradeLc() {
        String lcQuerySql;
        DataSet lcData;
        String lcInitQuerySql;
        DataSet lcInitData;
        ArrayList<Object[]> batchParam1;
        ArrayList<Object[]> batchParam;
        String bizApplyQuerySql = "select tlb.fid,tlbe.forgid,tlb.fcurrencyid,tlb.fapplydate,tlb.famount,tlb.famountscaleupper,tlbs.fsuretybillid from t_lc_bizapply tlb,t_lc_bizapply_e tlbe,t_lc_bizapply_s tlbs where tlb.fid=tlbe.fid and tlb.fid=tlbs.fid";
        DataSet bizApplyData = DB.queryDataSet((String)"LetterCreditSuretyUpgradeService", (DBRoute)DBRouteConst.TMC, (String)bizApplyQuerySql);
        if (!bizApplyData.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Row bizApplyDatum : bizApplyData.copy()) {
                stringBuilder.append(bizApplyDatum.getLong("fsuretybillid")).append(",");
            }
            String idStr = stringBuilder.toString();
            idStr = idStr.length() > 0 ? idStr.substring(0, idStr.length() - 1) : idStr;
            String suretyBillQuerySql = "select tfs.fid,tfs.fsuretyrate,tfs.fcurrencyid,tfs.famount from t_fbd_suretybill tfs where tfs.fid in (" + idStr + ")";
            Iterator suretyBillData = DB.queryDataSet((String)"LetterCreditSuretyUpgradeService", (DBRoute)DBRouteConst.TMC, (String)suretyBillQuerySql);
            HashMap<Long, Row> suretyMap = new HashMap<Long, Row>(16);
            for (Row suretyBillDatum : suretyBillData.copy()) {
                suretyMap.put(suretyBillDatum.getLong("fid"), suretyBillDatum);
            }
            batchParam = new ArrayList(16);
            batchParam1 = new ArrayList(16);
            for (Row bizApplyDatum : bizApplyData.copy()) {
                Iterator suretyBillDatum = (Row)suretyMap.get(bizApplyDatum.getLong("fsuretybillid"));
                if (suretyBillDatum == null) continue;
                Long currencyId = suretyBillDatum.getLong("fcurrencyid");
                BigDecimal exchangeRate = LetterCreditSuretyUpgradeService.getRate(currencyId, bizApplyDatum.getLong("forgid"), bizApplyDatum.getLong("fcurrencyid"), bizApplyDatum.getDate("fapplydate"));
                BigDecimal amount = suretyBillDatum.getBigDecimal("famount");
                BigDecimal creditAmount = bizApplyDatum.getBigDecimal("famount").multiply(BigDecimal.ONE.add(bizApplyDatum.getBigDecimal("famountscaleupper").divide(Constants.ONE_HUNDRED, 6, RoundingMode.HALF_UP)));
                BigDecimal proMisRate = this.getProMisRate(suretyBillDatum.getBigDecimal("fsuretyrate"), amount.multiply(exchangeRate), creditAmount);
                batchParam.add(new Object[]{proMisRate, currencyId, amount, amount, creditAmount.subtract(amount), bizApplyDatum.getLong("fid")});
                batchParam1.add(new Object[]{bizApplyDatum.getLong("fid")});
            }
            if (!batchParam.isEmpty()) {
                DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)"update t_lc_bizapply_e set fpromisrate=?,fsuretycur=?,fsuretymoney=?,ftotalsuretymoney=?,fcreditamount=? where fid=? and (fpromisrate is null or fpromisrate=0)", batchParam);
            }
            if (!batchParam1.isEmpty()) {
                DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)"update t_lc_bizapply set fguarantee=case when fguarantee like '%7%' then replace(fguarantee,'7','3') else concat(fguarantee,'3,') end where fguarantee not like '%3%' and fid=?", batchParam1);
            }
        }
        if (!(lcInitData = DB.queryDataSet((String)"LetterCreditSuretyUpgradeService", (DBRoute)DBRouteConst.TMC, (String)(lcInitQuerySql = "select tlli.fid,tllie.forgid,tlli.fcurrencyid,tlli.famount,tlli.famountscaleupper,tlcs.fsuretybill from t_lc_lettercredit_init tlli,t_lc_lettercredit_init_e tllie,t_lc_credit_suretyentry tlcs where tlli.fid=tllie.fid and tlli.fid=tlcs.fid"))).isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Row lcInitDatum : lcInitData.copy()) {
                stringBuilder.append(lcInitDatum.getLong("fsuretybill")).append(",");
            }
            String idStr = stringBuilder.toString();
            idStr = idStr.length() > 0 ? idStr.substring(0, idStr.length() - 1) : idStr;
            String suretyBillQuerySql = "select tfs.fid,tfs.fsuretyrate,tfs.fcurrencyid,tfs.famount from t_fbd_suretybill tfs where tfs.fid in (" + idStr + ")";
            Iterator suretyBillData = DB.queryDataSet((String)"LetterCreditSuretyUpgradeService", (DBRoute)DBRouteConst.TMC, (String)suretyBillQuerySql);
            HashMap<Long, Row> suretyMap = new HashMap<Long, Row>(16);
            for (Row suretyBillDatum : suretyBillData.copy()) {
                suretyMap.put(suretyBillDatum.getLong("fid"), suretyBillDatum);
            }
            ArrayList<Object[]> batchParam2 = new ArrayList<Object[]>(16);
            ArrayList<Object[]> batchParam12 = new ArrayList<Object[]>(16);
            for (Row lcInitDatum : lcInitData.copy()) {
                Row suretyBillDatum = (Row)suretyMap.get(lcInitDatum.getLong("fsuretybill"));
                if (suretyBillDatum == null) continue;
                Long currencyId = suretyBillDatum.getLong("fcurrencyid");
                BigDecimal exchangeRate = LetterCreditSuretyUpgradeService.getRate(currencyId, lcInitDatum.getLong("forgid"), lcInitDatum.getLong("fcurrencyid"), new Date());
                BigDecimal amount = suretyBillDatum.getBigDecimal("famount");
                BigDecimal creditAmount = lcInitDatum.getBigDecimal("famount").multiply(BigDecimal.ONE.add(lcInitDatum.getBigDecimal("famountscaleupper").divide(Constants.ONE_HUNDRED, 6, RoundingMode.HALF_UP)));
                BigDecimal proMisRate = this.getProMisRate(suretyBillDatum.getBigDecimal("fsuretyrate"), amount.multiply(exchangeRate), creditAmount);
                batchParam2.add(new Object[]{proMisRate, suretyBillDatum.getLong("fcurrencyid"), amount, amount, creditAmount.subtract(amount), lcInitDatum.getLong("fid")});
                batchParam12.add(new Object[]{lcInitDatum.getLong("fid")});
            }
            if (!batchParam2.isEmpty()) {
                DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)"update t_lc_lettercredit_init_e set fpromisrate=?,fsuretycur=?,fsuretymoney=?,ftotalsuretymoney=?,fcreditamount=? where fid=? and (fpromisrate is null or fpromisrate=0)", batchParam2);
            }
            if (!batchParam12.isEmpty()) {
                DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)"update t_lc_lettercredit_init set fguarantee=case when fguarantee like '%7%' then replace(fguarantee,'7','3') else concat(fguarantee,'3,') end where fguarantee not like '%3%' and fid=?", batchParam12);
            }
        }
        if (!(lcData = DB.queryDataSet((String)"LetterCreditSuretyUpgradeService", (DBRoute)DBRouteConst.TMC, (String)(lcQuerySql = "select tll.fid,tlle.forgid,tll.fcurrencyid as fdebtcurrencyid,tll.fapplydate,tll.famount as fdebtamount,tll.famountscaleupper,tfs.fsuretyrate,tfs.fcurrencyid,tfs.famount from t_lc_lettercredit tll,t_lc_lettercredit_e tlle,t_fbd_suretybill tfs,t_fbd_suretybill_e tfse where tll.fid = tlle.fid and tll.fid=tfse.fdebtbillid and tfs.fid=tfse.fid and (tlle.fpromisrate is null or tlle.fpromisrate=0)"))).isEmpty()) {
            Map<Long, BigDecimal> debitIdMap = new HashMap<Long, BigDecimal>(16);
            for (Row lcDatum : lcData.copy()) {
                debitIdMap.put(lcDatum.getLong("fid"), lcDatum.getBigDecimal("famount"));
            }
            debitIdMap = this.getTotalSuretyMoney(debitIdMap);
            batchParam = new ArrayList<Object[]>(16);
            batchParam1 = new ArrayList<Object[]>(16);
            for (Row lcDatum : lcData.copy()) {
                Long currencyId = lcDatum.getLong("fcurrencyid");
                BigDecimal exchangeRate = LetterCreditSuretyUpgradeService.getRate(currencyId, lcDatum.getLong("forgid"), lcDatum.getLong("fdebtcurrencyid"), lcDatum.getDate("fapplydate"));
                BigDecimal amount = lcDatum.getBigDecimal("famount");
                BigDecimal creditAmount = lcDatum.getBigDecimal("fdebtamount").multiply(BigDecimal.ONE.add(lcDatum.getBigDecimal("famountscaleupper").divide(Constants.ONE_HUNDRED, 6, RoundingMode.HALF_UP)));
                BigDecimal proMisRate = this.getProMisRate(lcDatum.getBigDecimal("fsuretyrate"), amount.multiply(exchangeRate), creditAmount);
                batchParam.add(new Object[]{proMisRate, lcDatum.getLong("fcurrencyid"), amount, debitIdMap.get(lcDatum.getLong("fid")), creditAmount.subtract(amount), lcDatum.getLong("fid")});
                batchParam1.add(new Object[]{lcDatum.getLong("fid")});
            }
            if (!batchParam.isEmpty()) {
                DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)"update t_lc_lettercredit_e set fpromisrate=?,fsuretycur=?,fsuretymoney=?,ftotalsuretymoney=?,fcreditamount=? where fid=? and (fpromisrate is null or fpromisrate=0)", batchParam);
            }
            if (!batchParam1.isEmpty()) {
                DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)"update t_lc_lettercredit set fguarantee=case when fguarantee like '%7%' then replace(fguarantee,'7','3') else concat(fguarantee,'3,') end where fguarantee not like '%3%' and fid=?", batchParam1);
            }
        }
    }

    public Map<Long, BigDecimal> getTotalSuretyMoney(Map<Long, BigDecimal> debitIdMap) {
        QFilter appFilter = new QFilter("entry.debtbillid", "in", debitIdMap.keySet());
        appFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        appFilter.and(new QFilter("entry.debttype", "=", (Object)"lc_lettercredit"));
        DynamicObjectCollection appendSuretyCol = QueryServiceHelper.query((String)"fbd_surety_append", (String)String.join((CharSequence)",", "entry.debtbillid", "entry.appendamt", "entry.debtcurrency", "currency", "org"), (QFilter[])new QFilter[]{appFilter});
        HashMap<Long, BigDecimal> appendDebitMap = new HashMap<Long, BigDecimal>(appendSuretyCol.size());
        for (DynamicObject appendSurety : appendSuretyCol) {
            BigDecimal appendAmt = appendSurety.getBigDecimal("entry.appendamt");
            if (EmptyUtil.isEmpty((BigDecimal)appendAmt)) continue;
            Object temp = (BigDecimal)appendDebitMap.get(appendSurety.getLong("entry.debtbillid"));
            temp = temp == null ? Constants.ZERO : temp;
            Long debitCurrencyId = appendSurety.getLong("entry.debtcurrency");
            BigDecimal exchangeRate = LetterCreditSuretyUpgradeService.getExchangeRate(debitCurrencyId, appendSurety.getLong("currency"), appendSurety.getLong("org"));
            appendDebitMap.put(appendSurety.getLong("entry.debtbillid"), ((BigDecimal)temp).add(appendAmt.multiply(exchangeRate)));
        }
        QFilter reaFilter = new QFilter("entry.debtbillid", "in", debitIdMap.keySet());
        reaFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        reaFilter.and(new QFilter("entry.debttype", "=", (Object)"lc_lettercredit"));
        DynamicObjectCollection reaSuretyCol = QueryServiceHelper.query((String)"fbd_suretyreleasebill", (String)String.join((CharSequence)",", "entry.debtbillid", "amount", "entry.debtcurrency", "currency", "org"), (QFilter[])new QFilter[]{reaFilter});
        HashMap<Long, BigDecimal> releaseDebitMap = new HashMap<Long, BigDecimal>(appendSuretyCol.size());
        for (DynamicObject reaSurety : reaSuretyCol) {
            BigDecimal temp = (BigDecimal)releaseDebitMap.get(reaSurety.getLong("entry.debtbillid"));
            temp = temp == null ? Constants.ZERO : temp;
            Long debitCurrencyId = reaSurety.getLong("entry.debtcurrency");
            BigDecimal exchangeRate = LetterCreditSuretyUpgradeService.getExchangeRate(debitCurrencyId, reaSurety.getLong("currency"), reaSurety.getLong("org"));
            releaseDebitMap.put(reaSurety.getLong("entry.debtbillid"), temp.subtract(exchangeRate.multiply(reaSurety.getBigDecimal("amount"))));
        }
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>(debitIdMap.size());
        for (Map.Entry<Long, BigDecimal> entry : debitIdMap.entrySet()) {
            result.put(entry.getKey(), entry.getValue().add(EmptyUtil.isEmpty((BigDecimal)((BigDecimal)appendDebitMap.get(entry.getKey()))) ? Constants.ZERO : (BigDecimal)appendDebitMap.get(entry.getKey())).add(EmptyUtil.isEmpty((BigDecimal)((BigDecimal)releaseDebitMap.get(entry.getKey()))) ? Constants.ZERO : (BigDecimal)releaseDebitMap.get(entry.getKey())));
        }
        return result;
    }

    private static BigDecimal getExchangeRate(Long debitCurrencyId, Long currencyId, Long orgId) {
        BigDecimal exchangeRate = Constants.ONE;
        if (EmptyUtil.isNoEmpty((Long)debitCurrencyId) && !debitCurrencyId.equals(currencyId)) {
            exchangeRate = TmcBusinessBaseHelper.getExchangeRateNew((long)currencyId, (long)debitCurrencyId, (long)orgId, (Date)DateUtils.getCurrentDate());
            exchangeRate = exchangeRate == null ? Constants.ONE : exchangeRate;
        }
        return exchangeRate;
    }

    private BigDecimal getProMisRate(BigDecimal proMisRate, BigDecimal amount, BigDecimal creditAmount) {
        if (EmptyUtil.isNoEmpty((BigDecimal)proMisRate)) {
            return proMisRate;
        }
        return amount.multiply(Constants.ONE_HUNDRED).divide(creditAmount, 6, RoundingMode.HALF_UP);
    }

    private static BigDecimal getRate(Long currencyId, Long debtOrgId, Long debtCurrencyId, Date applyDate) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (!currencyId.equals(debtCurrencyId)) {
            exchangeRate = TmcBusinessBaseHelper.getExchangeRate((long)currencyId, (long)debtCurrencyId, (long)debtOrgId, (Date)applyDate);
        }
        return exchangeRate == null ? BigDecimal.ONE : exchangeRate;
    }
}

