/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.present;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.PresentStatusEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class PresentBillSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("arrivalstatus");
        sic.add("lettercredit");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashMap<Long, BigDecimal> receiptArrMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, Date> letterDateArrMap = new HashMap<Long, Date>();
        for (DynamicObject presentBill : dataEntities) {
            DynamicObject receipt = presentBill.getDynamicObject("lettercredit");
            if (this.getOperationVariable().containsKey("confirm")) {
                presentBill.set("arrivalstatus", (Object)PresentStatusEnum.PRESENT_CONFIRM.getValue());
                presentBill.set("configtime", (Object)DateUtils.getCurrentTime());
                if (EmptyUtil.isNoEmpty((DynamicObject)receipt)) {
                    BigDecimal arrAmt = receiptArrMap.getOrDefault(receipt.getLong("id"), BigDecimal.ZERO);
                    receiptArrMap.put(receipt.getLong("id"), arrAmt.add(presentBill.getBigDecimal("arrivalamount")));
                    if (receipt.getBoolean("isnegotiating")) {
                        letterDateArrMap.put(receipt.getLong("id"), presentBill.getDate("endpaydate"));
                    }
                }
            } else {
                LetterCreditHelper.deleteBotpRation((String)"lc_present", (Long)presentBill.getLong("id"), (String)"lc_receipt", (Long)(EmptyUtil.isEmpty((DynamicObject)receipt) ? 0L : receipt.getLong("id")));
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)receipt)) continue;
            TmcBotpHelper.saveRelation((String)"lc_receipt", (Long)((Long)receipt.getPkValue()), (String)"lc_present", (Long)((Long)presentBill.getPkValue()));
        }
        LetterCreditHelper.updateLetterArr((String)"lc_receipt", receiptArrMap, letterDateArrMap);
    }
}

