/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.apply;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.lc.business.validate.resource.LcBusResourceEnum;
import kd.tmc.lc.common.enums.LetterBizTypeEnum;

public class LetterCreditApplyPushLetValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sel = super.getSelector();
        sel.add("billno");
        sel.add("biztype");
        sel.add("billstatus");
        return sel;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        Set<Object> applyNos = new HashSet();
        if (dataEntitys != null && dataEntitys.length > 0) {
            Set billNos = Arrays.stream(dataEntitys).map(o -> o.getDataEntity().getString("billno")).collect(Collectors.toSet());
            DynamicObjectCollection letts = QueryServiceHelper.query((String)"lc_lettercredit", (String)"creditapplyno", (QFilter[])new QFilter[]{new QFilter("creditapplyno", "in", billNos)});
            applyNos = letts.stream().map(o -> o.getString("creditapplyno")).collect(Collectors.toSet());
            Map variables = this.getOption().getVariables();
            for (ExtendedDataEntity dataEntity : dataEntitys) {
                DynamicObject data = dataEntity.getDataEntity();
                if (!variables.containsKey("auditPush") && !BillStatusEnum.AUDIT.getValue().equals(data.getString("billstatus"))) {
                    this.addErrorMessage(dataEntity, LcBusResourceEnum.LetterCreditApplyPushLetValidator_2.loadKDString());
                }
                if (!LetterBizTypeEnum.OPEN_CARD.getValue().equals(data.getString("biztype"))) {
                    this.addErrorMessage(dataEntity, LcBusResourceEnum.LetterCreditApplyPushLetValidator_0.loadKDString());
                }
                if (!applyNos.contains(data.getString("billno"))) continue;
                this.addErrorMessage(dataEntity, LcBusResourceEnum.LetterCreditApplyPushLetValidator_1.loadKDString());
            }
        }
    }
}

