/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.apply;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.AmountProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.resource.TmcBizResource;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.LetterBizTypeEnum;
import kd.tmc.lc.common.enums.LetterCreditStatusEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class LetterCreditApplySaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("biztype");
        sic.add("creditlimit");
        sic.add("amount");
        sic.add("amountscaleupper");
        sic.add("lettercredit");
        sic.add("bank");
        sic.add("credittype");
        sic.add("org");
        sic.add("currency");
        sic.add("entry_surety");
        sic.add("entry_surety.suretycurrency");
        sic.add("suretycur");
        sic.add("suretymoney");
        sic.add("guarantee");
        sic.add("promisrate");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String checkMsg;
            DynamicObject applyBill = dataEntity.getDataEntity();
            String bizType = applyBill.getString("biztype");
            if (LetterBizTypeEnum.EDIT_CARD.getValue().equals(bizType) || LetterBizTypeEnum.REPEAL_CARD.getValue().equals(bizType) || LetterBizTypeEnum.CLOSE_CARD.getValue().equals(bizType)) {
                DynamicObject creditLimit;
                DynamicObject letterCredit = applyBill.getDynamicObject("lettercredit");
                if (EmptyUtil.isEmpty((DynamicObject)letterCredit)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u4fe1\u7528\u8bc1\u53f7\"\u3002", (String)"LetterCreditApplySaveValidator_3", (String)"tmc-lc-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)(creditLimit = applyBill.getDynamicObject("creditlimit"))) && EmptyUtil.isEmpty((BigDecimal)applyBill.getBigDecimal("amount"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u91d1\u989d\u201d\u3002", (String)"LetterCreditApplySaveValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)letterCredit)) {
                    Object pkId = letterCredit.getPkValue();
                    letterCredit = QueryServiceHelper.queryOne((String)"lc_lettercredit", (String)"creditstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
                    QFilter qFilter = new QFilter("lettercredit", "=", pkId).and("id", "!=", applyBill.getPkValue());
                    QFilter qFilter1 = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
                    Object[] bizApplyArr = TmcDataServiceHelper.load((String)"lc_bizapply", (String)"lettercredit", (QFilter[])new QFilter[]{qFilter, qFilter1});
                    if (Arrays.asList(LetterCreditStatusEnum.DONE_CLOSE.getValue(), LetterCreditStatusEnum.DONE_REPEAL.getValue()).contains(letterCredit.getString("creditstatus")) || EmptyUtil.isNoEmpty((Object[])bizApplyArr) && Arrays.stream(bizApplyArr).filter(e -> !LetterCreditStatusEnum.DONE_REGISTER.getValue().equals(e.getDynamicObject("lettercredit").getString("creditstatus"))).count() > 0L) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u72b6\u6001\u4e0d\u4e3a\u5df2\u767b\u8bb0\u3002", (String)"LetterCreditApplySaveValidator_4", (String)"tmc-lc-business", (Object[])new Object[0]));
                    }
                }
            } else if (LetterBizTypeEnum.OPEN_CARD.getValue().equals(bizType) && EmptyUtil.isNoEmpty((String)(checkMsg = LetterCreditHelper.checkCreditlimit((ExtendedDataEntity)dataEntity)))) {
                this.addErrorMessage(dataEntity, checkMsg);
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)applyBill.getDynamicObjectCollection("entry_surety")) && !LetterBizTypeEnum.OPEN_CARD.getValue().equals(bizType)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u5f00\u8bc1\u7533\u8bf7\u4e0d\u80fd\u5173\u8054\u4fdd\u8bc1\u91d1\u3002", (String)"LetterCreditApplySaveValidator_0", (String)"tmc-lc-business", (Object[])new Object[0]));
                continue;
            }
            checkMsg = LetterCreditHelper.checkContainsSurety((DynamicObject)applyBill);
            if (EmptyUtil.isNoEmpty((String)checkMsg)) {
                this.addErrorMessage(dataEntity, checkMsg);
            }
            if (LetterCreditHelper.getAmount((DynamicObject)applyBill).compareTo(Constants.MAX_AMOUNT) > 0) {
                this.addErrorMessage(dataEntity, new TmcBizResource().checkAmountMaxValue(ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u91d1\u989d*\uff081+\u6ea2\u77ed\u88c5\u4e0a\u9650\uff09", (String)"LetterCreditApplySaveValidator_2", (String)"tmc-lc-business", (Object[])new Object[0])));
            }
            for (IDataEntityProperty prop : applyBill.getDataEntityType().getProperties()) {
                if (!(prop instanceof AmountProp) || applyBill.getBigDecimal(prop.getName()).compareTo(Constants.MAX_AMOUNT) <= 0) continue;
                this.addErrorMessage(dataEntity, new TmcBizResource().checkAmountMaxValue(prop.getDisplayName().getLocaleValue()));
            }
        }
    }
}

