/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.arrival;

import com.alibaba.fastjson.JSONArray;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.webapi.ebentity.biz.arrival.FileListResponseDetail;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.FileDownloadStatusEnum;
import org.apache.commons.lang3.tuple.Pair;

public class ArrivalBillRegisterValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("creditno");
        selector.add("filelist_tag");
        selector.add("filestatus");
        selector.add("filelistres_tag");
        selector.add("receivedno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        List arrivalNoList = Arrays.stream(dataEntity).map(r -> r.getDataEntity()).map(r -> r.getString("receivedno")).collect(Collectors.toList());
        DynamicObjectCollection arrivalCols = QueryServiceHelper.query((String)"lc_arrival", (String)"id,arrivalno,arrivalstatus", (QFilter[])new QFilter[]{new QFilter("arrivalno", "in", arrivalNoList)});
        Map<String, Pair<Long, String>> arrNoMap = arrivalCols.stream().collect(Collectors.toMap(r -> r.getString("arrivalno"), r -> Pair.of((Object)r.getLong("id"), (Object)r.getString("arrivalstatus"))));
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject arrival = extData.getDataEntity();
            String creditNo = arrival.getString("creditno");
            if (EmptyUtil.isEmpty((String)creditNo)) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ArrivalBillRegisterValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
                continue;
            }
            QFilter qFilter = new QFilter("creditno", "=", (Object)creditNo);
            qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            boolean exists = QueryServiceHelper.exists((String)"lc_lettercredit", (QFilter[])new QFilter[]{qFilter});
            if (!exists) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u6b64\u5230\u5355\u5bf9\u5e94\u7684\u4fe1\u7528\u8bc1\u8fd8\u672a\u767b\u8bb0\uff0c\u8bf7\u5148\u767b\u8bb0\u4fe1\u7528\u8bc1\u3002", (String)"ArrivalBillRegisterValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            this.validateExistsDownStream(extData, arrival, arrNoMap);
            this.validateFileDownload(extData, arrival);
        }
    }

    private void validateFileDownload(ExtendedDataEntity extData, DynamicObject arrOnline) {
        String fileListStr = arrOnline.getString("filelist_tag");
        if (EmptyUtil.isEmpty((String)fileListStr)) {
            return;
        }
        if (FileDownloadStatusEnum.isDownloading((String)arrOnline.getString("filestatus"))) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u6587\u4ef6\u6b63\u5728\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ArrivalBillRegisterValidator_3", (String)"tmc-lc-business", (Object[])new Object[0]));
            return;
        }
        String fileResStr = arrOnline.getString("filelistres_tag");
        if (EmptyUtil.isEmpty((String)fileResStr)) {
            return;
        }
        List fileResList = JSONArray.parseArray((String)fileResStr, FileListResponseDetail.class);
        long failNum = fileResList.stream().filter(r -> r.getDownLoad() == false).count();
        if (failNum >= 1L) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u6587\u4ef6\u672a\u5168\u90e8\u4e0b\u8f7d\u6210\u529f\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6587\u4ef6\u3002", (String)"ArrivalBillRegisterValidator_4", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }

    private void validateExistsDownStream(ExtendedDataEntity extData, DynamicObject arrOnline, Map<String, Pair<Long, String>> arrNoMap) {
        Map botpMap;
        Pair<Long, String> arrPair = arrNoMap.get(arrOnline.getString("receivedno"));
        if (EmptyUtil.isEmpty(arrPair)) {
            return;
        }
        String arrStatus = (String)arrPair.getRight();
        if (ArrivalStatusEnum.isArrivalConfirm((String)arrStatus) || ArrivalStatusEnum.isArrivalPay((String)arrStatus)) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53ea\u6709\u5230\u5355\u72b6\u6001\u7b49\u4e8e\u5230\u5355\u5df2\u767b\u8bb0\u7684\u5355\u636e\u624d\u5141\u8bb8\u518d\u6b21\u70b9\u51fb\u5230\u5355\u767b\u8bb0\u3002", (String)"ArrivalBillRegisterValidator_5", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isNoEmpty((Object)(botpMap = BFTrackerServiceHelper.findTargetBills((String)"lc_arrival", (Long[])new Long[]{(Long)arrPair.getLeft()}))) && !botpMap.isEmpty()) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5230\u5355\u5904\u7406\u5355\u636e\u5df2\u6709\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u518d\u6b21\u70b9\u51fb\u5230\u5355\u767b\u8bb0\u3002", (String)"ArrivalBillRegisterValidator_6", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }
}

