/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.arrival;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.business.validate.resource.LcBusResourceEnum;

public class ArrivalBillSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("arrivalamount");
        sic.add("billstatus");
        sic.add("arrivalamount");
        sic.add("arrivalcurrency");
        sic.add("billno");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject arrivalHistoryBill;
            DynamicObject applyBill = dataEntity.getDataEntity();
            BigDecimal arrivalAmount = applyBill.getBigDecimal("arrivalamount");
            String billStatus = applyBill.getString("billstatus");
            if (BillStatusEnum.AUDIT.getValue().equals(billStatus) && BigDecimal.ZERO.compareTo(arrivalAmount) == 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u91d1\u989d\u201d\u3002", (String)"LetterCreditChangeSaveValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (!this.getOption().getVariables().containsKey("confirm") || !EmptyUtil.isNoEmpty((DynamicObject)(arrivalHistoryBill = QueryServiceHelper.queryOne((String)"lc_arrival", (String)"arrivalamount", (QFilter[])new QFilter[]{new QFilter("id", "=", applyBill.getPkValue())})))) continue;
            BigDecimal arrAmount = applyBill.getBigDecimal("arrivalamount");
            BigDecimal hisArrAmount = arrivalHistoryBill.getBigDecimal("arrivalamount");
            DynamicObject currency = applyBill.getDynamicObject("arrivalcurrency");
            if (arrAmount.compareTo(hisArrAmount) <= 0) continue;
            this.addErrorMessage(dataEntity, LcBusResourceEnum.ArrivalBillSaveValidator_0.loadKDString(hisArrAmount.setScale(currency.getInt("amtprecision"))));
        }
    }
}

