/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.arrival;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalTypeEnum;
import kd.tmc.lc.common.enums.LetterCreditStatusEnum;
import kd.tmc.lc.common.enums.TradeChannelEnum;
import kd.tmc.lc.common.helper.OnlineServiceHelper;

public class ArrivalBillSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("benefiterother");
        sic.add("lettercredit");
        sic.add("arrivaltype");
        sic.add("trancode");
        sic.add("tradechannel");
        sic.add("arrivalbank");
        sic.add("endpaydate");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            boolean isOnline;
            String tranCode;
            DynamicObject letterCreditDy;
            DynamicObject lcBill;
            DynamicObject arrivalBill = dataEntity.getDataEntity();
            if (EmptyUtil.isEmpty((String)arrivalBill.getString("benefiterother"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u53d7\u76ca\u4eba\"\u3002", (String)"ArrivalBillSubmitValidator_0", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(lcBill = arrivalBill.getDynamicObject("lettercredit"))) && EmptyUtil.isNoEmpty((DynamicObject)(letterCreditDy = QueryServiceHelper.queryOne((String)"lc_lettercredit", (String)"creditstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", lcBill.getPkValue())}))) && LetterCreditStatusEnum.CHANGE_ING.getValue().equals(letterCreditDy.getString("creditstatus"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u5728\u9014\u7684\u6539\u8bc1\u7533\u8bf7\u5355\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"ArrivalBillSubmitValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (ArrivalTypeEnum.CREDIT.getValue().equals(arrivalBill.getString("arrivaltype")) && EmptyUtil.isEmpty((DynamicObject)lcBill)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u4fe1\u7528\u8bc1\u53f7\"\u3002", (String)"ArrivalBillSubmitValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((String)(tranCode = arrivalBill.getString("trancode"))) && (!OnlineServiceHelper.isNumeric((String)tranCode) || 6 != tranCode.length())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ea4\u6613\u7f16\u7801\u5fc5\u987b\u4e3a6\u4f4d\u6570\u5b57\u3002", (String)"ArrivalBillSubmitValidator_3", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if ((isOnline = TradeChannelEnum.isOnline((String)arrivalBill.getString("tradechannel"))) && EmptyUtil.isEmpty((DynamicObject)arrivalBill.getDynamicObject("arrivalbank"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u4f01\u6e20\u9053\u65f6\uff0c\u5230\u5355\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ArrivalBillSubmitValidator_4", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (isOnline || !EmptyUtil.isEmpty((Object)arrivalBill.getDate("endpaydate"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ebf\u4e0b\u6e20\u9053\u65f6\uff0c\u6700\u8fdf\u4ed8\u6b3e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ArrivalBillSubmitValidator_5", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }
}

