/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.arrival;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.LetterCreditStatusEnum;
import kd.tmc.lc.common.enums.TradeChannelEnum;

public class ArrivalBillUnArrConfirmValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billstatus");
        sic.add("arrivalstatus");
        sic.add("entrys");
        sic.add("lettercredit");
        sic.add("arrivalamount");
        sic.add("payid");
        sic.add("arrivalno");
        sic.add("isinit");
        sic.add("ispayconfig");
        sic.add("tradechannel");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject letterCreditDo;
            DynamicObject arrivalBill = dataEntity.getDataEntity();
            String billStatus = arrivalBill.getString("billstatus");
            String arrivalStatus = arrivalBill.getString("arrivalstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus) || !ArrivalStatusEnum.ARRIVAL_CONFIRM.getValue().equals(arrivalStatus) || this.isRelatePayBill(arrivalBill)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u3010\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838&\u5230\u5355\u72b6\u6001\u4e3a\u5230\u5355\u5df2\u786e\u8ba4\u3011\u4e14\u5230\u5355\u4ed8\u6b3e\u660e\u7ec6\u4e3a\u7a7a\uff0c\u624d\u53ef\u53d1\u8d77\u53d6\u6d88\u5230\u5355\u786e\u8ba4\u3002", (String)"ArrivalBillUnArrConfirmValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(letterCreditDo = arrivalBill.getDynamicObject("lettercredit"))) && LetterCreditStatusEnum.DONE_REPEAL.getValue().equals(letterCreditDo.getString("creditstatus"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u72b6\u6001\u4e3a\u5df2\u64a4\u8bc1\u7684\u5230\u5355\u5904\u7406\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u5230\u5355\u786e\u8ba4\u3002", (String)"ArrivalBillUnArrConfirmValidator_4", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (arrivalBill.getBoolean("isinit")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210\u7684\u5230\u5355\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u5230\u5355\u786e\u8ba4\u3002", (String)"ArrivalBillUnArrConfirmValidator_5", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            this.checkSuretyRepay(dataEntity, arrivalBill);
            if (!TradeChannelEnum.ONLINE.getValue().equals(arrivalBill.getString("tradechannel"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u4f01\u76f4\u8054\u7684\u5230\u5355\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u5230\u5355\u786e\u8ba4\u3002", (String)"ArrivalBillUnArrConfirmValidator_6", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }

    private void checkSuretyRepay(ExtendedDataEntity dataEntity, DynamicObject arrivalBill) {
        boolean existsSuretyRelease = QueryServiceHelper.exists((String)"fbd_suretyreleasebill", (QFilter[])new QFilter[]{new QFilter("repaybillid", "=", arrivalBill.getPkValue()).and("repaybilltype", "=", (Object)arrivalBill.getDataEntityType().getName())});
        if (existsSuretyRelease) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u4fdd\u8bc1\u91d1\u62b5\u6263\u5355\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u5230\u5355\u786e\u8ba4\u3002", (String)"ArrivalBillUnArrConfirmValidator_3", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }

    private boolean isRelatePayBill(DynamicObject arrivalBill) {
        DynamicObjectCollection entryList = arrivalBill.getDynamicObjectCollection("entrys");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryList)) {
            return false;
        }
        if (arrivalBill.getBoolean("ispayconfig")) {
            return true;
        }
        Object[] payBillIds = entryList.stream().map(v -> v.get("payid")).toArray();
        return EmptyUtil.isNoEmpty((Object[])payBillIds) && TmcDataServiceHelper.exists((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)payBillIds), new QFilter("billstatus", "not in", (Object)new String[]{"G", "F"})});
    }
}

