/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.arrival;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.TradeChannelEnum;

public class ArrivalBillUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billstatus");
        sic.add("arrivalstatus");
        sic.add("arrivalno");
        sic.add("isinit");
        sic.add("tradechannel");
        sic.add("opetype");
        sic.add("acceptbebankstatus");
        sic.add("bebankstatus");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject arrivalBill = dataEntity.getDataEntity();
            String billStatus = arrivalBill.getString("billstatus");
            String arrivalStatus = arrivalBill.getString("arrivalstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus) || !ArrivalStatusEnum.ARRIVAL_REGISTER.getValue().equals(arrivalStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6838&\u5230\u5355\u72b6\u6001\u5fc5\u987b\u4e3a\u5230\u5355\u5df2\u767b\u8bb0\u624d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"ArrivalBillUnAuditValidator_0", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (arrivalBill.getBoolean("isinit")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210\u7684\u5230\u5355\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ArrivalBillUnAuditValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            this.validateOnlineScene(dataEntity, arrivalBill);
        }
    }

    private void validateOnlineScene(ExtendedDataEntity extData, DynamicObject arrivalBill) {
        if (!TradeChannelEnum.ONLINE.getValue().equals(arrivalBill.getString("tradechannel"))) {
            return;
        }
        String opeType = arrivalBill.getString("opetype");
        String beStat = arrivalBill.getString("bebankstatus");
        switch (opeType) {
            case "accept": {
                String acceptBeStat = arrivalBill.getString("acceptbebankstatus");
                if (!EmptyUtil.isNoEmpty((String)acceptBeStat) || BeBillStatusEnum.TF.getValue().equals(acceptBeStat)) break;
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u627f\u5151\u5931\u8d25\u7684\u5355\u636e\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"ArrivalBillUnAuditValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]));
                break;
            }
            case "payment": {
                String acceptBeStat = arrivalBill.getString("acceptbebankstatus");
                if (BeBillStatusEnum.TS.getValue().equals(acceptBeStat)) {
                    this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u627f\u5151\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ArrivalBillUnAuditValidator_3", (String)"tmc-lc-business", (Object[])new Object[0]));
                }
                if (!EmptyUtil.isEmpty((String)acceptBeStat) || !EmptyUtil.isNoEmpty((String)beStat) || BeBillStatusEnum.TF.getValue().equals(beStat)) break;
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ed8\u6b3e\u5931\u8d25\u7684\u5355\u636e\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"ArrivalBillUnAuditValidator_4", (String)"tmc-lc-business", (Object[])new Object[0]));
                break;
            }
            case "protest": {
                if (!EmptyUtil.isNoEmpty((String)beStat) || BeBillStatusEnum.TF.getValue().equals(beStat)) break;
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62d2\u4ed8\u5931\u8d25\u7684\u5355\u636e\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"ArrivalBillUnAuditValidator_5", (String)"tmc-lc-business", (Object[])new Object[0]));
                break;
            }
        }
    }
}

