/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.arrival;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.ArrivalWayEnum;
import kd.tmc.lc.common.enums.TradeChannelEnum;
import kd.tmc.lc.common.helper.OnlineServiceHelper;

public class ArrivalCommitAcptPayValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("tradechannel");
        selector.add("bebankstatus");
        selector.add("arrivalway");
        selector.add("arrivalstatus");
        selector.add("acceptbebankstatus");
        selector.add("org");
        selector.add("arrivalbank");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject directConnSet;
            DynamicObject arrival = extData.getDataEntity();
            if (!BillStatusEnum.isAudit((String)arrival.getString("billstatus")) || !TradeChannelEnum.ONLINE.getValue().equals(arrival.getString("tradechannel"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5ba1\u6838\u4e14\u4ea4\u6613\u6e20\u9053\u662f\u94f6\u4f01\u76f4\u8054\u7684\u5355\u636e\u3002", (String)"ArrivalCommitAcceptValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((String)arrival.getString("bebankstatus"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u63d0\u4ea4\u94f6\u4f01\u76f4\u8054\uff0c\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4\u3002", (String)"ArrivalCommitAcceptValidator_3", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (!ArrivalWayEnum.isAccept((String)arrival.getString("arrivalway"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5230\u5355\u5904\u7406\u65b9\u5f0f\u4e3a\u627f\u5151\u7684\u5355\u636e\u3002", (String)"ArrivalCommitAcceptValidator_4", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (!ArrivalStatusEnum.isArrivalConfirm((String)arrival.getString("arrivalstatus"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5230\u5355\u72b6\u6001\u4e3a\u5230\u5355\u5df2\u786e\u8ba4\u7684\u5355\u636e\u3002", (String)"ArrivalCommitAcptPayValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (!BeBillStatusEnum.isTS((String)arrival.getString("acceptbebankstatus"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u627f\u5151\u76f4\u8054\u63d0\u4ea4\u72b6\u6001\u4e3a\u4ea4\u6613\u6210\u529f\u7684\u5355\u636e\u3002", (String)"ArrivalCommitAcptPayValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isEmpty((DynamicObject)(directConnSet = OnlineServiceHelper.getDirectConnSetForArrival((DynamicObject)arrival)))) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5355\u636e%s\u4e0d\u652f\u6301\u63d0\u4ea4\u94f6\u4f01\u76f4\u8054\u3002", (String)"ArrivalCommitAcceptValidator_5", (String)"tmc-lc-business", (Object[])new Object[]{arrival.getString("billno")}));
        }
    }
}

