/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.arrival;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.lc.common.enums.ArrivalWayEnum;
import kd.tmc.lc.common.enums.TradeChannelEnum;

public class ArrivalRecommitBeValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("tradechannel");
        selector.add("opetype");
        selector.add("acceptbebankstatus");
        selector.add("bebankstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            String opeType;
            DynamicObject arrival = extData.getDataEntity();
            if (!BillStatusEnum.isAudit((String)arrival.getString("billstatus")) || !TradeChannelEnum.ONLINE.getValue().equals(arrival.getString("tradechannel"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5ba1\u6838\u4e14\u4ea4\u6613\u6e20\u9053\u662f\u94f6\u4f01\u76f4\u8054\u7684\u5355\u636e\u3002", (String)"ArrivalCommitAcceptValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if ((!ArrivalWayEnum.isAccept((String)(opeType = arrival.getString("opetype"))) || BeBillStatusEnum.isTF((String)arrival.getString("acceptbebankstatus"))) && (ArrivalWayEnum.isAccept((String)opeType) || BeBillStatusEnum.isTF((String)arrival.getString("bebankstatus")))) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ea4\u6613\u5931\u8d25\u7684\u5355\u636e\u3002", (String)"ArrivalRecommitBeValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }
}

