/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.buyerint;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BuyerInterestBillSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entry");
        selector.add("effectdate");
        selector.add("arrival");
        selector.add("enddate");
        selector.add("accountamt");
        selector.add("financeamt");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject buyerInt = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entry = buyerInt.getDynamicObjectCollection("entry");
            int rowIndex = 1;
            for (DynamicObject row : entry) {
                this.validateFieldLegal(extendedDataEntity, row, rowIndex);
                this.validateRepeatBuyerInt(extendedDataEntity, row);
                ++rowIndex;
            }
        }
    }

    private void validateFieldLegal(ExtendedDataEntity extendedDataEntity, DynamicObject row, int rowIndex) {
        BigDecimal financeAmt;
        BigDecimal toDoAmt;
        BigDecimal accountAmt;
        Date endDate;
        DynamicObject arrival = row.getDynamicObject("arrival");
        Date arrivalDate = arrival.getDate("arrivaldate");
        Date effectDate = row.getDate("effectdate");
        if (null != arrivalDate && null != effectDate && effectDate.compareTo(arrivalDate) < 0) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\uff1a\u878d\u8d44\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5230\u5355\u65e5\u671f\u3002", (String)"BuyerInterestBillSaveValidator_0", (String)"tmc-lc-business", (Object[])new Object[]{rowIndex}));
        }
        if (null != (endDate = row.getDate("enddate")) && null != effectDate && endDate.compareTo(effectDate) < 0) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\uff1a\u878d\u8d44\u5230\u671f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u878d\u8d44\u751f\u6548\u65e5\u671f\u3002", (String)"BuyerInterestBillSaveValidator_1", (String)"tmc-lc-business", (Object[])new Object[]{rowIndex}));
        }
        if ((accountAmt = row.getBigDecimal("accountamt")).compareTo(BigDecimal.ZERO) < 0) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\uff1a\u878d\u8d44\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u4ed8\u606f\u91d1\u989d\u3002", (String)"BuyerInterestBillSaveValidator_2", (String)"tmc-lc-business", (Object[])new Object[]{rowIndex}));
        }
        if ((toDoAmt = arrival.getBigDecimal("todoamount")).compareTo(financeAmt = row.getBigDecimal("financeamt")) < 0) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\uff1a\u878d\u8d44\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5230\u5355\u672a\u4ed8\u91d1\u989d\u3002", (String)"BuyerInterestBillSaveValidator_3", (String)"tmc-lc-business", (Object[])new Object[]{rowIndex}));
        }
    }

    private void validateRepeatBuyerInt(ExtendedDataEntity extendedDataEntity, DynamicObject row) {
        Object buyerIntId;
        DynamicObject arrival = row.getDynamicObject("arrival");
        if (EmptyUtil.isNoEmpty((DynamicObject)arrival) && EmptyUtil.isNoEmpty((Object)(buyerIntId = arrival.get("buyerintid"))) && !buyerIntId.equals(extendedDataEntity.getDataEntity().getPkValue())) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"%s\u5df2\u64cd\u4f5c\u4e70\u65b9\u4ed8\u606f\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"BuyerInterestBillSaveValidator_4", (String)"tmc-lc-business", (Object[])new Object[]{arrival.getString("number")}));
        }
    }
}

