/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.config;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.business.validate.resource.LcBusResourceEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class PayConfigConfirmValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("arrpayamount");
        sic.add("todoamount");
        sic.add("isdiffcur");
        sic.add("arrivalcurrency");
        sic.add("paycurrency");
        sic.add("arrivalno");
        sic.add("lockamount");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            boolean isPushPay;
            BigDecimal lockAmount;
            DynamicObject data = dataEntity.getDataEntity();
            boolean isDiffCur = data.getBoolean("isdiffcur");
            if (isDiffCur) {
                DynamicObject arrivalCurrency = data.getDynamicObject("arrivalcurrency");
                DynamicObject payCurrency = data.getDynamicObject("paycurrency");
                if (arrivalCurrency.getString("number").equals(payCurrency.getString("number"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u5e01\u79cd\u4e0e\u5230\u5355\u5e01\u79cd\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u975e\u5f02\u5e01\u79cd\u4ed8\u6b3e\u3002", (String)"PayConfigConfirmValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]));
                }
            }
            QFilter qFilter = new QFilter("id", "=", (Object)data.getLong("id"));
            DynamicObject arrivalBill = QueryServiceHelper.queryOne((String)"lc_arrival", (String)"isinit,lockamount,todoamount", (QFilter[])qFilter.toArray());
            BigDecimal arrPayAmount = data.getBigDecimal("arrpayamount");
            BigDecimal todoAmount = arrivalBill.getBigDecimal("todoamount");
            if (todoAmount.subtract(lockAmount = arrivalBill.getBigDecimal("lockamount")).compareTo(arrPayAmount) < 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5230\u5355\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u672a\u4ed8\u6b3e\u91d1\u989d\u3002", (String)"PayConfigConfirmValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (isPushPay = LetterCreditHelper.checkPushPaybill((long)data.getLong("id"), (String)data.getString("arrivalno"))) {
                this.addErrorMessage(dataEntity, LcBusResourceEnum.PayConfigConfirmValidator_3.loadKDString());
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)arrivalBill) || !arrivalBill.getBoolean("isinit")) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210\u7684\u5230\u5355\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"PayConfigConfirmValidator_0", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }
}

