/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.config;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RecConfigConfirmValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("prereceiptamount");
        sic.add("todoamount");
        sic.add("receiptamount");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            QFilter qFilter;
            DynamicObject presentBill;
            BigDecimal receiptAmount;
            DynamicObject data = dataEntity.getDataEntity();
            BigDecimal preReceiptAmount = data.getBigDecimal("prereceiptamount");
            BigDecimal todoAmount = data.getBigDecimal("todoamount");
            if (todoAmount.compareTo(preReceiptAmount) < 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ea4\u5355\u6536\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u672a\u6536\u6b3e\u91d1\u989d\u3002", (String)"RecConfigConfirmValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if ((receiptAmount = data.getBigDecimal("receiptamount")).compareTo(preReceiptAmount) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4ea4\u5355\u6536\u6b3e\u91d1\u989d\u3002", (String)"RecConfigConfirmValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)(presentBill = QueryServiceHelper.queryOne((String)"lc_present", (String)"isinit", (QFilter[])(qFilter = new QFilter("id", "=", (Object)data.getLong("id"))).toArray()))) || !presentBill.getBoolean("isinit")) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210\u7684\u4ea4\u5355\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"RecConfigConfirmValidator_0", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }
}

