/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.config;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.lc.common.enums.PresentStatusEnum;
import kd.tmc.lc.common.helper.LcParameterHelper;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class UnRecConfigConfirmValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billstatus");
        sic.add("arrivalstatus");
        sic.add("ispayconfig");
        sic.add("org");
        sic.add("lettercredit");
        sic.add("isforfaiting");
        sic.add("arrivalno");
        sic.add("isinit");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject letterCredit;
            String creditBillNo;
            DynamicObject presentBill = dataEntity.getDataEntity();
            String recMethod = LcParameterHelper.getAppStringParameter((long)presentBill.getDynamicObject("org").getLong("id"), (String)"recmethod");
            if (BaseEnableEnum.DISABLE.getValue().equals(recMethod)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53c2\u6570\u9009\u62e9\u4e3a\u201c\u4ea4\u5355\u5173\u8054\u6536\u6b3e\u5355\u201d\uff0c\u4e0d\u80fd\u57fa\u4e8e\u4ea4\u5355\u76f4\u63a5\u505a\u53d6\u6d88\u6536\u6b3e\u786e\u8ba4\u3002", (String)"UnRecConfigConfirmValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]));
                break;
            }
            String billStatus = presentBill.getString("billstatus");
            String presentStatus = presentBill.getString("arrivalstatus");
            boolean isRecConfig = presentBill.getBoolean("ispayconfig");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus) || PresentStatusEnum.PRESENT_REGISTER.getValue().equals(presentStatus) || !isRecConfig) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u3010\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838&\u4ea4\u5355\u72b6\u6001\u4e3a\u4ea4\u5355\u5df2\u786e\u8ba4\u6216\u4ea4\u5355\u5df2\u6536\u6b3e\u3011\u4e14\u4ea4\u5355\u6536\u6b3e\u660e\u7ec6\u4e0d\u4e3a\u7a7a\uff0c\u624d\u53ef\u53d1\u8d77\u53d6\u6d88\u6536\u6b3e\u786e\u8ba4\u3002", (String)"UnRecConfigConfirmValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (!"".equals(creditBillNo = LetterCreditHelper.getIsCloseCreditStatus((DynamicObject)(letterCredit = presentBill.getDynamicObject("lettercredit"))))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e0a\u6e38\u6536\u8bc1\u5904\u7406:%s\u4fe1\u7528\u72b6\u6001\u4e3a\u201c\u5df2\u95ed\u5377\u201d\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u6536\u6b3e\u786e\u8ba4\u3002", (String)"UnRecConfigConfirmValidator_3", (String)"tmc-lc-business", (Object[])new Object[0]), creditBillNo));
            }
            if (presentBill.getBoolean("isforfaiting")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u7ecf\u5173\u8054\u4e86\u798f\u8d39\u5ef7\u7684\u4ea4\u5355\uff0c\u4e0d\u5141\u8bb8\u518d\u505a\u53d6\u6d88\u6536\u6b3e\u786e\u8ba4\u3002", (String)"UnRecConfigConfirmValidator_4", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (!presentBill.getBoolean("isinit")) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210\u7684\u4ea4\u5355\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u6536\u6b3e\u786e\u8ba4\u3002", (String)"UnRecConfigConfirmValidator_5", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }
}

