/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.lettercredit;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.business.validate.resource.LcBusResourceEnum;
import kd.tmc.lc.common.helper.LcParameterHelper;
import kd.tmc.lc.common.property.LetterCreditProp;

public class LetterCreditAutoCloseValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("org");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        if (EmptyUtil.isNoEmpty((Object[])dataEntities) && "lc_receipt".equals(dataEntities[0].getDataEntity().getDataEntityType().getName())) {
            return;
        }
        List orgIds = Arrays.stream(dataEntities).map(o -> o.getDataEntity().getDynamicObject("org").getLong("id")).collect(Collectors.toList());
        Map appParameterMaps = LcParameterHelper.getAppParameterMaps(orgIds, (String)LetterCreditProp.IS_APPLY_CLOSE);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject letterCredit = dataEntity.getDataEntity();
            DynamicObject org = letterCredit.getDynamicObject("org");
            Object closeParam = appParameterMaps.get(org.getString("id"));
            if (closeParam == null || !((Boolean)closeParam).booleanValue()) continue;
            this.addErrorMessage(dataEntity, LcBusResourceEnum.LetterCreditAutoCloseValidator_1.loadKDString(org.getString("name")));
        }
    }
}

