/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.lettercredit;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.DataSourceEnum;
import kd.tmc.lc.common.enums.TradeChannelEnum;
import kd.tmc.lc.common.helper.OnlineServiceHelper;

public class LetterCreditCommitBeValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("tradechannel");
        sic.add("creditstatus");
        sic.add("isinit");
        sic.add("bebankstatus");
        sic.add("billstatus");
        sic.add("bizdate");
        sic.add("org");
        sic.add("bank");
        sic.add("datasources");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            String fileUrl;
            Long bankCateId;
            DynamicObject directConnSet;
            Object[] arrivalBillIds;
            DynamicObject lcBill = extendedDataEntity.getDataEntity();
            if (!TradeChannelEnum.ONLINE.getValue().equals(lcBill.getString("tradechannel"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ea4\u6613\u6e20\u9053\u4e3a\u94f6\u4f01\u76f4\u8054\u7684\u5355\u636e\u3002", (String)"LetterCreditCommitBeValidator_0", (String)"tmc-lc-business", (Object[])new Object[0]));
                continue;
            }
            if (!BillStatusEnum.isAudit((String)lcBill.getString("billstatus"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5ba1\u6838\u7684\u5355\u636e\u3002", (String)"LetterCreditCommitBeValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((String)lcBill.getString("bebankstatus"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u63d0\u4ea4\u94f6\u4f01\u76f4\u8054\uff0c\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4\u3002", (String)"LetterCreditCommitBeValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (lcBill.getBoolean("isinit")) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5982\u679c\u4ea4\u6613\u6e20\u9053\u4e3a\u94f6\u4f01\u76f4\u8054\uff0c\u521d\u59cb\u5316\u4e3a\u5426\u624d\u80fd\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"LetterCreditCommitBeValidator_3", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((Object[])(arrivalBillIds = TmcBotpHelper.getTargetBillIds((String)"lc_lettercredit", (Object)lcBill.getPkValue(), (String)"lc_arrival")))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u5b58\u5728\u5173\u8054\u5230\u4e0b\u6e38\u5230\u5355\u5355\u636e\u4e0d\u5141\u8bb8\u63d0\u4ea4\u94f6\u4f01\u76f4\u8054\u3002", (String)"LetterCreditCommitBeValidator_4", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (lcBill.getDate("bizdate").compareTo(new Date()) < 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5982\u679c\u4ea4\u6613\u6e20\u9053\u4e3a\u94f6\u4f01\u76f4\u8054\uff0c\u5f00\u8bc1\u65e5\u671f\u5927\u4e8e\u5f53\u524d\u65e5\u3002", (String)"LetterCreditCommitBeValidator_5", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((DynamicObject)(directConnSet = OnlineServiceHelper.getDirectConnSet((DynamicObject)lcBill)))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u5f00\u8bc1\u4eba+\u5f00\u8bc1\u94f6\u884c\u672a\u5728\u94f6\u4f01\u76f4\u8054\u8bbe\u7f6e\u4e2d\u914d\u7f6e\u5f00\u8bc1\u8d26\u53f7\u3002", (String)"LetterCreditCommitBeValidator_6", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (DataSourceEnum.isByBank((String)lcBill.getString("datasources"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7531\u5728\u7ebf\u67e5\u8be2\u767b\u8bb0\u4fe1\u7528\u8bc1\u751f\u6210\u7684\u5f00\u8bc1\u5904\u7406\u5355\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u63d0\u4ea4\u94f6\u4f01\u76f4\u8054\u3002", (String)"LetterCreditCommitBeValidator_7", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (OnlineServiceHelper.CNCB_BANKTYPE != (bankCateId = Optional.ofNullable(lcBill.getDynamicObject("bank")).map(r -> r.getDynamicObject("bank_cate")).map(r -> r.getLong("id")).orElse(0L)) || !EmptyUtil.isEmpty((String)(fileUrl = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.LC.getId(), (long)lcBill.getLong("org_id"), (String)"sftpurl")))) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6587\u4ef6\u670d\u52a1\u5668\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5230\u7cfb\u7edf\u53c2\u6570\u4e2d\u914d\u7f6e\u3010\u6587\u4ef6\u670d\u52a1\u5668\u3011\u3002", (String)"LetterCreditCommitBeValidator_8", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }
}

