/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.lettercredit;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.TradeChannelEnum;

public class LetterCreditOnlineSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("tradechannel");
        selector.add("isnegotiating");
        selector.add("validaddress");
        selector.add("lastdate");
        selector.add("validdate");
        selector.add("entrys");
        selector.add("contractnum");
        selector.add("contractcurrency");
        selector.add("contractamount");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            Date validDate;
            Date lastDate;
            DynamicObject lcBill = extData.getDataEntity();
            if (!TradeChannelEnum.ONLINE.getValue().equals(lcBill.getString("tradechannel"))) continue;
            if (!lcBill.getBoolean("isnegotiating")) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u4ea4\u6613\u6e20\u9053\u4e3a\u94f6\u4f01\u76f4\u8054\u65f6\uff0c\u662f\u5426\u8bae\u4ed8\u5fc5\u987b\u662f\u5f00\u542f\u72b6\u6001\u3002", (String)"LetterCreditOnlineSubmitValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((String)lcBill.getString("validaddress"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u4ea4\u6613\u6e20\u9053\u4e3a\u94f6\u4f01\u76f4\u8054\u65f6\uff0c\u5230\u671f\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LetterCreditOnlineSubmitValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((Object)(lastDate = lcBill.getDate("lastdate")))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u4ea4\u6613\u6e20\u9053\u4e3a\u94f6\u4f01\u76f4\u8054\u65f6\uff0c\u6700\u8fdf\u88c5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LetterCreditOnlineSubmitValidator_3", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{lastDate, validDate = lcBill.getDate("validdate")}) && lastDate.compareTo(validDate) > 0) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u6700\u8fdf\u88c5\u671f\u4e0d\u80fd\u5927\u4e8e\u6709\u6548\u671f\u3002", (String)"LetterCreditOnlineSubmitValidator_4", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            this.validateContractEntry(extData, lcBill);
        }
    }

    private void validateContractEntry(ExtendedDataEntity extData, DynamicObject lcBill) {
        DynamicObjectCollection entry = lcBill.getDynamicObjectCollection("entrys");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entry)) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u4ea4\u6613\u6e20\u9053\u4e3a\u94f6\u4f01\u76f4\u8054\u65f6\uff0c\u5408\u540c\u4fe1\u606f\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LetterCreditOnlineSubmitValidator_5", (String)"tmc-lc-business", (Object[])new Object[0]));
            return;
        }
        DynamicObject row = (DynamicObject)entry.get(0);
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{row.getString("contractnum"), row.getDynamicObject("contractcurrency"), row.getBigDecimal("contractamount")})) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u4ea4\u6613\u6e20\u9053\u4e3a\u94f6\u4f01\u76f4\u8054\u65f6\uff0c\u5408\u540c\u4fe1\u606f\u5206\u5f55\u7684\u5408\u540c\u53f7\u3001\u5408\u540c\u5e01\u79cd\u548c\u5408\u540c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LetterCreditOnlineSubmitValidator_6", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }
}

