/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.lettercredit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackOperateEnum;
import kd.tmc.lc.business.opservice.helper.LetterCreditOpenHelper;

public class LetterCreditOpenUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billno");
        sic.add("sourcebilltype");
        sic.add("srcbillid");
        sic.add("creditno");
        sic.add("org");
        sic.add("bank");
        sic.add("currency");
        sic.add("amount");
        sic.add("benefitertype");
        sic.add("benefiterother");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        ArrayList<DynamicObject> letterOpenLists = new ArrayList<DynamicObject>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObjectCollection entrys;
            DynamicObject letterCredit = dataEntity.getDataEntity();
            String sourceBillType = letterCredit.getString("sourcebilltype");
            if (!"cas_paybill".equals(sourceBillType) && EmptyUtil.isNoEmpty((String)sourceBillType) || EmptyUtil.isEmpty((DynamicObjectCollection)(entrys = letterCredit.getDynamicObjectCollection("billentry")))) continue;
            letterOpenLists.add(letterCredit);
        }
        if (EmptyUtil.isEmpty(letterOpenLists)) {
            return;
        }
        List billIds = letterOpenLists.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        Map extendedEntitys = Arrays.stream(dataEntities).filter(o -> billIds.contains(o.getDataEntity().getLong("id"))).collect(Collectors.toMap(o -> o.getDataEntity().getLong("id"), Function.identity(), (v1, v2) -> v2));
        OperationResult validateRes = LetterCreditOpenHelper.writeBackPayInvoke(letterOpenLists, PayBillWriteBackOperateEnum.UNAUDITVALIDATE.getValue());
        if (EmptyUtil.isEmpty((Object)validateRes) || validateRes.isSuccess()) {
            return;
        }
        List errorInfos = validateRes.getAllErrorOrValidateInfo();
        for (IOperateInfo errorInfo : errorInfos) {
            String message = EmptyUtil.isEmpty((String)errorInfo.getMessage()) ? validateRes.getMessage() : errorInfo.getMessage();
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)extendedEntitys.get(errorInfo.getPkValue());
            if (EmptyUtil.isEmpty((Object)dataEntity)) continue;
            this.addErrorMessage(dataEntity, message);
        }
    }
}

