/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.online;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalWayEnum;
import kd.tmc.lc.common.enums.TradeChannelEnum;

public class OnlineUpdateStatSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billtype");
        selector.add("entryentity");
        selector.add("statusnew");
        selector.add("creditno");
        selector.add("srcid");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject modifyBill = extData.getDataEntity();
            this.validateCreditNo(extData, modifyBill);
            this.validateSrcBeBankStatus(extData, modifyBill);
        }
    }

    private void validateCreditNo(ExtendedDataEntity extData, DynamicObject modifyBill) {
        if (!"lc_lettercredit".equals(modifyBill.getString("billtype"))) {
            return;
        }
        DynamicObjectCollection entry = modifyBill.getDynamicObjectCollection("entryentity");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entry)) {
            return;
        }
        boolean flag = false;
        ArrayList<String> creditNoList = new ArrayList<String>(entry.size());
        ArrayList<Long> idList = new ArrayList<Long>(entry.size());
        for (DynamicObject row : entry) {
            if (!BeBillStatusEnum.isTS((String)row.getString("statusnew"))) continue;
            String creditNo = row.getString("creditno");
            if (EmptyUtil.isEmpty((String)creditNo)) {
                flag = true;
                break;
            }
            creditNoList.add(creditNo);
            idList.add(row.getLong("srcid"));
        }
        if (flag) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u4fee\u6539\u4ea4\u6613\u6210\u529f\u9700\u8981\u8f93\u5165\u4fe1\u7528\u8bc1\u53f7\u3002", (String)"OnlineUpdateStatSaveValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
            return;
        }
        QFilter baseFilter = new QFilter("creditno", "in", creditNoList);
        baseFilter.and(new QFilter("id", "not in", idList));
        QFilter offLineFilter = new QFilter("tradechannel", "=", (Object)TradeChannelEnum.OFFLINE.getValue());
        QFilter onlineFilter = new QFilter("tradechannel", "=", (Object)TradeChannelEnum.ONLINE.getValue()).and(new QFilter("bebankstatus", "!=", (Object)BeBillStatusEnum.TF.getValue()));
        QFilter tradeChannelFilter = offLineFilter.or(onlineFilter);
        DynamicObjectCollection dbLcBills = QueryServiceHelper.query((String)"lc_lettercredit", (String)"id,creditno", (QFilter[])new QFilter[]{baseFilter, tradeChannelFilter});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dbLcBills)) {
            List dbCreditList = dbLcBills.stream().map(r -> r.getString("creditno")).collect(Collectors.toList());
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u53f7\u4e3a%s\u7684\u5f00\u8bc1\u5904\u7406\u5355\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OnlineUpdateStatSaveValidator_2", (String)"tmc-lc-business", (Object[])new Object[]{String.join((CharSequence)",", dbCreditList)}));
        }
    }

    private void validateSrcBeBankStatus(ExtendedDataEntity extData, DynamicObject modifyBill) {
        String entityName;
        DynamicObjectCollection entry = modifyBill.getDynamicObjectCollection("entryentity");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entry)) {
            return;
        }
        List billIdList = entry.stream().map(r -> r.getLong("srcid")).collect(Collectors.toList());
        String selectProp = "lc_arrival".equals(entityName = modifyBill.getString("billtype")) ? "id,bebankstatus,acceptbebankstatus,opetype" : "id,bebankstatus";
        DynamicObjectCollection billCols = QueryServiceHelper.query((String)entityName, (String)selectProp, (QFilter[])new QFilter[]{new QFilter("id", "in", billIdList)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)billCols)) {
            return;
        }
        HashSet<Long> notNcIdSet = new HashSet<Long>(billCols.size());
        for (DynamicObject bizBill : billCols) {
            if ("lc_arrival".equals(entityName) && ArrivalWayEnum.isAccept((String)bizBill.getString("opetype"))) {
                if (BeBillStatusEnum.isNC((String)bizBill.getString("acceptbebankstatus"))) continue;
                notNcIdSet.add(bizBill.getLong("id"));
                continue;
            }
            if (BeBillStatusEnum.isNC((String)bizBill.getString("bebankstatus"))) continue;
            notNcIdSet.add(bizBill.getLong("id"));
        }
        if (EmptyUtil.isNoEmpty(notNcIdSet)) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u64cd\u4f5c\u72b6\u6001\u5df2\u4e0d\u518d\u662f\u201c\u4ea4\u6613\u672a\u786e\u8ba4\u201d\uff0c\u8bf7\u68c0\u67e5\u539f\u5355\u7684\u63d0\u4ea4\u94f6\u4f01\u72b6\u6001\u3002", (String)"OnlineUpdateStatSaveValidator_3", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }
}

