/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.present;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.SuretyHelper;
import kd.tmc.lc.business.validate.resource.LcBusResourceEnum;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.PresentStatusEnum;

public class PresentBillFinancValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("arrivalstatus");
        selector.add("billstatus");
        selector.add("todoamount");
        selector.add("lockamount");
        selector.add("isfinancapply");
        selector.add("isforfaiting");
        selector.add("arrivalway");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            boolean isSurety;
            String msg;
            String arrivalWay;
            boolean isArrival;
            String arrivalStatus;
            DynamicObject bill = dataEntity.getDataEntity();
            String entityName = bill.getDynamicObjectType().getName();
            BigDecimal todoAmount = bill.getBigDecimal("todoamount");
            BigDecimal lockAmount = bill.getBigDecimal("lockamount");
            if (bill.getBoolean("isfinancapply")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u6709\u4e0b\u6e38\u878d\u8d44\u7533\u8bf7\u5355\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210\u3002", (String)"PresentBillFinancValidator_0", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            String string = arrivalStatus = (isArrival = entityName.equals("lc_arrival")) ? ArrivalStatusEnum.ARRIVAL_CONFIRM.getValue() : PresentStatusEnum.PRESENT_CONFIRM.getValue();
            if (!BillStatusEnum.AUDIT.getValue().equals(bill.getString("billstatus")) || !arrivalStatus.equals(bill.getString("arrivalstatus"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5ba1\u6838/\u5df2\u786e\u8ba4\u624d\u80fd\u878d\u8d44\u3002", (String)"PresentBillFinancValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if ("protest".equals(arrivalWay = bill.getString("arrivalway"))) {
                msg = ResManager.loadKDString((String)"\u4ea4\u5355\u5bf9\u65b9\u5904\u7406\u65b9\u5f0f\u4e3a\u62d2\u4ed8\uff0c\u65e0\u6cd5\u64cd\u4f5c\u878d\u8d44\u3002", (String)"PresentBillFinancValidator_5", (String)"tmc-lc-business", (Object[])new Object[0]);
                if (isArrival) {
                    msg = ResManager.loadKDString((String)"\u5230\u5355\u5904\u7406\u65b9\u5f0f\u4e3a\u62d2\u4ed8\uff0c\u65e0\u6cd5\u64cd\u4f5c\u878d\u8d44\u3002", (String)"PresentBillFinancValidator_6", (String)"tmc-lc-business", (Object[])new Object[0]);
                }
                this.addErrorMessage(dataEntity, msg);
            }
            if (todoAmount.compareTo(lockAmount) <= 0) {
                msg = ResManager.loadKDString((String)"\u4ea4\u5355\u53ef\u878d\u8d44\u91d1\u989d\u4e3a0\uff0c\u65e0\u6cd5\u64cd\u4f5c\u878d\u8d44\u3002", (String)"PresentBillFinancValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]);
                if (isArrival) {
                    msg = ResManager.loadKDString((String)"\u5230\u5355\u53ef\u878d\u8d44\u91d1\u989d\u4e3a0\uff0c\u65e0\u6cd5\u64cd\u4f5c\u878d\u8d44\u3002", (String)"PresentBillFinancValidator_4", (String)"tmc-lc-business", (Object[])new Object[0]);
                }
                this.addErrorMessage(dataEntity, msg);
            }
            if (!isArrival && bill.getBoolean("isforfaiting")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ea4\u5355\u5df2\u7ecf\u64cd\u4f5c\u798f\u8d39\u5ef7\uff0c\u65e0\u6cd5\u4ea4\u5355\u878d\u8d44\u3002", (String)"PresentBillFinancValidator_3", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (!(isSurety = SuretyHelper.alreadySuretyRepay((Long)bill.getLong("id"), (String)bill.getDataEntityType().getName()))) continue;
            this.addErrorMessage(dataEntity, LcBusResourceEnum.PresentBillFinancValidator_7.loadKDString());
        }
    }
}

