/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.present;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;

public class PresentBillSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("arrivalamount");
        sic.add("billstatus");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject presentBill = dataEntity.getDataEntity();
            BigDecimal presentAmount = presentBill.getBigDecimal("arrivalamount");
            String billStatus = presentBill.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus) || BigDecimal.ZERO.compareTo(presentAmount) != 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u91d1\u989d\u201d\u3002", (String)"PresentBillSaveValidator_0", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }
}

