/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.present;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.lc.common.enums.PresentStatusEnum;

public class PresentBillUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billstatus");
        sic.add("arrivalstatus");
        sic.add("arrivalno");
        sic.add("isinit");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObject presentBill = dataEntity.getDataEntity();
            String billStatus = presentBill.getString("billstatus");
            String presentStatus = presentBill.getString("arrivalstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus) || !PresentStatusEnum.PRESENT_REGISTER.getValue().equals(presentStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6838&\u4ea4\u5355\u72b6\u6001\u5fc5\u987b\u4e3a\u4ea4\u5355\u5df2\u767b\u8bb0\u624d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"PresentBillUnAuditValidator_0", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (!presentBill.getBoolean("isinit")) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210\u7684\u4ea4\u5355\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"PresentBillUnAuditValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }
}

