/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.receipt;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.AmountProp;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.resource.TmcBizResource;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class ReceiptBillSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("amount");
        sic.add("billstatus");
        sic.add("notarramount");
        sic.add("totalarramount");
        sic.add("amountscaleupper");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject applyBill = dataEntity.getDataEntity();
            BigDecimal amount = applyBill.getBigDecimal("amount");
            String billStatus = applyBill.getString("billstatus");
            if (BillStatusEnum.AUDIT.getValue().equals(billStatus) && BigDecimal.ZERO.compareTo(amount) == 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u91d1\u989d\u201d\u3002", (String)"ReceiptBillSaveValidator_0", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            BigDecimal totalPreAmount = applyBill.getBigDecimal("totalarramount");
            applyBill.set("notarramount", (Object)LetterCreditHelper.getAmount((DynamicObject)applyBill).subtract(totalPreAmount));
            for (IDataEntityProperty prop : applyBill.getDataEntityType().getProperties()) {
                if (!(prop instanceof AmountProp) || applyBill.getBigDecimal(prop.getName()).compareTo(Constants.MAX_AMOUNT) <= 0) continue;
                this.addErrorMessage(dataEntity, new TmcBizResource().checkAmountMaxValue(prop.getDisplayName().getLocaleValue()));
            }
        }
    }
}

