/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.arrival;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.SuretyHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.lc.business.validate.resource.LcBusResourceEnum;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.ArrivalTypeEnum;
import kd.tmc.lc.common.enums.ArrivalWayEnum;
import kd.tmc.lc.common.enums.TradeChannelEnum;
import kd.tmc.lc.common.helper.LcParameterHelper;
import kd.tmc.lc.common.helper.LetterCreditHelper;
import kd.tmc.lc.formplugin.resource.LcFormResourceEnum;

public class ArrivalBillList
extends AbstractTmcListPlugin {
    private static final String LC_REPAY_POPS = "arrivalstatus,billstatus,arrivaltype,org,arrivalcurrency,lettercredit,ispayconfig,arrivalway,todoamount,lockamount,arrivalamount,arrivalno,isfinancapply,eassrcid,isinit,tradechannel";
    private static final String CONFIRM_REPAY_CALLBACK = "confirm_repay_callback";

    public void filterContainerInit(FilterContainerInitArgs args) {
        String isQueryDefault;
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Optional<FilterColumn> bizDateFilterOp = filterColumnList.stream().filter(filterCol -> StringUtils.equals((CharSequence)filterCol.getFieldName(), (CharSequence)"arrivaldate")).findFirst();
        if (bizDateFilterOp.isPresent() && "no".equals(isQueryDefault = (String)formShowParameter.getCustomParam("isquerydefault"))) {
            bizDateFilterOp.get().setDefaultValue("");
        }
    }

    private void showPayConfigPage(Long id) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("lc_payconfig");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("id", id);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "confirm_back"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)"confirm_back", (CharSequence)actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "affirmbill": {
                if (!this.checkArrivalConfirm()) {
                    args.setCancel(true);
                    break;
                }
                this.getPageCache().put("confirm", "true");
                break;
            }
            case "copy": {
                this.getPageCache().put("copy", "true");
                break;
            }
            case "pushpaybill": {
                if (this.checkCanPushPayBill()) break;
                args.setCancel(true);
                break;
            }
            case "unpayconfirm": {
                if (this.checkCanUnPayConfirm()) break;
                args.setCancel(true);
                break;
            }
            case "suretyrepay": {
                String checkRes = this.checkCanSuretyRepay();
                if (!EmptyUtil.isNoEmpty((String)checkRes)) break;
                this.getView().showTipNotification(checkRes);
                args.setCancel(true);
                break;
            }
            case "associatgen": {
                Long selectedId = this.getSelectedId();
                if (null == selectedId) {
                    args.setCancel(true);
                    return;
                }
                DynamicObject arrivalBill = ArrivalBillList.loadArrival(selectedId);
                if (!TradeChannelEnum.ONLINE.getValue().equals(arrivalBill.getString("tradechannel"))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u94f6\u4f01\u76f4\u8054\u7684\u5230\u5355\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u5173\u8054\u751f\u6210\u3002", (String)"ArrivalBillList_4", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getCallBackId().equals(CONFIRM_REPAY_CALLBACK)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getView().invokeOperation("suretyrepay");
            } else if (MessageBoxResult.No.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getView().invokeOperation("pushpaybill");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "unconfirm": 
            case "unpayconfirm": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "buyerint": {
                this.getView().invokeOperation("pushbuyerint");
                break;
            }
            case "associatgen": {
                boolean isCheck;
                Long selectedId = this.getSelectedId();
                if (null == selectedId) {
                    return;
                }
                boolean bl = isCheck = !SuretyHelper.alreadySuretyRepay((Long)selectedId, (String)this.getDataEntityName()) && EmptyUtil.isEmpty((String)this.checkCanSuretyRepay());
                if (isCheck) {
                    this.getView().showConfirm(String.format(LcFormResourceEnum.ArrivalBillListPlugin_14.loadKDString(), new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_REPAY_CALLBACK, (IFormPlugin)this));
                    break;
                }
                this.getView().invokeOperation("pushpaybill");
                break;
            }
            case "tblpay": {
                Long id = super.getSelectedId();
                if (!EmptyUtil.isNoEmpty((Long)id) || !this.checkCanPayConfirm(id)) break;
                this.showPayConfigPage(id);
                break;
            }
            case "affirmbill": {
                this.getView().invokeOperation("modify");
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        if (this.getPageCache().getAll().containsKey("confirm")) {
            e.getParameter().setCustomParam("confirm", (Object)"true");
        }
        this.getPageCache().remove("confirm");
        if (this.getPageCache().getAll().containsKey("copy")) {
            e.getParameter().setCustomParam("copy", (Object)"true");
        }
        this.getPageCache().remove("copy");
    }

    public void billClosedCallBack(BillClosedCallBackEvent e) {
        String actionId = e.getCloseCallBack().getActionId();
        if (StringUtils.equals((CharSequence)"buyerIntEdit", (CharSequence)actionId)) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refreshData();
        }
    }

    private boolean checkArrivalConfirm() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return false;
        }
        DynamicObject arrivalBill = ArrivalBillList.loadArrival(id);
        if (!BillStatusEnum.isAudit((String)arrivalBill.getString("billstatus")) || !ArrivalStatusEnum.isArrivalRegister((String)arrivalBill.getString("arrivalstatus"))) {
            this.getView().showTipNotification(LcFormResourceEnum.ArrivalBillListPlugin_0.loadKDString());
            return false;
        }
        if (arrivalBill.getBoolean("isinit")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210\u7684\u5230\u5355\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u505a\u5230\u5355\u786e\u8ba4\u3002", (String)"ArrivalBillList_1", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (TradeChannelEnum.ONLINE.getValue().equals(arrivalBill.getString("tradechannel"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u94f6\u4f01\u76f4\u8054\u7684\u5230\u5355\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u624b\u52a8\u786e\u8ba4\u3002", (String)"ArrivalBillList_3", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private String checkCanSuretyRepay() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return "";
        }
        DynamicObject arrivalBill = ArrivalBillList.loadArrival(id);
        boolean checkRes = this.checkBaseStatus(arrivalBill);
        if (checkRes) {
            return LcFormResourceEnum.ArrivalBillListPlugin_7.loadKDString();
        }
        String payMethod = LcParameterHelper.getAppStringParameter((long)arrivalBill.getDynamicObject("org").getLong("id"), (String)"paymethod");
        if (!BaseEnableEnum.DISABLE.getValue().equals(payMethod)) {
            return LcFormResourceEnum.ArrivalBillListPlugin_10.loadKDString();
        }
        BigDecimal todoAmount = arrivalBill.getBigDecimal("todoamount");
        BigDecimal lockAmount = arrivalBill.getBigDecimal("lockamount");
        if (lockAmount.compareTo(todoAmount) >= 0) {
            return LcFormResourceEnum.ArrivalBillListPlugin_20.loadKDString();
        }
        if (arrivalBill.getBoolean("isfinancapply")) {
            return LcFormResourceEnum.ArrivalBillListPlugin_19.loadKDString();
        }
        if (EmptyUtil.isNoEmpty((String)arrivalBill.getString("eassrcid"))) {
            return LcFormResourceEnum.ArrivalBillListPlugin_17.loadKDString();
        }
        if (arrivalBill.getBoolean("isinit")) {
            return LcFormResourceEnum.ArrivalBillListPlugin_18.loadKDString();
        }
        boolean isPayConfig = arrivalBill.getBoolean("ispayconfig");
        if (isPayConfig) {
            return LcFormResourceEnum.ArrivalBillListPlugin_21.loadKDString();
        }
        String arrivalType = arrivalBill.getString("arrivaltype");
        if (!ArrivalTypeEnum.CREDIT.getValue().equals(arrivalType)) {
            return LcFormResourceEnum.ArrivalBillListPlugin_11.loadKDString();
        }
        DynamicObject arrivalCurrency = arrivalBill.getDynamicObject("arrivalcurrency");
        if (EmptyUtil.isNoEmpty((DynamicObject)arrivalCurrency)) {
            DynamicObject letterCredit = arrivalBill.getDynamicObject("lettercredit");
            if (EmptyUtil.isEmpty((DynamicObject)letterCredit)) {
                return LcFormResourceEnum.ArrivalBillListPlugin_12.loadKDString();
            }
            QFilter idFilter = new QFilter("entry.debtbillid", "=", letterCredit.getPkValue());
            idFilter.and("enable", "=", (Object)true);
            Object[] suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)"currency", (QFilter[])new QFilter[]{idFilter});
            if (EmptyUtil.isEmpty((Object[])suretyBills)) {
                return LcFormResourceEnum.ArrivalBillListPlugin_15.loadKDString();
            }
            if (!this.isSameCurrency((DynamicObject[])suretyBills, arrivalCurrency)) {
                return LcFormResourceEnum.ArrivalBillListPlugin_13.loadKDString();
            }
        }
        return "";
    }

    private static DynamicObject loadArrival(Long id) {
        return TmcDataServiceHelper.loadSingle((Object)id, (String)"lc_arrival", (String)LC_REPAY_POPS);
    }

    private boolean isSameCurrency(DynamicObject[] suretyBills, DynamicObject arrivalCurrency) {
        if (EmptyUtil.isEmpty((DynamicObject)arrivalCurrency)) {
            return false;
        }
        for (DynamicObject suretyBill : suretyBills) {
            DynamicObject currency = suretyBill.getDynamicObject("currency");
            if (arrivalCurrency.getLong("id") != currency.getLong("id")) continue;
            return true;
        }
        return false;
    }

    private boolean checkCanPayConfirm(Long id) {
        BigDecimal lockAmount;
        boolean flag;
        DynamicObject arrivalBill = ArrivalBillList.loadArrival(id);
        String payMethod = LcParameterHelper.getAppStringParameter((long)arrivalBill.getDynamicObject("org").getLong("id"), (String)"paymethod");
        if (BaseEnableEnum.DISABLE.getValue().equals(payMethod)) {
            this.getView().showTipNotification(LcFormResourceEnum.ArrivalBillListPlugin_4.loadKDString());
            return false;
        }
        if (arrivalBill.getBoolean("isinit")) {
            this.getView().showTipNotification(LcFormResourceEnum.ArrivalBillListPlugin_22.loadKDString());
            return false;
        }
        boolean isPushPay = LetterCreditHelper.checkPushPaybill((long)id, (String)arrivalBill.getString("arrivalno"));
        if (isPushPay) {
            this.getView().showTipNotification(LcFormResourceEnum.ArrivalBillListPlugin_23.loadKDString());
            return false;
        }
        BigDecimal arrivalAmount = arrivalBill.getBigDecimal("todoamount");
        boolean bl = flag = arrivalAmount.compareTo(lockAmount = arrivalBill.getBigDecimal("lockamount")) > 0;
        if (!flag || this.checkBaseStatus(arrivalBill)) {
            this.getView().showTipNotification(LcFormResourceEnum.ArrivalBillListPlugin_1.loadKDString());
            return false;
        }
        if (TradeChannelEnum.ONLINE.getValue().equals(arrivalBill.getString("tradechannel"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u94f6\u4f01\u76f4\u8054\u7684\u5230\u5355\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u624b\u52a8\u786e\u8ba4\u3002", (String)"ArrivalBillList_3", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean isSurety = SuretyHelper.alreadySuretyRepay((Long)arrivalBill.getLong("id"), (String)arrivalBill.getDataEntityType().getName());
        if (isSurety) {
            this.getView().showTipNotification(LcBusResourceEnum.PresentBillFinancValidator_7.loadKDString());
            return false;
        }
        return true;
    }

    private boolean checkCanPushPayBill() {
        BigDecimal lockAmount;
        boolean flag;
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return false;
        }
        DynamicObject arrivalBill = ArrivalBillList.loadArrival(id);
        BigDecimal todoAmount = arrivalBill.getBigDecimal("todoamount");
        boolean bl = flag = todoAmount.compareTo(lockAmount = arrivalBill.getBigDecimal("lockamount")) > 0;
        if (!flag || this.checkBaseStatus(arrivalBill)) {
            this.getView().showTipNotification(LcFormResourceEnum.ArrivalBillListPlugin_2.loadKDString());
            return false;
        }
        if (EmptyUtil.isNoEmpty((String)arrivalBill.getString("eassrcid"))) {
            this.getView().showTipNotification(LcFormResourceEnum.ArrivalBillListPlugin_9.loadKDString());
            return false;
        }
        if (arrivalBill.getBoolean("isinit")) {
            this.getView().showTipNotification(LcFormResourceEnum.ArrivalBillListPlugin_16.loadKDString());
            return false;
        }
        boolean isPayConfig = arrivalBill.getBoolean("ispayconfig");
        if (isPayConfig) {
            this.getView().showTipNotification(LcFormResourceEnum.ArrivalBillListPlugin_3.loadKDString());
            return false;
        }
        String payMethod = LcParameterHelper.getAppStringParameter((long)arrivalBill.getDynamicObject("org").getLong("id"), (String)"paymethod");
        if (BaseEnableEnum.ENABLE.getValue().equals(payMethod)) {
            this.getView().showTipNotification(LcFormResourceEnum.ArrivalBillListPlugin_5.loadKDString());
            return false;
        }
        return true;
    }

    private boolean checkCanUnPayConfirm() {
        DynamicObject letterCredit;
        String creditBillNo;
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return false;
        }
        DynamicObject arrivalBill = ArrivalBillList.loadArrival(id);
        String arrivalType = arrivalBill.getString("arrivaltype");
        if (ArrivalTypeEnum.CREDIT.getValue().equals(arrivalType) && EmptyUtil.isNoEmpty((String)(creditBillNo = LetterCreditHelper.getIsCloseCreditStatus((DynamicObject)(letterCredit = arrivalBill.getDynamicObject("lettercredit")))))) {
            this.getView().showTipNotification(LcFormResourceEnum.ArrivalBillListPlugin_6.loadKDString(creditBillNo));
            return false;
        }
        return true;
    }

    private boolean checkBaseStatus(DynamicObject arrivalBill) {
        return !BillStatusEnum.isAudit((String)arrivalBill.getString("billstatus")) || !ArrivalStatusEnum.isArrivalConfirm((String)arrivalBill.getString("arrivalstatus")) || ArrivalWayEnum.PROTEST.getValue().equals(arrivalBill.getString("arrivalway"));
    }
}

