/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.base;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.MainOrgEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.AfterChangeMainOrgEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.MainOrgChangeListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.LetterBizTypeEnum;
import kd.tmc.lc.common.enums.TradeChannelEnum;
import kd.tmc.lc.common.helper.BaseDataHelper;
import kd.tmc.lc.common.helper.LetterCreditHelper;
import kd.tmc.lc.formplugin.resource.LcFormResourceEnum;

public class LetterCreditBaseEdit
extends AbstractBillPlugIn
implements MainOrgChangeListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(LetterCreditBaseEdit.class);

    public void registerListener(EventObject e) {
        TextEdit noticeBank = (TextEdit)this.getControl("noticebank");
        TextEdit reimbursingBank = (TextEdit)this.getControl("reimbursingbank");
        TextEdit confirmingBank = (TextEdit)this.getControl("confirmingbank");
        TextEdit negotiatingBank = (TextEdit)this.getControl("negotiatingbank");
        noticeBank.addButtonClickListener((ClickListener)this);
        reimbursingBank.addButtonClickListener((ClickListener)this);
        confirmingBank.addButtonClickListener((ClickListener)this);
        negotiatingBank.addButtonClickListener((ClickListener)this);
        MainOrgEdit mainOrgEdit = (MainOrgEdit)this.getView().getControl("org");
        mainOrgEdit.addMainOrgChangeListener((MainOrgChangeListener)this);
        BasedataEdit benefitEdit = (BasedataEdit)this.getControl("benefiter");
        benefitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        LetterCreditHelper.setDefaultBillType((IDataModel)this.getModel());
        this.initBizContactInfo();
        this.initApplyInfo();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initDealBillTerm();
        this.initBenefiterType();
        this.setForwardDaysMustInput();
        this.setLowUpStr();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "bizcontactor": {
                this.initBizContactInfo();
                break;
            }
            case "benefiter": {
                this.initBenefitCountry();
                this.setBenefiterOther();
                break;
            }
            case "benefitertype": {
                this.initBenefiterType();
                this.delBenefiterF7();
                break;
            }
            case "org": {
                this.initApplyInfo();
                break;
            }
            case "validdate": {
                this.setDealBillTerm();
                break;
            }
            case "dealbilltermend": {
                this.setValidDateMin();
                break;
            }
            case "material": {
                int index = args.getChangeSet()[0].getRowIndex();
                this.setModelNum(index);
                break;
            }
            case "benefitcountry": {
                this.setPageCache(propName);
                this.setCargoCountry();
                break;
            }
            case "cargocountry": 
            case "benefitaddress": 
            case "bankcountry": 
            case "bankaddress": {
                this.setPageCache(propName);
                break;
            }
            case "isforward": {
                this.setForwardDaysMustInput();
                break;
            }
        }
    }

    private void setForwardDaysMustInput() {
        boolean isForward;
        if ("lc_bizapply".equals(this.getModel().getDataEntityType().getName())) {
            String bizType = (String)this.getModel().getValue("biztype");
            if (LetterBizTypeEnum.OPEN_CARD.getValue().equals(bizType)) {
                return;
            }
        }
        if (isForward = ((Boolean)this.getModel().getValue("isforward")).booleanValue()) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"forwarddays"});
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"forwarddays"});
        }
    }

    private void initBizContactInfo() {
        DynamicObject bizContactor = (DynamicObject)this.getModel().getValue("bizcontactor");
        if (EmptyUtil.isNoEmpty((DynamicObject)bizContactor)) {
            DynamicObject userInfo = BaseDataHelper.getUserInfo((Long)((Long)bizContactor.getPkValue()));
            String phone = userInfo.getString("phone");
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"bizcontactinfo", (Object)phone);
        }
    }

    private void initApplyInfo() {
        DynamicObject applyer = (DynamicObject)this.getModel().getValue("org");
        logger.info("applyer=======================" + applyer);
        if (EmptyUtil.isNoEmpty((DynamicObject)applyer)) {
            DynamicObject country = applyer.getDynamicObject("country");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"applycountry", (Object)country);
            String address = applyer.getString("contactaddress");
            logger.info("contactaddress=======================" + address);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"applyaddress", (Object)address);
        }
    }

    private void setPageCache(String propName) {
        this.getPageCache().put(propName, "true");
    }

    private void initBenefitCountry() {
        String benefitType = (String)this.getModel().getValue("benefitertype");
        DynamicObject benefit = (DynamicObject)this.getModel().getValue("benefiter");
        switch (benefitType) {
            case "bos_org": {
                this.setCountrySideByOrg(benefit);
                break;
            }
            case "bd_supplier": 
            case "bd_customer": {
                this.setCountrySideByType(benefitType, benefit);
            }
        }
    }

    private void setCountrySideByOrg(DynamicObject benefiter) {
        if (EmptyUtil.isNoEmpty((DynamicObject)benefiter)) {
            DynamicObject orgInfo = TmcOrgDataHelper.getOrgById((long)((Long)benefiter.getPkValue()));
            if (this.isCanRefresh("benefitcountry")) {
                this.setCountrySide(orgInfo, "benefitcountry");
            }
            if (this.isCanRefresh("benefitaddress")) {
                this.setContactAddress(orgInfo, "benefitaddress");
            }
            if (this.isCanRefresh("cargocountry")) {
                this.setCountrySide(orgInfo, "cargocountry");
            }
        }
    }

    private void setCountrySideByType(String benefiterType, DynamicObject benefiter) {
        if (EmptyUtil.isNoEmpty((DynamicObject)benefiter)) {
            DynamicObject info = BaseDataHelper.getInfoByBenefiterType((String)benefiterType, (Long)((Long)benefiter.getPkValue()));
            if (this.isCanRefresh("benefitcountry")) {
                this.setCountrySide(info, "benefitcountry");
            }
            if (this.isCanRefresh("benefitaddress")) {
                this.setContactAddressByType(info, "benefitaddress");
            }
        }
    }

    private boolean isCanRefresh(String propName) {
        String propNameChange = this.getPageCache().get(propName);
        return !"true".equals(propNameChange);
    }

    private void initBenefiterType() {
        String benefitType = (String)this.getModel().getValue("benefitertype");
        if ("fbd_other".equals(benefitType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"benefiterother"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"benefiter"});
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"benefiter"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"benefiterother"});
        }
    }

    private void setBenefiterOther() {
        DynamicObject benefiter = (DynamicObject)this.getModel().getValue("benefiter");
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"benefiterother", EmptyUtil.isNoEmpty((DynamicObject)benefiter) ? benefiter.getString("name") : null);
    }

    private void setCountrySide(DynamicObject orgInfo, String field) {
        DynamicObject country = orgInfo.getDynamicObject("country");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)field, (Object)country);
    }

    private void setCargoCountry() {
        DynamicObject benefitCountry = (DynamicObject)this.getModel().getValue("benefitcountry");
        if (this.isCanRefresh("cargocountry")) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"cargocountry", (Object)benefitCountry);
        }
    }

    private void setContactAddress(DynamicObject orgInfo, String field) {
        String address = orgInfo.getString("contactaddress");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)field, (Object)address);
    }

    private void setContactAddressByType(DynamicObject orgInfo, String field) {
        String address = orgInfo.getString("bizpartner_address");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)field, (Object)address);
    }

    private void delBenefiterF7() {
        this.getModel().setValue("benefiter", (Object)"");
        this.getModel().setValue("benefiterother", (Object)"");
        if (this.isCanRefresh("benefitcountry")) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"benefitcountry", null);
        }
        if (this.isCanRefresh("benefitaddress")) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"benefitaddress", null);
        }
        if (this.isCanRefresh("cargocountry")) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"cargocountry", null);
        }
    }

    private void setDealBillTerm() {
        Date validDate = (Date)this.getModel().getValue("validdate");
        if (validDate != null) {
            DateRangeEdit dealBillTerm = (DateRangeEdit)this.getControl("dealbillterm");
            dealBillTerm.setMaxDate(validDate);
            this.getModel().setValue("dealbilltermstart", (Object)DateUtils.getLastDay((Date)validDate, (int)21));
            this.getModel().setValue("dealbilltermend", (Object)validDate);
            DateEdit lastDate = (DateEdit)this.getControl("lastdate");
            lastDate.setMaxDate(validDate);
        }
    }

    private void initDealBillTerm() {
        Date validDate = (Date)this.getModel().getValue("validdate");
        if (validDate != null) {
            DateRangeEdit dealBillTerm = (DateRangeEdit)this.getControl("dealbillterm");
            dealBillTerm.setMaxDate(validDate);
            DateEdit lastDate = (DateEdit)this.getControl("lastdate");
            lastDate.setMaxDate(validDate);
        }
    }

    private void setValidDateMin() {
        if (this.getModel().getProperty("tradechannel") != null) {
            String tradeChannel = (String)this.getModel().getValue("tradechannel");
            if (EmptyUtil.isNoEmpty((String)tradeChannel) && TradeChannelEnum.ONLINE.getValue().equals(tradeChannel)) {
                return;
            }
            Date endDate = (Date)this.getModel().getValue("dealbilltermend");
            if (endDate != null) {
                DateEdit validDate = (DateEdit)this.getControl("validdate");
                validDate.setMinDate(endDate);
            }
        }
    }

    private void setModelNum(int index) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("material", index);
        if (EmptyUtil.isNoEmpty((DynamicObject)material)) {
            this.getModel().setValue("modelnum", (Object)material.getString("modelnum"), index);
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Control) {
            String key;
            switch (key = ((Control)evt.getSource()).getKey()) {
                case "reimbursingbank": 
                case "confirmingbank": 
                case "negotiatingbank": {
                    this.showF7Bank(key);
                    break;
                }
                case "noticebank": {
                    this.showOnlineBank(key);
                }
            }
        }
    }

    private void showF7Bank(String key) {
        this.showF7Bank(key, null);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection rows;
        super.closedCallBack(e);
        if ((StringUtils.equals((CharSequence)"noticebank", (CharSequence)e.getActionId()) || StringUtils.equals((CharSequence)"reimbursingbank", (CharSequence)e.getActionId()) || StringUtils.equals((CharSequence)"confirmingbank", (CharSequence)e.getActionId()) || StringUtils.equals((CharSequence)"negotiatingbank", (CharSequence)e.getActionId())) && EmptyUtil.isNoEmpty((Object)(rows = (ListSelectedRowCollection)e.getReturnData()))) {
            ListSelectedRow selectedRow = rows.get(0);
            String name = selectedRow.getName();
            this.getModel().setValue(e.getActionId(), (Object)name);
            if (StringUtils.equals((CharSequence)"noticebank", (CharSequence)e.getActionId())) {
                Long selPkID = (Long)selectedRow.getPrimaryKeyValue();
                DynamicObject beBankInfo = BaseDataHelper.getBeBankInfo((Long)selPkID);
                if (this.isCanRefresh("bankcountry")) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bankcountry", (Object)beBankInfo.getDynamicObject("country"));
                }
                if (this.isCanRefresh("bankaddress")) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bankaddress", (Object)beBankInfo.getString("address"));
                }
            }
        }
    }

    public void afterChangeMainOrg(AfterChangeMainOrgEventArgs e) {
        this.initApplyInfo();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String property = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)property, (CharSequence)"benefiter")) {
            String benefitType = (String)this.getModel().getValue("benefitertype");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (StringUtils.equals((CharSequence)benefitType, (CharSequence)"bos_org")) {
                QFilter qFilter = new QFilter("fisbankroll", "=", (Object)"1");
                showParameter.setCustomParam("orgFuncId", (Object)"08");
                List qFilters = showParameter.getListFilterParameter().getQFilters();
                qFilters.add(qFilter);
            }
        }
    }

    private void showOnlineBank(String key) {
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getProperty("tradechannel")) && TradeChannelEnum.ONLINE.getValue().equals(this.getModel().getValue("tradechannel"))) {
            this.showF7Bank(key, new QFilter("swift_code", "!=", (Object)""));
        } else {
            this.showF7Bank(key);
        }
    }

    private void showF7Bank(String key, QFilter qFilter) {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"bd_bebank", (boolean)Boolean.FALSE);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        if (EmptyUtil.isNoEmpty((Object)qFilter)) {
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void setLowUpStr() {
        this.getModel().setValue("lowstr", (Object)LcFormResourceEnum.LetterCreditBaseEdit_0.loadKDString());
        this.getModel().setValue("upperstr", (Object)LcFormResourceEnum.LetterCreditBaseEdit_1.loadKDString());
    }
}

