/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.config;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.PresentStatusEnum;
import kd.tmc.lc.common.property.LetterCreditProp;
import kd.tmc.lc.formplugin.resource.LcFormResourceEnum;

public class BizConfigEdit
extends AbstractTmcBillEdit {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Label title = (Label)this.getView().getControl("title");
        String operate = (String)this.getView().getFormShowParameter().getCustomParam("operate");
        String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
        this.getModel().setValue("lowstr", (Object)LcFormResourceEnum.LetterCreditBaseEdit_0.loadKDString());
        this.getModel().setValue("upperstr", (Object)LcFormResourceEnum.LetterCreditBaseEdit_1.loadKDString());
        String content = "";
        switch (operate) {
            case "close": {
                title.setText(ResManager.loadKDString((String)"\u95ed\u5377\u786e\u8ba4", (String)"BizConfigEdit_8", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"credittype", LetterCreditProp.SRCCREDITLIMIT, LetterCreditProp.CHANGECREDITTYPE, LetterCreditProp.CHANGECREDITLIMIT, "remark"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"repeal"});
                if ("lc_lettercredit".equals(entity)) {
                    content = ResManager.loadKDString((String)"\u64cd\u4f5c\u95ed\u5377\u786e\u8ba4\u540e\uff0c\u4f1a\u5c06\u5f00\u8bc1\u767b\u8bb0\u7684\u4fe1\u7528\u8bc1\u72b6\u6001\u7f6e\u4e3a\u5df2\u95ed\u5377\u3002\u4fe1\u7528\u8bc1\u95ed\u5377\u540e\u5c06\u65e0\u6cd5\u518d\u4e0b\u63a8\u5230\u5355\uff0c\u4e5f\u4e0d\u5141\u8bb8\u5230\u5355\u518d\u5173\u8054\u9009\u62e9\u8be5\u4fe1\u7528\u8bc1\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002", (String)"BizConfigEdit_0", (String)"tmc-lc-formplugin", (Object[])new Object[0]);
                }
                if ("lc_receipt".equals(entity)) {
                    content = ResManager.loadKDString((String)"\u64cd\u4f5c\u95ed\u5377\u786e\u8ba4\u540e\uff0c\u4f1a\u5c06\u6536\u8bc1\u767b\u8bb0\u7684\u4fe1\u7528\u8bc1\u72b6\u6001\u7f6e\u4e3a\u5df2\u95ed\u5377\u3002\u4fe1\u7528\u8bc1\u95ed\u5377\u540e\u5c06\u65e0\u6cd5\u518d\u4e0b\u63a8\u4ea4\u5355\uff0c\u4e5f\u4e0d\u5141\u8bb8\u4ea4\u5355\u518d\u5173\u8054\u9009\u62e9\u8be5\u4fe1\u7528\u8bc1\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002", (String)"BizConfigEdit_3", (String)"tmc-lc-formplugin", (Object[])new Object[0]);
                    this.changeFieldName();
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{LetterCreditProp.SURPLUSAMOUNT});
                }
                title.addTips(this.createTips(content));
                break;
            }
            case "activate": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{LetterCreditProp.SURPLUSAMOUNT, "credittype", LetterCreditProp.SRCCREDITLIMIT, LetterCreditProp.CHANGECREDITTYPE, "remark"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"repeal"});
                title.setText(ResManager.loadKDString((String)"\u6fc0\u6d3b\u786e\u8ba4", (String)"BizConfigEdit_9", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                if ("lc_lettercredit".equals(entity)) {
                    content = ResManager.loadKDString((String)"\u64cd\u4f5c\u6fc0\u6d3b\u786e\u8ba4\u540e\uff0c\u4f1a\u5c06\u5f00\u8bc1\u767b\u8bb0\u7684\u4fe1\u7528\u8bc1\u72b6\u6001\u7f6e\u4e3a\u5df2\u767b\u8bb0\u3002\u4fe1\u7528\u8bc1\u6fc0\u6d3b\u540e\u5c06\u5141\u8bb8\u518d\u4e0b\u63a8\u5230\u5355\uff0c\u5141\u8bb8\u5230\u5355\u518d\u5173\u8054\u9009\u62e9\u8be5\u4fe1\u7528\u8bc1\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002", (String)"BizConfigEdit_1", (String)"tmc-lc-formplugin", (Object[])new Object[0]);
                    BasedataEdit control = (BasedataEdit)this.getControl(LetterCreditProp.CHANGECREDITLIMIT);
                    control.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6fc0\u6d3b\u91cd\u65b0\u5360\u7528\u6388\u4fe1", (String)"BizConfigEdit_10", (String)"tmc-lc-formplugin", (Object[])new Object[0])));
                }
                if ("lc_receipt".equals(entity)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{LetterCreditProp.CHANGECREDITLIMIT});
                    content = ResManager.loadKDString((String)"\u64cd\u4f5c\u6fc0\u6d3b\u786e\u8ba4\u540e\uff0c\u4f1a\u5c06\u6536\u8bc1\u767b\u8bb0\u7684\u4fe1\u7528\u8bc1\u72b6\u6001\u7f6e\u4e3a\u5df2\u767b\u8bb0\u3002\u4fe1\u7528\u8bc1\u6fc0\u6d3b\u540e\u5c06\u5141\u8bb8\u4ea4\u5355\u518d\u5173\u8054\u9009\u62e9\u8be5\u4fe1\u7528\u8bc1\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002", (String)"BizConfigEdit_6", (String)"tmc-lc-formplugin", (Object[])new Object[0]);
                    this.changeFieldName();
                }
                title.addTips(this.createTips(content));
                break;
            }
            case "repeal": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"credittype", LetterCreditProp.SRCCREDITLIMIT, LetterCreditProp.CHANGECREDITTYPE, LetterCreditProp.CHANGECREDITLIMIT, "remark", LetterCreditProp.ARRIVEAMOUNT, LetterCreditProp.PAYAMOUNT});
                title.setText(ResManager.loadKDString((String)"\u64a4\u8bc1\u786e\u8ba4", (String)"BizConfigEdit_11", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"repeal"});
                content = ResManager.loadKDString((String)"\u64cd\u4f5c\u64a4\u8bc1\u786e\u8ba4\u540e\uff0c\u4f1a\u5c06\u5f00\u8bc1\u767b\u8bb0\u7684\u4fe1\u7528\u8bc1\u72b6\u6001\u7f6e\u4e3a\u5df2\u64a4\u8bc1\u3002", (String)"BizConfigEdit_12", (String)"tmc-lc-formplugin", (Object[])new Object[0]);
                title.addTips(this.createTips(content));
                break;
            }
            case "creditchange": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{LetterCreditProp.SURPLUSAMOUNT, LetterCreditProp.ARRIVEAMOUNT, LetterCreditProp.PAYAMOUNT});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{LetterCreditProp.CHANGECREDITTYPE});
                title.setText(ResManager.loadKDString((String)"\u6388\u4fe1\u53d8\u66f4", (String)"BizConfigEdit_13", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"repeal"});
                break;
            }
        }
    }

    private void changeFieldName() {
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("org");
        orgEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u53d7\u76ca\u4eba", (String)"BizConfigEdit_7", (String)"tmc-lc-formplugin", (Object[])new Object[0])));
        AmountEdit arriveAmount = (AmountEdit)this.getControl(LetterCreditProp.ARRIVEAMOUNT);
        arriveAmount.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7d2f\u8ba1\u4ea4\u5355\u91d1\u989d", (String)"BizConfigEdit_4", (String)"tmc-lc-formplugin", (Object[])new Object[0])));
        AmountEdit payaMount = (AmountEdit)this.getControl(LetterCreditProp.PAYAMOUNT);
        payaMount.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7d2f\u8ba1\u5df2\u6536\u91d1\u989d", (String)"BizConfigEdit_5", (String)"tmc-lc-formplugin", (Object[])new Object[0])));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof AbstractOperate && "confirm".equalsIgnoreCase((op = (AbstractOperate)source).getOperateKey())) {
            String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
            op.getOption().setVariableValue("entity", entity);
        }
    }

    public Tips createTips(String content) {
        Tips tips = new Tips();
        tips.setType("text");
        tips.setContent(new LocaleString(content));
        return tips;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCreditInfo();
    }

    private void initCreditInfo() {
        Long pkId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
        this.getModel().setValue("id", (Object)pkId);
        DynamicObject credit = TmcDataServiceHelper.loadSingle((Object)pkId, (String)entity);
        this.getModel().setValue("creditno", credit.get("creditno"));
        this.getModel().setValue("currency", credit.get("currency"));
        this.getModel().setValue("amount", credit.get("amount"));
        this.getModel().setValue("org", credit.get("org"));
        this.getModel().setValue("bank", credit.get("bank"));
        this.getModel().setValue("amountscalelow", credit.get("amountscalelow"));
        this.getModel().setValue("amountscaleupper", credit.get("amountscaleupper"));
        String operate = (String)this.getView().getFormShowParameter().getCustomParam("operate");
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"operate", (Object)operate);
        if ("creditchange".equals(operate)) {
            this.getModel().setValue("credittype", credit.get("credittype"));
            this.getModel().setValue(LetterCreditProp.CHANGECREDITTYPE, credit.get("credittype"));
            this.getModel().setValue(LetterCreditProp.SRCCREDITLIMIT, credit.get("creditlimit"));
        } else if ("close".equals(operate) || "repeal".equals(operate)) {
            if ("lc_lettercredit".equals(entity)) {
                this.setTotalAmountCredit(pkId, operate);
            }
            if ("lc_receipt".equals(entity)) {
                this.setTotalAmoutReceipt(pkId);
            }
        } else if ("activate".equals(operate)) {
            if ("lc_lettercredit".equals(entity)) {
                this.getModel().setValue("credittype", credit.get("credittype"));
                this.getModel().setValue(LetterCreditProp.CHANGECREDITTYPE, credit.get("credittype"));
                this.getModel().setValue(LetterCreditProp.SRCCREDITLIMIT, credit.get("creditlimit"));
                this.setTotalAmountCredit(pkId, operate);
            }
            if ("lc_receipt".equals(entity)) {
                this.setTotalAmoutReceipt(pkId);
            }
        }
    }

    private void setTotalAmountCredit(Long pkId, String operate) {
        QFilter qFilter = new QFilter("lettercredit", "=", (Object)pkId);
        qFilter.and("arrivalstatus", "!=", (Object)ArrivalStatusEnum.ARRIVAL_REGISTER.getValue());
        DynamicObjectCollection arrivalBills = QueryServiceHelper.query((String)"lc_arrival", (String)"arrivalamount,doneamount", (QFilter[])qFilter.toArray());
        BigDecimal arrivalAmount = BigDecimal.ZERO;
        BigDecimal doneAmount = BigDecimal.ZERO;
        for (DynamicObject arrivalBill : arrivalBills) {
            arrivalAmount = arrivalAmount.add(arrivalBill.getBigDecimal("arrivalamount"));
            doneAmount = doneAmount.add(arrivalBill.getBigDecimal("doneamount"));
        }
        this.getModel().setValue(LetterCreditProp.ARRIVEAMOUNT, (Object)arrivalAmount);
        this.getModel().setValue(LetterCreditProp.PAYAMOUNT, (Object)doneAmount);
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        BigDecimal amountUpper = (BigDecimal)this.getModel().getValue("amountscaleupper");
        BigDecimal amt = amount.multiply(BigDecimal.ONE.add(amountUpper.divide(Constants.ONE_HUNDRED, 4, 4)));
        BigDecimal surplusAmount = amt.subtract(doneAmount);
        if (BigDecimal.ZERO.compareTo(surplusAmount) < 0) {
            this.getModel().setValue(LetterCreditProp.SURPLUSAMOUNT, (Object)surplusAmount);
        } else if ("activate".equals(operate)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LetterCreditProp.CHANGECREDITLIMIT});
        }
    }

    private void setTotalAmoutReceipt(Long pkId) {
        QFilter qFilter = new QFilter("lettercredit", "=", (Object)pkId);
        qFilter.and("arrivalstatus", "!=", (Object)PresentStatusEnum.PRESENT_REGISTER.getValue());
        DynamicObjectCollection presentBills = QueryServiceHelper.query((String)"lc_present", (String)"arrivalamount,doneamount", (QFilter[])qFilter.toArray());
        BigDecimal presentAmount = BigDecimal.ZERO;
        BigDecimal doneAmount = BigDecimal.ZERO;
        for (DynamicObject presentBill : presentBills) {
            presentAmount = presentAmount.add(presentBill.getBigDecimal("arrivalamount"));
            doneAmount = doneAmount.add(presentBill.getBigDecimal("doneamount"));
        }
        this.getModel().setValue(LetterCreditProp.ARRIVEAMOUNT, (Object)presentAmount);
        this.getModel().setValue(LetterCreditProp.PAYAMOUNT, (Object)doneAmount);
    }
}

