/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.config;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class RecConfigEdit
extends AbstractTmcBillEdit {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long pkId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        this.initPresentInfo(pkId);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "receiptamount": {
                this.changeReceiptAmount();
                break;
            }
            case "serviceamount": 
            case "prereceiptamount": {
                this.changeServiceAmount();
            }
        }
    }

    private void changeReceiptAmount() {
        BigDecimal receiptAmount;
        BigDecimal preReceiptAmount = (BigDecimal)this.getModel().getValue("prereceiptamount");
        BigDecimal serviceAmount = preReceiptAmount.subtract(receiptAmount = (BigDecimal)this.getModel().getValue("receiptamount"));
        if (serviceAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.getModel().setValue("serviceamount", (Object)serviceAmount);
        } else {
            this.getModel().setValue("serviceamount", (Object)BigDecimal.ZERO);
        }
    }

    private void changeServiceAmount() {
        BigDecimal serviceAmount;
        BigDecimal preReceiptAmount = (BigDecimal)this.getModel().getValue("prereceiptamount");
        BigDecimal receiptAmount = preReceiptAmount.subtract(serviceAmount = (BigDecimal)this.getModel().getValue("serviceamount"));
        if (receiptAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.getModel().setValue("receiptamount", (Object)receiptAmount);
        } else {
            this.getModel().setValue("receiptamount", (Object)BigDecimal.ZERO);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("confirm".equals(operateKey) && !this.checkMustInput()) {
            args.setCancel(true);
            return;
        }
    }

    private boolean checkMustInput() {
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)true, (String)"receiptcurrency");
    }

    private void initPresentInfo(Long pkId) {
        this.getModel().setValue("id", (Object)pkId);
        DynamicObject present = TmcDataServiceHelper.loadSingle((Object)pkId, (String)"lc_present");
        this.getModel().setValue("lettercredit", present.get("lettercredit"));
        this.getModel().setValue("arrivalno", present.get("arrivalno"));
        this.getModel().setValue("invoiceno", present.get("invoiceno"));
        this.getModel().setValue("prereceiptamount", present.get("todoamount"));
        this.getModel().setValue("reccurrency", present.get("arrivalcurrency"));
        this.getModel().setValue("receiptcurrency", present.get("arrivalcurrency"));
        this.getModel().setValue("receiptamount", present.get("todoamount"));
        this.getModel().setValue("todoamount", present.get("todoamount"));
    }
}

