/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.lettercredit;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;

public class ArrivalCardTabEdit
extends AbstractFormPlugin
implements HyperLinkClickListener,
TabSelectListener {
    public void registerListener(EventObject e) {
        Tab tabap;
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryarrival");
        if (grid != null) {
            grid.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((tabap = (Tab)this.getView().getControl("tabap")) != null) {
            tabap.addTabSelectListener((TabSelectListener)this);
        }
    }

    private QFilter getQFilter() {
        Long pkId = (Long)this.getModel().getValue("id");
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            return QFilter.of((String)" 1 = 2", (Object[])new Object[0]);
        }
        QFilter qFilter = new QFilter("lettercredit", "=", (Object)pkId);
        qFilter.and("arrivalstatus", "!=", (Object)ArrivalStatusEnum.ARRIVAL_REGISTER.getValue());
        return qFilter;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        DynamicObject rowData = (DynamicObject)this.getModel().getEntryEntity("entryarrival").get(rowIndex);
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("lc_arrival");
        showParameter.setPkId((Object)rowData.getLong("arrivalid"));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initArrivalInfo();
    }

    private void initArrivalInfo() {
        QFilter filter = this.getQFilter();
        DynamicObjectCollection arrivalBills = QueryServiceHelper.query((String)"lc_arrival", (String)"arrivallot,arrivalno,arrivaldate,arrivalcurrency,arrivalamount,id,configtime", (QFilter[])filter.toArray(), (String)"arrivaldate,configtime asc");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)arrivalBills)) {
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
            BigDecimal amountUpper = (BigDecimal)this.getModel().getValue("amountscaleupper");
            BigDecimal amt = amount.multiply(BigDecimal.ONE.add(amountUpper.divide(Constants.ONE_HUNDRED, 4, 4)));
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("entryarrival");
            TableValueSetter vs = new TableValueSetter(new String[0]);
            model.beginInit();
            vs.addField("arrivallot", new Object[0]);
            vs.addField("arrivalno", new Object[0]);
            vs.addField("arrivaldate", new Object[0]);
            vs.addField("arrivalcurrency", new Object[0]);
            vs.addField("arrivalamount", new Object[0]);
            vs.addField("totalarrivalamt", new Object[0]);
            vs.addField("surplusarrivalamt", new Object[0]);
            vs.addField("arrivalid", new Object[0]);
            vs.addField("writetime", new Object[0]);
            BigDecimal totalAmt = BigDecimal.ZERO;
            for (DynamicObject arrivalBill : arrivalBills) {
                BigDecimal arrivalAmount = arrivalBill.getBigDecimal("arrivalamount");
                totalAmt = totalAmt.add(arrivalAmount);
                vs.addRow(new Object[]{arrivalBill.get("arrivallot"), arrivalBill.get("arrivalno"), arrivalBill.get("arrivaldate"), arrivalBill.get("arrivalcurrency"), arrivalAmount, totalAmt, amt.subtract(totalAmt), arrivalBill.get("id"), arrivalBill.get("configtime")});
            }
            model.batchCreateNewEntryRow("entryarrival", vs);
            model.endInit();
            this.getView().updateView("entryarrival");
            this.getModel().setDataChanged(false);
        }
    }

    public void tabSelected(TabSelectEvent e) {
        if (e.getTabKey().equals("tabarrival")) {
            this.initArrivalInfo();
        }
    }
}

