/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.lettercredit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.PaymentTypeEnum;
import kd.tmc.lc.common.enums.TradeChannelEnum;
import kd.tmc.lc.common.helper.OnlineServiceHelper;

public class LetterCreditOnlineEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String BILL_TERMS = "1.SIGNED COMMERCIAL INVOICE IN_______ORIGINALS AND_______COPIES INDICATING L/C NO. AND CONTRACT NO._________\n2.FULL SET _______ SET (TOGETHER WITH _______NON-NEGOTIABLE COPIES) OF CLEAN ON BOARD BILLS OF LADING MADE OUT TO ORDER AND BLANK ENDORSED, MARKED FREIGHT COLLECT PREPAID NOTIFYING APPLICANT WITH FULL NAME AND ADDRESS\n3.AIR WAYBILL CONSIGNED TO AND NOTIFY , MARKED FREIGHT COLLECT PREPAID\n4.FULL SET (INCLUDING ___ORIGINALS AND ___COPIES) OF INSURANCE POLICY/CERTIFICATE FOR AT LEAST ______% OF THE INVOICE VALUE SHOWING CLAIMS PAYABLE IN CHINA IN CURRENCY OF THE CREDIT, BLANK ENDORSED, COVERING INSTITUTE CARGO CLAUSES (A), INSTITUTE WAR CLAUSES (CARGO) AND INSTITURE STRIKES CLAUSES (CARGO) AND\n5.PACKING LIST/WEIGHT MEMO IN ORIGINALS AND COPIES ISSUED BY INDICATING \n6.CERTIFICATE OF QUANTITY IN ORIGINALS AND COPIES ISSUED BY INDICATING \n7.CERTIFICATE OF QUALITY IN ORIGINALS AND COPIES ISSUED BY INDICATING \n8.CERTIFICATE OF ORIGIN IN ORIGINALS AND COPIES ISSUED BY \n9.BENEFICIARY\u2019S CERTIFIED COPY OF FAX /E-MAIL DISPATCHED TO THE APPLICANT WITHIN DAYS AFTER SHIPMENT ADVISING NAME OF VESSEL /FLIGHT NO., B/L NO., LOADING PORT /AIRPORT OF DEPARTURE, DATE OF SHIPMENT, CONTRACT NO., L/C NO., AND \n10.BENEFICIARY\u2019S CERTIFICATE CERTIFYING THAT EXTRA COPIES OF ALL DOCUMENTS REQUIRED IN THIS CREDIT HAVE BEEN SENT TO THE APPLICANT WITHIN ____ DAYS AFTER SHIPMENT. \n11.OTHER DOCUMENTS:";
    private static final String ADD_TERMS = "*ALL BANKING CHARGES EXCEPT OPENING CHARGE AND ACCEPTANCE COMMISSION ARE FOR ACCOUNT OF BENEFICIARY.\n1.DOCUMENTS TO BE PRESENTED WITHIN_____DAYS AFTER THE DATE OF SHIPMENT BUT WITHIN THE VALIDITY OF THE CREDIT.\n2.SHIPPER/CONSIGNOR ON ANY DOCUMENT OTHER THAN BENEFICIARY NOT ACCEPTABLE.\n3.SHORT FORM/BLANK BACK B/L NOT ACCEPTABLE.\n4.BOTH QUANTITY AND AMOUNT ______% MORE OR LESS ARE ALLOWED.\n5.ALL DOCUMENTS SHOULD BE FORWARDED TO THE ISSUING BANK IN ONE LOT BY COURIER.\n6.ALL DOCUMENTS MUST BE ISSUED IN ENGLISH AND INDICATE THIS CREDIT NUMBER.\n*DOCUMENTS MUST NOT BE DATED PRIOR TO THE ISSUANCE DATE OF THIS CREDIT.\n7.OTHER CONDITIONS:";

    public void registerListener(EventObject e) {
        BasedataEdit feePayer;
        BasedataEdit feeacctBankEdit = (BasedataEdit)this.getControl("lfeeacctbank");
        if (feeacctBankEdit != null) {
            feeacctBankEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((feePayer = (BasedataEdit)this.getControl("feepayer")) != null) {
            feePayer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.setOpenAddressDefVal();
        if (!((Boolean)this.getModel().getValue("isforward")).booleanValue()) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"paymenttype", (Object)PaymentTypeEnum.PRESENT_PAY.getValue());
        } else {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"paymenttype", (Object)PaymentTypeEnum.PREINST_FORWARD.getValue());
        }
    }

    public void afterCopyData(EventObject e) {
        this.setOpenAddressDefVal();
        this.setBizDateDefValue();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String field;
        switch (field = e.getProperty().getName()) {
            case "bank": {
                this.getModel().setValue("lfeeacctbank", null);
                break;
            }
            case "org": {
                this.getModel().setValue("lfeeacctbank", null);
                this.setOpenAddressDefVal();
                break;
            }
            case "tradechannel": {
                String tradeChannel = (String)this.getModel().getValue("tradechannel");
                this.setMustInputByTradeChannel(tradeChannel);
                this.setTermDefaultVal();
                this.setBizDateDefValue();
                this.setPaymentType();
                break;
            }
            case "isforward": {
                this.setPaymentType();
                break;
            }
            case "benefiter": {
                this.setBenefiterDefCountry();
                break;
            }
            case "basenoticebank": {
                this.setNoticeBankInfo();
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        this.setPaymentType((Boolean)this.getModel().getValue("isforward"));
        this.setMustInputByTradeChannel((String)this.getModel().getValue("tradechannel"));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String property = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        switch (property) {
            case "lfeeacctbank": {
                DynamicObject bank = (DynamicObject)this.getModel().getValue("bank");
                if (EmptyUtil.isEmpty((DynamicObject)bank)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5f00\u8bc1\u884c\u3002", (String)"LetterCreditOnlineEdit_0", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (EmptyUtil.isEmpty((DynamicObject)org)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5f00\u8bc1\u4eba\u3002", (String)"LetterCreditOnlineEdit_1", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                long orgId = org == null ? 0L : org.getLong("id");
                long bankId = bank == null ? 0L : bank.getLong("id");
                QFilter qFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId).and("bank", "=", (Object)bankId);
                qFilters.add(qFilter);
                break;
            }
            case "basenoticebank": {
                if (!TradeChannelEnum.ONLINE.getValue().equals(this.getModel().getValue("tradechannel"))) {
                    return;
                }
                QFilter bankFilter = QFilter.isNotNull((String)"swift_code");
                qFilters.add(bankFilter);
                break;
            }
            case "feepayer": {
                DynamicObject bank = (DynamicObject)this.getModel().getValue("bank");
                if (EmptyUtil.isEmpty((DynamicObject)bank)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5f00\u8bc1\u884c\u3002", (String)"LetterCreditOnlineEdit_0", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                List<Long> feePayerCCBs = Arrays.asList(2033298412962611200L, 2033298573277298688L);
                QFilter feePayerFilter = OnlineServiceHelper.CCB_BANKTYPE.longValue() == bank.getLong("bank_cate.id") ? new QFilter("id", "in", feePayerCCBs) : new QFilter("id", "not in", feePayerCCBs);
                qFilters.add(feePayerFilter);
                break;
            }
        }
    }

    private void setTermDefaultVal() {
        String tradeChannel = (String)this.getModel().getValue("tradechannel");
        if (!TradeChannelEnum.ONLINE.getValue().equals(tradeChannel)) {
            return;
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW == status || OperationStatus.EDIT == status) {
            Object addTerm;
            Object billTerm = this.getModel().getValue("billterm_tag");
            if (EmptyUtil.isEmpty((Object)billTerm)) {
                this.getModel().setValue("billterm_tag", (Object)BILL_TERMS);
            }
            if (EmptyUtil.isEmpty((Object)(addTerm = this.getModel().getValue("addterm_tag")))) {
                this.getModel().setValue("addterm_tag", (Object)ADD_TERMS);
            }
        }
    }

    private void setPaymentType(boolean isForward) {
        ComboEdit paymentTypeComboEdit = (ComboEdit)this.getControl("paymenttype");
        if (!isForward) {
            paymentTypeComboEdit.setComboItems(Collections.singletonList(new ComboItem(new LocaleString(PaymentTypeEnum.PRESENT_PAY.getName()), PaymentTypeEnum.PRESENT_PAY.getValue())));
        } else {
            ArrayList<ComboItem> data = new ArrayList<ComboItem>(4);
            data.add(new ComboItem(new LocaleString(PaymentTypeEnum.INVOICE_FORWARD.getName()), PaymentTypeEnum.INVOICE_FORWARD.getValue()));
            data.add(new ComboItem(new LocaleString(PaymentTypeEnum.PREINST_FORWARD.getName()), PaymentTypeEnum.PREINST_FORWARD.getValue()));
            data.add(new ComboItem(new LocaleString(PaymentTypeEnum.PRESENT_FORWARD.getName()), PaymentTypeEnum.PRESENT_FORWARD.getValue()));
            data.add(new ComboItem(new LocaleString(PaymentTypeEnum.SAILING_FORWARD.getName()), PaymentTypeEnum.SAILING_FORWARD.getValue()));
            paymentTypeComboEdit.setComboItems(data);
        }
    }

    private void setMustInputByTradeChannel(String tradeChannel) {
        boolean isOffLine = TradeChannelEnum.OFFLINE.getValue().equals(tradeChannel);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isOffLine, (String[])new String[]{"creditno"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!isOffLine ? 1 : 0) != 0, (String[])new String[]{"validdate", "contractnum", "contractcurrency", "benefitaddress", "contractamount", "days", "validaddress", "lastdate", "cargodesc", "amountscalelow", "amountscaleupper", "amountscalelow", "amountscaleupper", "paymenttype", "tradeterms", "feepayer", "bizcontactinfo"});
    }

    private void setOpenAddressDefVal() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
            this.getModel().setValue("applyaddress", (Object)org.getString("contactaddress"));
        }
    }

    private void setBenefiterDefCountry() {
        DynamicObject benefiter = (DynamicObject)this.getModel().getValue("benefiter");
        if (EmptyUtil.isEmpty((DynamicObject)benefiter)) {
            return;
        }
        String entityF7 = benefiter.getDynamicObjectType().getName();
        String propTmp = "bos_org".equals(entityF7) ? "contactaddress" : "bizpartner_address";
        String selectProp = "country," + propTmp + " as contactaddress";
        DynamicObject befefiterFromDb = QueryServiceHelper.queryOne((String)entityF7, (String)selectProp, (QFilter[])new QFilter[]{new QFilter("id", "=", benefiter.getPkValue())});
        this.getModel().setValue("benefitcountry", (Object)befefiterFromDb.getLong("country"));
        this.getModel().setValue("benefitaddress", (Object)befefiterFromDb.getString("contactaddress"));
    }

    private void setNoticeBankInfo() {
        DynamicObject noticeBank = (DynamicObject)this.getModel().getValue("basenoticebank");
        if (EmptyUtil.isEmpty((DynamicObject)noticeBank)) {
            return;
        }
        Long bebankId = Optional.ofNullable(noticeBank.getDynamicObject("bebank")).map(r -> r.getLong("id")).orElse(0L);
        DynamicObject beBankBill = TmcDataServiceHelper.loadSingleFromCache((String)"bd_bebank", (String)"country,address_eng", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bebankId)});
        if (EmptyUtil.isEmpty((DynamicObject)beBankBill)) {
            return;
        }
        this.getModel().setValue("bankcountry", (Object)beBankBill.getLong("country_id"));
        this.getModel().setValue("bankaddress", (Object)beBankBill.getString("address_eng"));
    }

    private void setBizDateDefValue() {
        String tradeChannel = (String)this.getModel().getValue("tradechannel");
        if (TradeChannelEnum.ONLINE.getValue().equals(tradeChannel)) {
            this.getModel().setValue("bizdate", null);
        } else {
            this.getModel().setValue("bizdate", (Object)DateUtils.getCurrentDate());
        }
    }

    private void setPaymentType() {
        if (!TradeChannelEnum.ONLINE.getValue().equals(this.getModel().getValue("tradechannel"))) {
            return;
        }
        boolean isForward = (Boolean)this.getModel().getValue("isforward");
        this.setPaymentType(isForward);
    }
}

