/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.online;

import com.alibaba.fastjson.JSONArray;
import java.util.Collection;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.fbp.webapi.ebentity.biz.arrival.FileListResponseDetail;
import kd.tmc.lc.common.enums.FileDownloadStatusEnum;

public class ArriveOnlineQueryList
extends AbstractTmcListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.removeSpareFilter(args);
        this.setOrgDefValue(args);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        switch (fieldName = args.getFieldName()) {
            case "lcbillno": {
                this.showArrivalBill(args);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "arrquery": {
                this.showQueryForm();
                break;
            }
            case "downloadfile": {
                this.validateBeforeDownload(args);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId;
        switch (callBackId = evt.getCallBackId()) {
            case "CONFIRM_DOWNLOAD": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                TmcOperateServiceHelper.execOperate((String)"downloadfile", (String)"lc_arronlineresult", (Object[])new Object[]{this.getSelectedId()}, (OperateOption)OperateOption.create());
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (EmptyUtil.isEmpty((Object)operationResult) || !operationResult.isSuccess()) {
            return;
        }
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "arrregister": {
                this.getView().updateView();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("arrquery".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void showQueryForm() {
        FormShowParameter showForm = new FormShowParameter();
        showForm.setFormId("lc_arrsynctrans");
        showForm.getOpenStyle().setShowType(ShowType.Modal);
        showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "arrquery"));
        this.getView().showForm(showForm);
    }

    private void showArrivalBill(HyperLinkClickArgs event) {
        event.setCancel(true);
        BillList source = (BillList)event.getHyperLinkClickEvent().getSource();
        Object rowPkId = source.getFocusRowPkId();
        DynamicObject arrOnline = QueryServiceHelper.queryOne((String)"lc_arronlineresult", (String)"lcbillno", (QFilter[])new QFilter[]{new QFilter("id", "=", rowPkId)});
        if (EmptyUtil.isEmpty((DynamicObject)arrOnline)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5230\u5355\u8bb0\u5f55\u67e5\u8be2\u5355\u4e2d\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"ArriveOnlineQueryList_1", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        List arrivalIds = QueryServiceHelper.queryPrimaryKeys((String)"lc_arrival", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)arrOnline.getString("lcbillno"))}, (String)"", (int)-1);
        if (EmptyUtil.isEmpty((Collection)arrivalIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5230\u5355\u5904\u7406\u5355\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"ArriveOnlineQueryList_2", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showForm = new BillShowParameter();
        showForm.setFormId("lc_arrival");
        showForm.setPkId(arrivalIds.get(0));
        showForm.setStatus(OperationStatus.VIEW);
        showForm.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showForm);
    }

    protected void removeSpareFilter(FilterContainerInitArgs args) {
        FilterContainerInitEvent initEvent = args.getFilterContainerInitEvent();
        List commonFilterColumns = initEvent.getCommonFilterColumns();
        commonFilterColumns.removeIf(v -> "createtime".equals(v.getFieldName()));
        List fastFilterColumns = initEvent.getFastFilterColumns();
        fastFilterColumns.removeIf(v -> "billno".equals(v.getFieldName()));
    }

    private void setOrgDefValue(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if (!"org.id".equals(fieldName)) continue;
            commonFilter.setDefaultValue("");
            break;
        }
    }

    private void validateBeforeDownload(BeforeDoOperationEventArgs args) {
        Long selectedId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)selectedId)) {
            args.setCancel(true);
            return;
        }
        DynamicObject arrOnline = QueryServiceHelper.queryOne((String)"lc_arronlineresult", (String)"filelist_tag,filestatus,filelistres_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)selectedId)});
        String fileListStr = arrOnline.getString("filelist_tag");
        if (EmptyUtil.isEmpty((String)fileListStr)) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\uff0c\u65e0\u9700\u4e0b\u8f7d\u3002", (String)"ArriveOnlineQueryList_3", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        if (FileDownloadStatusEnum.isDownloading((String)arrOnline.getString("filestatus"))) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u6b63\u5728\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ArriveOnlineQueryList_4", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        String fileResStr = arrOnline.getString("filelistres_tag");
        if (EmptyUtil.isEmpty((String)fileResStr)) {
            return;
        }
        List fileResList = JSONArray.parseArray((String)fileResStr, FileListResponseDetail.class);
        long failNum = fileResList.stream().filter(r -> r.getDownLoad() == false).count();
        if (failNum == 0L) {
            args.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6587\u4ef6\u5df2\u5168\u90e8\u4e0b\u8f7d\u6210\u529f\uff0c\u662f\u5426\u7ee7\u7eed\u4e0b\u8f7d\uff1f", (String)"ArriveOnlineQueryList_5", (String)"tmc-lc-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_DOWNLOAD", (IFormPlugin)this));
        }
    }
}

