/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.online;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DirectConnSetEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bankType = (BasedataEdit)this.getControl("banktype");
        bankType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit acct = (BasedataEdit)this.getControl("defaultaccount");
        acct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName;
        switch (fieldName = e.getProperty().getName()) {
            case "org": {
                this.getModel().setValue("banktype", null);
                break;
            }
            case "banktype": {
                this.getModel().setValue("defaultaccount", null);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldName;
        switch (fieldName = event.getProperty().getName()) {
            case "banktype": {
                this.validateOrgNotNull(event);
                break;
            }
            case "defaultaccount": {
                this.dealDefaultAcct(event);
                break;
            }
        }
    }

    private boolean validateOrgNotNull(BeforeF7SelectEvent event) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"DirectConnSetEdit_1", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return false;
        }
        return true;
    }

    private void dealDefaultAcct(BeforeF7SelectEvent event) {
        if (!this.validateOrgNotNull(event)) {
            return;
        }
        DynamicObject bankType = (DynamicObject)this.getModel().getValue("banktype");
        if (EmptyUtil.isEmpty((DynamicObject)bankType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u94f6\u884c\u7c7b\u522b\u3002", (String)"DirectConnSetEdit_2", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        QFilter qFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)((DynamicObject)this.getModel().getValue("org")).getLong("id"));
        qFilter.and(new QFilter("bank.bank_cate", "=", bankType.getPkValue()));
        List qFilters = ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().getQFilters();
        qFilters.add(qFilter);
    }
}

