/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.online;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class OnlineQueryList
extends AbstractTmcListPlugin {
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        super.billListHyperLinkClick(args);
        switch (fieldName = args.getFieldName()) {
            case "lcbillno": {
                args.setCancel(true);
                this.lcHyperLinkClick(args);
                break;
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initFilterItem(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if (!"org.id".equals(fieldName)) continue;
            commonFilter.setDefaultValue("");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "query": {
                this.syncTrans();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (EmptyUtil.isEmpty((Object)operationResult) || !operationResult.isSuccess()) {
            return;
        }
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "letterregister": {
                this.getView().updateView();
                break;
            }
        }
    }

    protected void initFilterItem(FilterContainerInitArgs args) {
        this.removeSpareFilter(args);
    }

    protected List<String> getCommonFilterColumns() {
        return Arrays.asList("org", "bank", "bizdate");
    }

    protected void removeSpareFilter(FilterContainerInitArgs args) {
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        List<String> commonFilterNames = Arrays.asList("org.id", "bank.name", "bizdate");
        filterColumns.removeIf(v -> !commonFilterNames.contains(v.getFieldName()));
        args.getFastFilterColumns().removeIf(v -> "billno".contains(v.getFieldName()));
    }

    private void syncTrans() {
        FormShowParameter showForm = new FormShowParameter();
        showForm.setFormId("lc_synctrans");
        showForm.getOpenStyle().setShowType(ShowType.Modal);
        showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "synctrans"));
        this.getView().showForm(showForm);
    }

    private void lcHyperLinkClick(HyperLinkClickArgs args) {
        int rowIndex = args.getRowIndex();
        HyperLinkClickEvent event = args.getHyperLinkClickEvent();
        BillList billList = (BillList)event.getSource();
        ListSelectedRowCollection currentSelectedRowInfo = billList.getSelectedRows();
        if (EmptyUtil.isEmpty((Collection)currentSelectedRowInfo)) {
            return;
        }
        for (ListSelectedRow listSelectedRow : currentSelectedRowInfo) {
            if (rowIndex != listSelectedRow.getRowKey()) continue;
            Object pkId = listSelectedRow.getPrimaryKeyValue();
            DynamicObject onlineResult = QueryServiceHelper.queryOne((String)"lc_onlineresult", (String)"lcbillno", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
            List lcBill = QueryServiceHelper.queryPrimaryKeys((String)"lc_lettercredit", (QFilter[])new QFilter[]{new QFilter("billno", "=", onlineResult.get("lcbillno"))}, (String)"", (int)1);
            if (EmptyUtil.isEmpty((Collection)lcBill)) continue;
            BillShowParameter parameter = new BillShowParameter();
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setFormId(this.getHyperLinkName());
            parameter.setPkId(lcBill.get(0));
            parameter.setCaption(ResManager.loadKDString((String)"\u5f00\u8bc1\u5904\u7406", (String)"OnlineQueryList_0", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private String getHyperLinkName() {
        return "lc_lettercredit";
    }
}

