/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.present;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PresentBillEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entrys");
        if (entryGrid != null) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "lettercredit": {
                this.LetterCreditChgEvt();
                break;
            }
            case "arrivaltype": {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"presendbank", null);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("audit".equals(op.getOperateKey())) {
            this.checkExistArrivalNo(op.getOption());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("audit".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            DynamicObject benefitDo = (DynamicObject)this.getModel().getValue("benefiter");
            Long orgId = EmptyUtil.isNoEmpty((DynamicObject)benefitDo) ? benefitDo.getLong("id") : 0L;
            boolean recCompPresent = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.LC.getId(), (long)orgId, (String)"reccomppresent");
            DynamicObject relateLetterCreditDo = (DynamicObject)this.getModel().getValue("lettercredit");
            if (recCompPresent && EmptyUtil.isNoEmpty((DynamicObject)relateLetterCreditDo)) {
                String creditNo = relateLetterCreditDo.getString("number");
                QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
                qFilter.and(new QFilter("number", "=", (Object)creditNo));
                DynamicObject letterCreditDo = TmcDataServiceHelper.loadSingle((String)"lc_lettercredit_f7", (QFilter[])qFilter.toArray());
                if (EmptyUtil.isNoEmpty((DynamicObject)letterCreditDo) && "bos_org".equals(letterCreditDo.getString("benefitertype"))) {
                    String exists = op.getOption().getVariableValue("existSameCreditNo", "false");
                    if (Boolean.parseBoolean(exists)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u76f8\u540c\u7f16\u53f7\u7684\u5230\u5355\u5355\u636e\uff0c\u81ea\u52a8\u751f\u6210\u5931\u8d25\u3002", (String)"PresentBillEdit_2", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u540c\u65f6\u751f\u6210\u5230\u5355\u5355\u636e\u3002", (String)"PresentBillEdit_3", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                    }
                }
            }
        }
    }

    private boolean checkExistArrivalNo(OperateOption option) {
        String arrivalNo = (String)this.getModel().getValue("arrivalno");
        QFilter arrivalFilter = new QFilter("arrivalno", "=", (Object)arrivalNo);
        boolean exists = TmcDataServiceHelper.exists((String)"lc_arrival", (QFilter[])arrivalFilter.toArray());
        option.setVariableValue("existSameCreditNo", String.valueOf(exists));
        return true;
    }

    private void LetterCreditChgEvt() {
        DynamicObject letterCredit_f7 = (DynamicObject)this.getModel().getValue("lettercredit");
        if (EmptyUtil.isNoEmpty((DynamicObject)letterCredit_f7)) {
            DynamicObject letterCredit = TmcDataServiceHelper.loadSingle((Object)letterCredit_f7.getLong("id"), (String)"lc_receipt");
            DataEntityPropertyCollection propertys = letterCredit.getDataEntityType().getProperties();
            DataEntityPropertyCollection props = this.getModel().getDataEntityType().getProperties();
            for (IDataEntityProperty prop : propertys) {
                if (!this.copyPropertys().contains(prop.getName()) || !props.containsKey((Object)prop.getName())) continue;
                this.getModel().setValue(prop.getName(), letterCredit.get(prop.getName()));
                if (!"currency".equals(prop.getName())) continue;
                this.getModel().setValue("arrivalcurrency", letterCredit.get(prop.getName()));
            }
            this.getModel().setValue("presendbank", (Object)letterCredit.getDynamicObject("bank"));
            this.setInfoEnable(false);
            QFilter qFilter = new QFilter("lettercredit", "=", (Object)letterCredit.getLong("id"));
            int count = TmcDataServiceHelper.count((String)"lc_arrival", (QFilter[])qFilter.toArray());
            this.getModel().setValue("arrivallot", (Object)(++count));
        } else {
            this.getView().invokeOperation("refresh");
            this.setInfoEnable(true);
        }
    }

    private void setInfoEnable(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"org", "currency", "amount", "credittype", "isforward", "forwarddays", "benefitertype", "benefiter", "benefiterother", "arrivalcurrency"});
    }

    protected List copyPropertys() {
        return Arrays.asList("currency", "amount", "credittype", "isforward", "forwarddays", "benefitertype", "benefiter", "benefiterother", "bizcontactor", "bizcontactinfo", "validdate", "lastdate");
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        DynamicObject rowData = (DynamicObject)this.getModel().getEntryEntity("entrys").get(rowIndex);
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("cas_recbill");
        showParameter.setPkId((Object)rowData.getLong("receiptid"));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

