/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.present;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.lc.common.enums.ArrivalWayEnum;
import kd.tmc.lc.common.enums.PresentStatusEnum;
import kd.tmc.lc.common.helper.LcParameterHelper;
import kd.tmc.lc.formplugin.resource.LcFormResourceEnum;

public class PresentBillList
extends AbstractTmcListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if (!customParams.containsKey("isquerydefault") || !"arrivaldate".equals(fieldName)) continue;
            commonFilter.setDefaultValue("");
            break;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "affirmbill": {
                if (!this.checkPresentConfirm()) {
                    args.setCancel(true);
                    return;
                }
                this.getPageCache().put("confirm", "true");
                break;
            }
            case "copy": {
                this.getPageCache().put("copy", "true");
                break;
            }
            case "pushrecbill": {
                if (this.checkCanPushRecBill()) break;
                args.setCancel(true);
                return;
            }
            case "trackarrival": {
                args.setCancel(true);
                this.trackArrivalBill();
                break;
            }
            case "audit": {
                if (this.checkExistArrivalNo(op.getOption())) break;
                args.setCancel(true);
            }
        }
    }

    private boolean checkExistArrivalNo(OperateOption option) {
        List selectedIdList = super.getSelectedIdList();
        if (EmptyUtil.isEmpty((Collection)selectedIdList)) {
            return false;
        }
        for (Long id : selectedIdList) {
            DynamicObject presentBill = TmcDataServiceHelper.loadSingle((Object)id, (String)"lc_present", (String)"arrivalno");
            if (EmptyUtil.isEmpty((DynamicObject)presentBill)) {
                return false;
            }
            QFilter arrivalFilter = new QFilter("arrivalno", "=", (Object)presentBill.getString("arrivalno"));
            boolean exists = TmcDataServiceHelper.exists((String)"lc_arrival", (QFilter[])arrivalFilter.toArray());
            option.setVariableValue("existSameCreditNo", String.valueOf(exists));
        }
        return true;
    }

    private void trackArrivalBill() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return;
        }
        DynamicObject presentBill = TmcDataServiceHelper.loadSingle((Object)id, (String)"lc_present", (String)"lettercredit");
        if (EmptyUtil.isEmpty((DynamicObject)presentBill) || EmptyUtil.isEmpty((DynamicObject)presentBill.getDynamicObject("lettercredit"))) {
            return;
        }
        QFilter creditQFilter = new QFilter("lettercredit.number", "=", (Object)presentBill.getDynamicObject("lettercredit").getString("number"));
        DynamicObjectCollection arrivalBill = QueryServiceHelper.query((String)"lc_arrival", (String)"id", (QFilter[])new QFilter[]{creditQFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)arrivalBill)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"PresentBillList_12", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showTrackView(arrivalBill.stream().map(o -> o.getLong("id")).collect(Collectors.toList()));
    }

    protected void showTrackView(List<Long> pkIds) {
        IFormView view = this.getView();
        if (pkIds.size() == 1) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId((Object)pkIds.get(0));
            showParameter.setFormId("lc_arrival");
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            view.showForm((FormShowParameter)showParameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId("lc_arrival");
            showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("id", "in", pkIds)));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            view.showForm((FormShowParameter)showParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "unconfirm": 
            case "unrecconfirm": 
            case "unfinanc": {
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refreshData();
                break;
            }
            case "affirmbill": {
                this.getView().invokeOperation("modify");
                break;
            }
            case "tblrec": {
                this.showPayConfigPage(super.getSelectedId());
                break;
            }
            case "pushforfaiting": {
                Long selectedId = this.getSelectedId();
                if (!EmptyUtil.isNoEmpty((Long)selectedId)) break;
                this.getView().invokeOperation("pushtoforfaiting");
                break;
            }
            case "audit": {
                List idList = operationResult.getSuccessPkIds();
                DynamicObjectCollection presentBillCol = QueryServiceHelper.query((String)"lc_present", (String)"benefiter,lettercredit.number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)idList)});
                if (EmptyUtil.isEmpty((DynamicObjectCollection)presentBillCol)) break;
                Long orgId = ((DynamicObject)presentBillCol.get(0)).getLong("benefiter");
                boolean recCompPresent = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.LC.getId(), (long)orgId, (String)"reccomppresent");
                String creditNo = ((DynamicObject)presentBillCol.get(0)).getString("lettercredit.number");
                if (!recCompPresent || !EmptyUtil.isNoEmpty((String)creditNo)) break;
                QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
                qFilter.and(new QFilter("number", "=", (Object)creditNo));
                DynamicObject letterCreditDo = TmcDataServiceHelper.loadSingle((String)"lc_lettercredit_f7", (QFilter[])qFilter.toArray());
                if (!EmptyUtil.isNoEmpty((DynamicObject)letterCreditDo) || !"bos_org".equals(letterCreditDo.getString("benefitertype"))) break;
                String exists = ((AbstractOperate)args.getSource()).getOption().getVariableValue("existSameCreditNo", "false");
                if (Boolean.parseBoolean(exists)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u76f8\u540c\u7f16\u53f7\u7684\u5230\u5355\u5355\u636e\uff0c\u81ea\u52a8\u751f\u6210\u5931\u8d25\u3002", (String)"PresentBillList_3", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u540c\u65f6\u751f\u6210\u5230\u5355\u5355\u636e\u3002", (String)"PresentBillList_2", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        if (this.getPageCache().getAll().containsKey("confirm")) {
            e.getParameter().setCustomParam("confirm", (Object)"true");
        }
        this.getPageCache().remove("confirm");
        if (this.getPageCache().getAll().containsKey("copy")) {
            e.getParameter().setCustomParam("copy", (Object)"true");
        }
        this.getPageCache().remove("copy");
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)"confirm_back", (CharSequence)actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private boolean checkPresentConfirm() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return false;
        }
        DynamicObject presentBill = TmcDataServiceHelper.loadSingle((Object)id, (String)"lc_present", (String)"arrivalstatus,billstatus,arrivalno,isinit");
        if (!BillStatusEnum.AUDIT.getValue().equals(presentBill.getString("billstatus")) || !PresentStatusEnum.PRESENT_REGISTER.getValue().equals(presentBill.getString("arrivalstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838&\u4ea4\u5355\u72b6\u6001\u4e3a\u4ea4\u5355\u5df2\u767b\u8bb0\uff0c\u624d\u53ef\u53d1\u8d77\u4ea4\u5355\u786e\u8ba4\u3002", (String)"PresentBillList_0", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (presentBill.getBoolean("isinit")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210\u7684\u4ea4\u5355\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u505a\u4ea4\u5355\u786e\u8ba4\u3002", (String)"PresentBillList_1", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkCanPushRecBill() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return false;
        }
        DynamicObject presentBill = TmcDataServiceHelper.loadSingle((Object)id, (String)"lc_present", (String)"arrivalstatus,billstatus,arrivalamount,todoamount,doneamount,lockamount,ispayconfig,arrivalway,org,isforfaiting,isinit");
        BigDecimal todoAmount = presentBill.getBigDecimal("todoamount");
        BigDecimal lockAmount = presentBill.getBigDecimal("lockamount");
        String arrivalWay = presentBill.getString("arrivalway");
        if (!BillStatusEnum.AUDIT.getValue().equals(presentBill.getString("billstatus")) || !PresentStatusEnum.isConfirm((String)presentBill.getString("arrivalstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838/\u5df2\u786e\u8ba4\u7684\u4ea4\u5355\uff0c\u624d\u80fd\u5173\u8054\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"PresentBillList_4", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (ArrivalWayEnum.PROTEST.getValue().equals(arrivalWay)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u65b9\u5904\u7406\u65b9\u5f0f\u975e\u62d2\u4ed8\u7684\u4ea4\u5355\uff0c\u624d\u80fd\u5173\u8054\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"PresentBillList_9", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (presentBill.getBoolean("isinit")) {
            this.getView().showTipNotification(LcFormResourceEnum.PresentBillList_13.loadKDString());
            return false;
        }
        if (todoAmount.compareTo(lockAmount) <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea4\u5355\u65e0\u672a\u6536\u6b3e\u91d1\u989d\uff0c\u4e0d\u80fd\u5173\u8054\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"PresentBillList_10", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean isPayConfig = presentBill.getBoolean("ispayconfig");
        if (isPayConfig) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u624b\u52a8\u6536\u6b3e\u786e\u8ba4\u8fc7\uff0c\u4e0d\u80fd\u5173\u8054\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"PresentBillList_11", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return false;
        }
        String recMethod = LcParameterHelper.getAppStringParameter((long)presentBill.getDynamicObject("org").getLong("id"), (String)"recmethod");
        if (BaseEnableEnum.ENABLE.getValue().equals(recMethod)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u9009\u62e9\u4e3a\u201c\u4ea4\u5355\u505a\u6536\u6b3e\u786e\u8ba4\u201d\uff0c\u4e0d\u5141\u8bb8\u5173\u8054\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"PresentBillList_6", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean isForfaiting = presentBill.getBoolean("isforfaiting");
        if (isForfaiting) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u5173\u8054\u4e86\u798f\u8d39\u5ef7\u7684\u4ea4\u5355\uff0c\u4e0d\u5141\u8bb8\u5173\u8054\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"PresentBillList_8", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void showPayConfigPage(Long id) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("lc_recconfig");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("id", id);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "confirm_back"));
        this.getView().showForm(showParameter);
    }
}

