/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.receipt;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.PresentStatusEnum;

public class PresentCardTabEdit
extends AbstractFormPlugin
implements HyperLinkClickListener,
TabSelectListener {
    public void registerListener(EventObject e) {
        Tab tabap;
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getView().getControl("entrypresent");
        if (grid != null) {
            grid.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((tabap = (Tab)this.getView().getControl("tabap")) != null) {
            tabap.addTabSelectListener((TabSelectListener)this);
        }
    }

    private QFilter getQFilter() {
        Long pkId = (Long)this.getModel().getValue("id");
        QFilter qFilter = new QFilter("lettercredit", "=", (Object)pkId);
        qFilter.and("arrivalstatus", "!=", (Object)PresentStatusEnum.PRESENT_REGISTER.getValue());
        return qFilter;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        DynamicObject rowData = (DynamicObject)this.getModel().getEntryEntity("entrypresent").get(rowIndex);
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("lc_present");
        showParameter.setPkId((Object)rowData.getLong("presentid"));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initPresentInfo();
    }

    private void initPresentInfo() {
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            return;
        }
        QFilter filter = this.getQFilter();
        DynamicObjectCollection presentBills = QueryServiceHelper.query((String)"lc_present", (String)"id,arrivalno,invoiceno,arrivaldate,arrivalcurrency,arrivalamount,configtime", (QFilter[])filter.toArray(), (String)"arrivaldate,configtime asc");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)presentBills)) {
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
            BigDecimal amountUpper = (BigDecimal)this.getModel().getValue("amountscaleupper");
            BigDecimal amt = amount.multiply(BigDecimal.ONE.add(amountUpper.divide(Constants.ONE_HUNDRED, 4, 4)));
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("entrypresent");
            TableValueSetter vs = new TableValueSetter(new String[0]);
            model.beginInit();
            vs.addField("presentno", new Object[0]);
            vs.addField("preinvoiceno", new Object[0]);
            vs.addField("presentdate", new Object[0]);
            vs.addField("presentcurrency", new Object[0]);
            vs.addField("presentamount", new Object[0]);
            vs.addField("totalpresentamt", new Object[0]);
            vs.addField("surpluspresentamt", new Object[0]);
            vs.addField("presentid", new Object[0]);
            vs.addField("writetime", new Object[0]);
            BigDecimal totalAmt = BigDecimal.ZERO;
            for (DynamicObject presentBill : presentBills) {
                BigDecimal presentAmount = presentBill.getBigDecimal("arrivalamount");
                totalAmt = totalAmt.add(presentAmount);
                vs.addRow(new Object[]{presentBill.get("arrivalno"), presentBill.get("invoiceno"), presentBill.get("arrivaldate"), presentBill.get("arrivalcurrency"), presentAmount, totalAmt, amt.subtract(totalAmt), presentBill.get("id"), presentBill.get("configtime")});
            }
            model.batchCreateNewEntryRow("entrypresent", vs);
            model.endInit();
            this.getView().updateView("entrypresent");
            this.getModel().setDataChanged(false);
        }
    }

    public void tabSelected(TabSelectEvent e) {
        if (e.getTabKey().equals("tabpresent")) {
            this.initPresentInfo();
        }
    }
}

