/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.receipt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.BackCreditTypeEnum;
import kd.tmc.lc.common.enums.PresentStatusEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;
import kd.tmc.lc.common.property.LetterCreditProp;
import kd.tmc.lc.common.property.ReceiptBillProp;

public class ReceiptBillEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private String TEMP_BILLSTATUS_KEY = "Temp_BillStatus";

    public void registerListener(EventObject e) {
        BasedataEdit childCreditEdit = (BasedataEdit)this.getControl("b_childcredit");
        if (childCreditEdit != null) {
            childCreditEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        EntryGrid backCreditGrid = (EntryGrid)this.getControl("entry_backcredit");
        backCreditGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        switch (propName) {
            case "benefitertype": {
                this.initBenefitType();
                this.setBenefiter();
                break;
            }
            case "basenoticebank": {
                DynamicObject baseNoticeBank = (DynamicObject)this.getModel().getValue("basenoticebank");
                if (!EmptyUtil.isNoEmpty((DynamicObject)baseNoticeBank)) break;
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"noticebank", (Object)baseNoticeBank.get("name"));
                break;
            }
            case "b_mothercredit": 
            case "b_childcredit": {
                DynamicObject motherCredit = (DynamicObject)this.getModel().getValue("b_mothercredit", rowIndex);
                DynamicObject childCredit = (DynamicObject)this.getModel().getValue("b_childcredit", rowIndex);
                HashMap<Object, BigDecimal> payAmountMap = new HashMap<Object, BigDecimal>(1);
                if (EmptyUtil.isNoEmpty((DynamicObject)motherCredit)) {
                    DynamicObjectCollection presentCollection = QueryServiceHelper.query((String)"lc_present", (String)"doneamount", (QFilter[])new QFilter[]{new QFilter("arrivalstatus", "!=", (Object)PresentStatusEnum.PRESENT_REGISTER.getValue()), new QFilter("lettercredit", "=", motherCredit.getPkValue())});
                    BigDecimal payAmountSum = Constants.ZERO;
                    for (DynamicObject presentBill : presentCollection) {
                        payAmountSum = payAmountSum.add(presentBill.getBigDecimal("doneamount"));
                    }
                    payAmountMap.put(motherCredit.getPkValue(), payAmountSum);
                } else if (EmptyUtil.isNoEmpty((DynamicObject)childCredit)) {
                    DynamicObjectCollection arrivalCollection = QueryServiceHelper.query((String)"lc_present", (String)"doneamount", (QFilter[])new QFilter[]{new QFilter("arrivalstatus", "!=", (Object)ArrivalStatusEnum.ARRIVAL_REGISTER.getValue()), new QFilter("lettercredit", "=", childCredit.getPkValue())});
                    BigDecimal payAmountSum = Constants.ZERO;
                    for (DynamicObject arrivalBill : arrivalCollection) {
                        payAmountSum = payAmountSum.add(arrivalBill.getBigDecimal("doneamount"));
                    }
                    payAmountMap.put(childCredit.getPkValue(), payAmountSum);
                }
                LetterCreditHelper.initCreditInfo((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)motherCredit, (DynamicObject)childCredit, payAmountMap, (int)rowIndex);
                break;
            }
            case "isbackcredit": {
                this.setBackCreditTypeMustInput();
                break;
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        boolean isBackCredit = (Boolean)this.getModel().getValue("isbackcredit");
        if (isBackCredit) {
            this.getModel().setValue("backcredittype", (Object)BackCreditTypeEnum.MOTHER_CREDIT.getValue());
        }
    }

    private void initBenefitType() {
        String benefitType = (String)this.getModel().getValue("benefitertype");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)"bos_org".equals(benefitType), (String[])new String[]{"basenoticebank"});
    }

    private void initCreditInfo() {
        DynamicObjectCollection backCreditEntry = this.getModel().getEntryEntity("entry_backcredit");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)backCreditEntry)) {
            return;
        }
        HashSet<Object> motherIds = new HashSet<Object>(backCreditEntry.size());
        HashSet<Object> childIds = new HashSet<Object>(backCreditEntry.size());
        for (DynamicObject backCredit : backCreditEntry) {
            DynamicObject motherCredit = backCredit.getDynamicObject("b_mothercredit");
            DynamicObject childCredit = backCredit.getDynamicObject("b_childcredit");
            if (EmptyUtil.isNoEmpty((DynamicObject)motherCredit)) {
                motherIds.add(motherCredit.getPkValue());
                continue;
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)childCredit)) continue;
            childIds.add(childCredit.getPkValue());
        }
        HashMap<Long, BigDecimal> payAmountMap = new HashMap<Long, BigDecimal>(backCreditEntry.size());
        DynamicObjectCollection presentCollection = QueryServiceHelper.query((String)"lc_present", (String)"lettercredit,doneamount", (QFilter[])new QFilter[]{new QFilter("arrivalstatus", "!=", (Object)PresentStatusEnum.PRESENT_REGISTER.getValue()), new QFilter("lettercredit", "in", motherIds)});
        for (Object presentBill : presentCollection) {
            BigDecimal payAmount = (BigDecimal)payAmountMap.get(presentBill.getLong("lettercredit"));
            if (payAmount == null) {
                payAmount = Constants.ZERO;
            }
            payAmountMap.put(presentBill.getLong("lettercredit"), payAmount.add(presentBill.getBigDecimal("doneamount")));
        }
        DynamicObjectCollection arrivalCollection = QueryServiceHelper.query((String)"lc_arrival", (String)"lettercredit,doneamount", (QFilter[])new QFilter[]{new QFilter("arrivalstatus", "!=", (Object)ArrivalStatusEnum.ARRIVAL_REGISTER.getValue()), new QFilter("lettercredit", "in", childIds)});
        for (DynamicObject arrivalBill : arrivalCollection) {
            BigDecimal payAmount = (BigDecimal)payAmountMap.get(arrivalBill.getLong("lettercredit"));
            if (payAmount == null) {
                payAmount = Constants.ZERO;
            }
            payAmountMap.put(arrivalBill.getLong("lettercredit"), payAmount.add(arrivalBill.getBigDecimal("doneamount")));
        }
        for (int rowIndex = 0; rowIndex < backCreditEntry.size(); ++rowIndex) {
            DynamicObject backCredit = (DynamicObject)backCreditEntry.get(rowIndex);
            DynamicObject motherCredit = backCredit.getDynamicObject("b_mothercredit");
            DynamicObject childCredit = backCredit.getDynamicObject("b_childcredit");
            LetterCreditHelper.initCreditInfo((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)motherCredit, (DynamicObject)childCredit, payAmountMap, (int)rowIndex);
        }
    }

    private void setBenefiter() {
        String benefitType = (String)this.getModel().getValue("benefitertype");
        if ("bos_org".equals(benefitType)) {
            Long orgId = RequestContext.get().getOrgId();
            this.getModel().setValue("benefiter", (Object)orgId);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long pkId = (Long)this.getModel().getValue("id");
        QFilter preFilter = new QFilter("lettercredit", "=", (Object)pkId);
        preFilter.and("arrivalstatus", "!=", (Object)PresentStatusEnum.PRESENT_REGISTER.getValue());
        boolean preInfo = TmcDataServiceHelper.exists((String)"lc_present", (QFilter[])preFilter.toArray());
        if (!preInfo) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"detailinfo"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabpresent"});
        }
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(ReceiptBillProp.OP_HISTORY_KEY)) {
            this.getPageCache().put(this.TEMP_BILLSTATUS_KEY, this.getModel().getValue("billstatus").toString());
            this.getModel().setValue("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_del", "bar_submit"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"billno", "org", "creditno"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"applyreason"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"applyreason"});
        }
        this.setBackCreditTypeMustInput();
        this.initBenefitType();
        this.initCreditInfo();
        this.initBizContactMustInput();
    }

    private void setBackCreditTypeMustInput() {
        boolean isBackCredit = (Boolean)this.getModel().getValue("isbackcredit");
        if (isBackCredit && EmptyUtil.isEmpty((String)((String)this.getModel().getValue("backcredittype")))) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"backcredittype", (Object)BackCreditTypeEnum.MOTHER_CREDIT.getValue());
        } else if (!isBackCredit) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"backcredittype", null);
        }
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isBackCredit, (String[])new String[]{"backcredittype"});
        TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"b_orgother", "b_benefiterother"}, (!isBackCredit ? 1 : 0) != 0);
    }

    private void initBizContactMustInput() {
        DynamicObject bizContactor = (DynamicObject)this.getModel().getValue("bizcontactor");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)EmptyUtil.isNoEmpty((DynamicObject)bizContactor), (String[])new String[]{"bizcontactor"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(ReceiptBillProp.OP_HISTORY_KEY)) {
            op.getOption().setVariableValue(LetterCreditProp.OP_HISTORY_KEY, "true");
            String temp_BillStatus = this.getPageCache().get(this.TEMP_BILLSTATUS_KEY);
            this.getModel().setValue("billstatus", (Object)temp_BillStatus);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("save".equals(op.getOperateKey()) && this.getView().getFormShowParameter().getCustomParams().containsKey(LetterCreditProp.OP_HISTORY_KEY) && args.getOperationResult().isSuccess()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"barrefresh", "bar_audit"});
        } else if ("submit".equals(op.getOperateKey()) && this.getView().getFormShowParameter().getCustomParams().containsKey(LetterCreditProp.OP_HISTORY_KEY) && args.getOperationResult().isSuccess()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_audit"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String property = beforeF7SelectEvent.getProperty().getName();
        boolean isBackCredit = (Boolean)this.getModel().getValue("isbackcredit");
        String backCreditType = (String)this.getModel().getValue("backcredittype");
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if (StringUtils.equals((CharSequence)property, (CharSequence)"b_childcredit") && isBackCredit && StringUtils.equals((CharSequence)backCreditType, (CharSequence)BackCreditTypeEnum.MOTHER_CREDIT.getValue())) {
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            QFilter qFilter = new QFilter("org", "=", org.getPkValue());
            DynamicObjectCollection backCreditEntry = this.getModel().getEntryEntity("entry_backcredit");
            ArrayList collect = EmptyUtil.isEmpty((DynamicObjectCollection)backCreditEntry) ? new ArrayList(16) : backCreditEntry.stream().filter(a -> EmptyUtil.isNoEmpty((DynamicObject)a.getDynamicObject("b_childcredit"))).map(b -> b.getDynamicObject("b_childcredit").getString("billno")).collect(Collectors.toList());
            qFilter.and("billno", "not in", collect);
            qFilters.add(qFilter);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        DynamicObject childCreditDo;
        String fieldName;
        int rowIdx = evt.getRowIndex();
        String appId = this.getView().getFormShowParameter().getAppId();
        boolean hasPermission = LetterCreditHelper.hyperLink((String)appId, (String)(fieldName = evt.getFieldName()), (DynamicObject)(childCreditDo = (DynamicObject)this.getModel().getValue(fieldName, rowIdx)));
        if (!hasPermission) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5b50\u8bc1\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"LetterCreditList_15", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter param = new BillShowParameter();
        param.setFormId("lc_lettercredit");
        param.setPkId(childCreditDo.getPkValue());
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setBillStatus(BillOperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)param);
    }
}

