/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackParam;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.ArrivalTypeEnum;
import kd.tmc.lc.common.enums.ArrivalWayEnum;
import kd.tmc.lc.common.enums.PayOperateTypeEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class ArrivalWriteBackHelper {
    private static final String OpKey = "lcWriteback";

    private static void writeBackArrivalBill(DynamicObject sourBill, String fields, doLockExcute exc) {
        String arrivalId = sourBill.getString("id");
        boolean isLockSuc = MutexServiceHelper.request((String)arrivalId, (String)"lc_arrival", (String)OpKey);
        if (isLockSuc) {
            try {
                DynamicObject arrBill = TmcDataServiceHelper.loadSingle((Object)arrivalId, (String)"lc_arrival", (String)fields);
                exc.doOperate(arrBill);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                MutexServiceHelper.release((String)arrivalId, (String)"lc_arrival", (String)OpKey);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u5230\u5355\u5904\u7406[%s]\u6b63\u5728\u66f4\u65b0\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"ArrivalWriteBackHelper_0", (String)"tmc-lc-mservice", (Object[])new Object[]{sourBill.getString("billno")}));
        }
    }

    public static void doSaveAndSubmitExecute(PayBillWriteBackParam param, DynamicObject sourBill) {
        String fields = "todoamount,lockamount,entrys,entrys.seq,entrys.payno,entrys.payid,ispayment";
        PayBillWriteBackParam.PayBillInfo payBill = param.getPayBill();
        Long payBillId = payBill.getPayBillId();
        String nowSettletNumber = payBill.getSettletNumber();
        ArrivalWriteBackHelper.checkLcBill(sourBill, nowSettletNumber);
        ArrivalWriteBackHelper.writeBackArrivalBill(sourBill, fields, arrBill -> {
            BigDecimal lockAmt;
            BigDecimal todoAmount;
            DynamicObject entry2;
            BigDecimal payAmount = payBill.getAmount();
            QFilter filter = new QFilter("id", "=", (Object)payBillId).and(QFilter.isNotNull((String)"settletnumber"));
            DynamicObject oldPayBill = QueryServiceHelper.queryOne((String)"cas_paybill", (String)"actpayamt,settletnumber", (QFilter[])new QFilter[]{filter});
            BigDecimal oldPayAmt = BigDecimal.ZERO;
            String oldSettletNumber = "";
            if (EmptyUtil.isNoEmpty((DynamicObject)oldPayBill) && EmptyUtil.isNoEmpty((String)oldPayBill.getString("settletnumber"))) {
                oldPayAmt = oldPayBill.getBigDecimal("actpayamt");
                oldSettletNumber = oldPayBill.getString("settletnumber");
            }
            DynamicObject oldArrBill = null;
            if (EmptyUtil.isNoEmpty((String)oldSettletNumber) && !oldSettletNumber.equals(nowSettletNumber)) {
                QFilter qOldFilter = new QFilter("arrivalno", "=", (Object)oldSettletNumber);
                oldArrBill = TmcDataServiceHelper.loadSingle((String)"lc_arrival", (String)"todoamount,lockamount,entrys,entrys.seq,entrys.payno,entrys.payid,ispayment", (QFilter[])qOldFilter.toArray());
                DynamicObjectCollection entrys = oldArrBill.getDynamicObjectCollection("entrys");
                for (DynamicObject entry2 : entrys) {
                    if (payBillId.longValue() != entry2.getLong("payid")) continue;
                    entrys.remove((Object)entry2);
                    break;
                }
                if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
                    oldArrBill.set("ispayment", (Object)"0");
                }
                oldArrBill.set("lockamount", (Object)oldArrBill.getBigDecimal("lockamount").subtract(oldPayAmt));
                oldPayAmt = BigDecimal.ZERO;
            }
            if (payAmount.compareTo((todoAmount = arrBill.getBigDecimal("todoamount")).subtract(lockAmt = arrBill.getBigDecimal("lockamount").subtract(oldPayAmt))) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5230\u5355\u5173\u8054\u7684\u6240\u6709\u4ed8\u6b3e\u5355\u7684\u4ed8\u6b3e\u91d1\u989d\u5408\u8ba1\uff0c\u4e0d\u5141\u8bb8\u8d85\u8fc7\u5230\u5355\u7684\u672a\u4ed8\u91d1\u989d\u3002", (String)"ArrivalWriteBackHelper_1", (String)"tmc-lc-mservice", (Object[])new Object[0]));
            }
            DynamicObjectCollection entrys = arrBill.getDynamicObjectCollection("entrys");
            entry2 = entrys.parallelStream().filter(o -> payBillId.longValue() == o.getLong("payid")).findFirst().orElse(null);
            if (EmptyUtil.isEmpty((DynamicObject)entry2)) {
                int seq = entrys.size() + 1;
                DynamicObject addNew = entrys.addNew();
                addNew.set("seq", (Object)seq);
                addNew.set("payno", (Object)payBill.getPayBillNo());
                addNew.set("payid", (Object)payBillId);
            } else {
                entry2.set("payno", (Object)payBill.getPayBillNo());
            }
            arrBill.set("lockamount", (Object)arrBill.getBigDecimal("lockamount").subtract(oldPayAmt).add(payAmount));
            arrBill.set("ispayment", (Object)"1");
            try (TXHandle tx = TX.requiresNew((String)"payWriteBacklc");){
                try {
                    if (oldArrBill != null) {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{oldArrBill});
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{arrBill});
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        });
    }

    public static void doDeleteExecute(PayBillWriteBackParam param, DynamicObject sourBill) {
        ArrivalWriteBackHelper.checkLcBill(sourBill, param.getPayBill().getSettletNumber());
        String fields = "doneamount,todoamount,arrivalamount,lockamount,arrivalstatus,entrys.operatetype,entrys.arrpayamount,entrys,entrys.payid,ispayment";
        ArrivalWriteBackHelper.writeBackArrivalBill(sourBill, fields, arrBill -> {
            PayBillWriteBackParam.PayBillInfo payBill = param.getPayBill();
            DynamicObjectCollection entrys = arrBill.getDynamicObjectCollection("entrys");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
                Iterator iterator = entrys.iterator();
                while (iterator.hasNext()) {
                    DynamicObject entry = (DynamicObject)iterator.next();
                    if (payBill.getPayBillId().longValue() != entry.getLong("payid")) continue;
                    iterator.remove();
                    break;
                }
            }
            ArrivalWriteBackHelper.updateLockPayAmt(arrBill, entrys);
            ArrivalWriteBackHelper.updateSourcebill(arrBill);
        });
    }

    public static void doPayExecute(PayBillWriteBackParam param, DynamicObject sourBill) {
        String settletNumber = param.getPayBill().getSettletNumber();
        ArrivalWriteBackHelper.checkLcBill(sourBill, settletNumber);
        ArrivalWriteBackHelper.checkLcBillStatus(sourBill);
        String fields = "doneamount,todoamount,arrivalamount,lockamount,entrys.operatetype,entrys.arrpayamount,ispayment,arrivalstatus,entrys,entrys.payid,entrys.arrpaycurrency,entrys.realpaydate,entrys.isdiffcur,entrys.paycurrency,entrys.exchangerate,entrys.payamount,entrys.payremark,lettercredit,arrivaltype";
        ArrivalWriteBackHelper.writeBackArrivalBill(sourBill, fields, arrBill -> {
            PayBillWriteBackParam.PayBillInfo payBill = param.getPayBill();
            Boolean isDiffCur = payBill.isDiffCur();
            BigDecimal dPAmt = payBill.getDpAmt();
            BigDecimal amount = payBill.getAmount();
            BigDecimal payAmount = isDiffCur != false ? dPAmt : amount;
            Long currencypk = payBill.getCurrencypk();
            Long dpcurrency = payBill.getDpcurrency();
            Long payCurrency = isDiffCur != false ? dpcurrency : currencypk;
            Long returnId = null;
            DynamicObjectCollection entrys = arrBill.getDynamicObjectCollection("entrys");
            DynamicObject entry = entrys.parallelStream().filter(o -> payBill.getPayBillId().longValue() == o.getLong("payid")).findFirst().orElse(null);
            if (EmptyUtil.isNoEmpty((DynamicObject)entry)) {
                returnId = (Long)entry.getPkValue();
                entry.set("arrpayamount", (Object)amount);
                entry.set("arrpaycurrency", (Object)currencypk);
                entry.set("realpaydate", (Object)payBill.getPayDate());
                entry.set("isdiffcur", (Object)isDiffCur);
                if (isDiffCur.booleanValue()) {
                    entry.set("paycurrency", (Object)payCurrency);
                    entry.set("exchangerate", (Object)payBill.getAgreedrate());
                    entry.set("payamount", (Object)payAmount);
                }
                entry.set("operatetype", (Object)PayOperateTypeEnum.PAYMENT.getValue());
                entry.set("payremark", (Object)payBill.getDescription());
            }
            ArrivalWriteBackHelper.updateLockPayAmt(arrBill, entrys);
            try (TXHandle tx = TX.requiresNew();){
                try {
                    ArrivalWriteBackHelper.saveSourBillAndMakeLimit(arrBill, amount, "return", returnId, payBill.getPayDate());
                    if (EmptyUtil.isNoEmpty((DynamicObject)arrBill.getDynamicObject("lettercredit"))) {
                        GuaranteeUseHelper.returnGuaranteeUse((long)arrBill.getDynamicObject("lettercredit").getLong("id"), (Long)payBill.getPayBillId(), (String)"cas_paybill", (BigDecimal)payAmount);
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{arrBill});
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        });
    }

    public static void doCancelPayExecute(PayBillWriteBackParam param, DynamicObject sourBill) {
        String settletNumber = param.getPayBill().getSettletNumber();
        ArrivalWriteBackHelper.checkLcBill(sourBill, settletNumber);
        String fields = "doneamount,todoamount,arrivalamount,lockamount,entrys.operatetype,entrys.arrpayamount,ispayment,lettercredit,entrys,entrys.payid,entrys.arrpaycurrency,entrys.realpaydate,entrys.isdiffcur,entrys.paycurrency,entrys.exchangerate,entrys.payamount,entrys.payremark,arrivalstatus,arrivaltype";
        ArrivalWriteBackHelper.writeBackArrivalBill(sourBill, fields, arrBill -> {
            PayBillWriteBackParam.PayBillInfo payBill = param.getPayBill();
            BigDecimal amount = payBill.getAmount();
            Long returnId = null;
            DynamicObject letterCredit = arrBill.getDynamicObject("lettercredit");
            String creditBillno = LetterCreditHelper.getIsCloseCreditStatus((DynamicObject)letterCredit);
            if (!"".equals(creditBillno)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5230\u5355\u5173\u8054\u7684\u5f00\u8bc1\u5904\u7406:%s\u4fe1\u7528\u72b6\u6001\u4e3a\u201c\u5df2\u95ed\u5377\u201d\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"ArrivalWriteBackHelper_2", (String)"tmc-lc-mservice", (Object[])new Object[0]), creditBillno));
            }
            DynamicObjectCollection entrys = arrBill.getDynamicObjectCollection("entrys");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
                for (DynamicObject entry : entrys) {
                    if (payBill.getPayBillId().longValue() != entry.getLong("payid")) continue;
                    returnId = (Long)entry.getPkValue();
                    entry.set("arrpayamount", (Object)BigDecimal.ZERO);
                    entry.set("arrpaycurrency", null);
                    entry.set("realpaydate", null);
                    entry.set("isdiffcur", (Object)false);
                    entry.set("paycurrency", null);
                    entry.set("exchangerate", (Object)BigDecimal.ZERO);
                    entry.set("payamount", (Object)BigDecimal.ZERO);
                    entry.set("operatetype", null);
                    entry.set("payremark", null);
                    break;
                }
            }
            ArrivalWriteBackHelper.updateLockPayAmt(arrBill, entrys);
            try (TXHandle tx = TX.requiresNew();){
                try {
                    ArrivalWriteBackHelper.saveSourBillAndMakeLimit(arrBill, amount, "cancel", returnId, null);
                    GuaranteeUseHelper.cancelReturnGuaranteeUse((Long)payBill.getPayBillId(), (String)"cas_paybill");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{arrBill});
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        });
    }

    public static void doChargebackExecute(PayBillWriteBackParam param, DynamicObject sourBill) {
        String settletNumber = param.getPayBill().getSettletNumber();
        ArrivalWriteBackHelper.checkLcBill(sourBill, settletNumber);
        String fields = "entrys,entrys.payid,entrys.operatetype,lockamount";
        ArrivalWriteBackHelper.writeBackArrivalBill(sourBill, fields, arrBill -> {
            PayBillWriteBackParam.PayBillInfo payBill = param.getPayBill();
            BigDecimal amount = payBill.getAmount();
            DynamicObjectCollection entrys = arrBill.getDynamicObjectCollection("entrys");
            DynamicObject entry = entrys.parallelStream().filter(o -> payBill.getPayBillId().longValue() == o.getLong("payid") && !PayOperateTypeEnum.CHARGEBACK.getValue().equals(o.getString("operatetype"))).findFirst().orElse(null);
            if (EmptyUtil.isNoEmpty((DynamicObject)entry)) {
                entry.set("operatetype", (Object)PayOperateTypeEnum.CHARGEBACK.getValue());
                BigDecimal lockAmount = arrBill.getBigDecimal("lockamount").subtract(amount);
                arrBill.set("lockamount", (Object)(lockAmount.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : lockAmount));
                ArrivalWriteBackHelper.updateSourcebill(arrBill);
            }
        });
    }

    public static void doRefundExecute(PayBillWriteBackParam param, DynamicObject sourBill) {
        String settletNumber = param.getPayBill().getSettletNumber();
        ArrivalWriteBackHelper.checkLcBill(sourBill, settletNumber);
        String fields = "entrys,entrys.payid,entrys.operatetype,entrys.returnamount";
        ArrivalWriteBackHelper.writeBackArrivalBill(sourBill, fields, arrBill -> {
            PayBillWriteBackParam.PayBillInfo payBill = param.getPayBill();
            DynamicObjectCollection entrys = arrBill.getDynamicObjectCollection("entrys");
            DynamicObject entry = entrys.parallelStream().filter(o -> payBill.getPayBillId().longValue() == o.getLong("payid") && !PayOperateTypeEnum.REFUND.getValue().equals(o.getString("operatetype"))).findFirst().orElse(null);
            if (EmptyUtil.isNoEmpty((DynamicObject)entry)) {
                entry.set("operatetype", (Object)PayOperateTypeEnum.REFUND.getValue());
                entry.set("returnamount", (Object)payBill.getRefundamt());
                ArrivalWriteBackHelper.updateSourcebill(arrBill);
            }
        });
    }

    public static void doRenoteExecute(PayBillWriteBackParam param, DynamicObject sourBill) {
        String settletNumber = param.getPayBill().getSettletNumber();
        ArrivalWriteBackHelper.checkLcBill(sourBill, settletNumber);
        String fields = "doneamount,todoamount,arrivalamount,lockamount,entrys.operatetype,arrivalstatus,entrys.arrpayamount,ispayment,entrys,entrys.payid,entrys.operatetype,entrys.returnamount";
        ArrivalWriteBackHelper.writeBackArrivalBill(sourBill, fields, arrBill -> {
            PayBillWriteBackParam.PayBillInfo payBill = param.getPayBill();
            DynamicObjectCollection entrys = arrBill.getDynamicObjectCollection("entrys");
            DynamicObject entry = entrys.parallelStream().filter(o -> payBill.getPayBillId().longValue() == o.getLong("payid") && !PayOperateTypeEnum.RENOTE.getValue().equals(o.getString("operatetype"))).findFirst().orElse(null);
            if (EmptyUtil.isNoEmpty((DynamicObject)entry)) {
                entry.set("operatetype", (Object)PayOperateTypeEnum.RENOTE.getValue());
                entry.set("returnamount", (Object)payBill.getRefundamt());
                ArrivalWriteBackHelper.updateLockPayAmt(arrBill, entrys);
                ArrivalWriteBackHelper.updateSourcebill(arrBill);
            }
        });
    }

    public static void cancelRefundAndRenoteExecute(PayBillWriteBackParam param, DynamicObject sourBill) {
        String settletNumber = param.getPayBill().getSettletNumber();
        ArrivalWriteBackHelper.checkLcBill(sourBill, settletNumber);
        String fields = "doneamount,todoamount,arrivalamount,lockamount,arrivalstatus,entrys.operatetype,entrys.arrpayamount,ispayment,entrys,entrys.payid,entrys.returnamount";
        ArrivalWriteBackHelper.writeBackArrivalBill(sourBill, fields, arrBill -> {
            PayBillWriteBackParam.PayBillInfo payBill = param.getPayBill();
            String operate = param.getOperate();
            DynamicObjectCollection entrys = arrBill.getDynamicObjectCollection("entrys");
            DynamicObject entry = entrys.parallelStream().filter(o -> payBill.getPayBillId().longValue() == o.getLong("payid")).findFirst().orElse(null);
            if (EmptyUtil.isNoEmpty((DynamicObject)entry)) {
                entry.set("operatetype", (Object)PayOperateTypeEnum.PAYMENT.getValue());
                entry.set("returnamount", (Object)BigDecimal.ZERO);
                if ("cancelRenote".equals(operate)) {
                    ArrivalWriteBackHelper.updateLockPayAmt(arrBill, entrys);
                }
            }
            ArrivalWriteBackHelper.updateSourcebill(arrBill);
        });
    }

    public static void checkLcBill(DynamicObject sourBill, String settleNumber) {
        if (EmptyUtil.isEmpty((String)settleNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u5f02\u5e38\uff1a\u4ed8\u6b3e\u5904\u7406\u8fd4\u56de\u5230\u5355\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4ed8\u6b3e\u5904\u7406\u7ed3\u7b97\u53f7\u3002", (String)"ArrivalWriteBackHelper_3", (String)"tmc-lc-mservice", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((DynamicObject)sourBill)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u5f02\u5e38\uff1a\u4ed8\u6b3e\u5904\u7406\u8fd4\u56de\u5230\u5355\u7f16\u53f7\u4e3a[%s]\uff0c\u67e5\u8be2\u5173\u8054\u4fe1\u7528\u8bc1\u5230\u5355\u5355\u636e\u5931\u8d25\u3002", (String)"ArrivalWriteBackHelper_4", (String)"tmc-lc-mservice", (Object[])new Object[]{settleNumber}));
        }
    }

    public static void checkLcBillStatus(DynamicObject sourBill) {
        if (ArrivalWayEnum.PROTEST.getValue().equals(sourBill.getString("arrivalway"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u5f02\u5e38\uff1a\u5230\u5355\u5904\u7406[%s]\u7684\u5230\u5355\u5904\u7406\u65b9\u5f0f\u4e3a\u62d2\u4ed8\uff0c\u4e0d\u80fd\u5173\u8054\u4ed8\u6b3e\u5355\u3002", (String)"ArrivalWriteBackHelper_5", (String)"tmc-lc-mservice", (Object[])new Object[]{sourBill.getString("billno")}));
        }
        if (sourBill.getBoolean("isinit")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u5f02\u5e38\uff1a\u5230\u5355\u5904\u7406[%s]\u7531\u521d\u59cb\u5316\u751f\u6210\uff0c\u4e0d\u80fd\u5173\u8054\u4ed8\u6b3e\u5355\u3002", (String)"ArrivalWriteBackHelper_6", (String)"tmc-lc-mservice", (Object[])new Object[]{sourBill.getString("billno")}));
        }
        if (EmptyUtil.isNoEmpty((String)sourBill.getString("eassrcid"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u5f02\u5e38\uff1a\u5230\u5355\u5904\u7406[%s]\u4e3a\u96c6\u6210\u6570\u636e\uff0c\u4e0d\u80fd\u5173\u8054\u4ed8\u6b3e\u5355\u3002", (String)"ArrivalWriteBackHelper_7", (String)"tmc-lc-mservice", (Object[])new Object[]{sourBill.getString("billno")}));
        }
        if (!ArrivalStatusEnum.isArrivalConfirm((String)sourBill.getString("arrivalstatus"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u5f02\u5e38\uff1a\u5230\u5355\u5904\u7406[%s]\u7684\u5230\u5355\u72b6\u6001\u4e3a\u5230\u5355\u5df2\u786e\u8ba4\uff0c\u624d\u80fd\u5173\u8054\u4ed8\u6b3e\u5355\u3002", (String)"ArrivalWriteBackHelper_8", (String)"tmc-lc-mservice", (Object[])new Object[]{sourBill.getString("billno")}));
        }
        if (sourBill.getBoolean("ispayconfig")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u5f02\u5e38\uff1a\u5230\u5355\u5904\u7406[%s]\u5df2\u624b\u52a8\u4ed8\u6b3e\u786e\u8ba4\u8fc7\uff0c\u4e0d\u5141\u8bb8\u5173\u8054\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"ArrivalWriteBackHelper_10", (String)"tmc-lc-mservice", (Object[])new Object[]{sourBill.getString("billno")}));
        }
    }

    public static void checkPaymentidentify(PayBillWriteBackParam param, DynamicObject sourceBill) {
        DynamicObject payIdentity;
        String payIdentype = "0";
        if (EmptyUtil.isNoEmpty((Long)param.getPayBill().getPaymentidentify()) && EmptyUtil.isNoEmpty((DynamicObject)(payIdentity = QueryServiceHelper.queryOne((String)"cas_paymentidentify", (String)"type", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)param.getPayBill().getPaymentidentify())}))) && "1".equals(payIdentity.getString("type"))) {
            payIdentype = "1";
        }
        if (!"1".equals(payIdentype)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5230\u5355\u5904\u7406[%s]\u5173\u8054\u751f\u6210\u4ed8\u6b3e\u5355\uff0c\u4ed8\u6b3e\u6807\u8bc6\u9700\u4e3a\u88ab\u52a8\u4ed8\u6b3e\u3002", (String)"ArrivalWriteBackHelper_9", (String)"tmc-lc-mservice", (Object[])new Object[]{sourceBill.getString("billno")}));
        }
    }

    public static void checkSettleNumAndBillId(PayBillWriteBackParam param, DynamicObject sourceBill) {
        Long sbillId = param.getPayBill().getSourceBillId();
        if (EmptyUtil.isEmpty((Long)sbillId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u7684\u6e90\u5355ID\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ArrivalWriteBackHelper_12", (String)"tmc-lc-mservice", (Object[])new Object[0]));
        }
        if (sbillId.longValue() != sourceBill.getLong("id")) {
            DynamicObject arrivaBill = QueryServiceHelper.queryOne((String)"lc_arrival", (String)"arrivalno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sbillId)});
            if (EmptyUtil.isEmpty((DynamicObject)arrivaBill)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u7684\u6e90\u5355ID[%s]\u5173\u8054\u7684\u4fe1\u7528\u8bc1\u5230\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ArrivalWriteBackHelper_13", (String)"tmc-lc-mservice", (Object[])new Object[]{sbillId}));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5173\u8054\u7684\u5230\u5355\u7f16\u53f7\u4e3a[%1$s]\u548c\u4ed8\u6b3e\u5355\u7684\u7ed3\u7b97\u53f7[%2$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7ed3\u7b97\u53f7\u3002", (String)"ArrivalWriteBackHelper_11", (String)"tmc-lc-mservice", (Object[])new Object[0]), arrivaBill.getString("arrivalno"), param.getPayBill().getSettletNumber()));
        }
    }

    private static void saveSourBillAndMakeLimit(DynamicObject sourBill, BigDecimal payAmount, String flag, Long returnId, Date payDate) {
        try (TXHandle h = TX.required();){
            try {
                DynamicObject credit;
                String arrivalType = sourBill.getString("arrivaltype");
                if (ArrivalTypeEnum.CREDIT.getValue().equals(arrivalType) && EmptyUtil.isNoEmpty((DynamicObject)(credit = TmcDataServiceHelper.loadSingle((Object)sourBill.getDynamicObject("lettercredit").getPkValue(), (String)"lc_lettercredit")).getDynamicObject("creditlimit"))) {
                    if ("return".equals(flag)) {
                        boolean isPayAll = LetterCreditHelper.checkPayamount((DynamicObject)credit, (BigDecimal)payAmount);
                        CreditLimitServiceHelper.returnCreditLimit((DynamicObject)sourBill, (DynamicObject)credit, (boolean)false, (BigDecimal)payAmount, (Long)returnId, (boolean)isPayAll, (Date)payDate);
                        if (credit.getBoolean("isclosed")) {
                            credit.set("isclosed", (Object)false);
                            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{credit});
                        }
                    } else if (!credit.getBoolean("isclosed")) {
                        CreditLimitServiceHelper.cancelReturnCreditLimit((DynamicObject)sourBill, (DynamicObject)credit, (boolean)false, (BigDecimal)payAmount, (Long)returnId);
                    }
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private static void updateSourcebill(DynamicObject sourceBill) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourceBill});
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private static void updateLockPayAmt(DynamicObject arrBill, DynamicObjectCollection entrys) {
        Set<Long> payBillIds = entrys.parallelStream().filter(o -> EmptyUtil.isEmpty((String)o.getString("operatetype"))).map(o -> o.getLong("payid")).collect(Collectors.toSet());
        BigDecimal payAmt = entrys.parallelStream().filter(o -> PayOperateTypeEnum.isPayment((String)o.getString("operatetype")) || PayOperateTypeEnum.isRefund((String)o.getString("operatetype"))).map(o -> o.getBigDecimal("arrpayamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        DynamicObject suretyBill = ArrivalWriteBackHelper.loadSuretyRelease(arrBill.getLong("id"), arrBill.getDataEntityType().getName());
        if (EmptyUtil.isNoEmpty((DynamicObject)suretyBill)) {
            payAmt = payAmt.add(suretyBill.getBigDecimal("totalamount"));
        }
        arrBill.set("doneamount", (Object)payAmt);
        arrBill.set("todoamount", (Object)arrBill.getBigDecimal("arrivalamount").subtract(arrBill.getBigDecimal("doneamount")));
        BigDecimal lockAmt = ArrivalWriteBackHelper.getLockAmt(payBillIds);
        arrBill.set("lockamount", (Object)lockAmt);
        arrBill.set("ispayment", (Object)(EmptyUtil.isEmpty((DynamicObjectCollection)entrys) ? "0" : "1"));
        BigDecimal todoAmt = arrBill.getBigDecimal("todoamount");
        arrBill.set("arrivalstatus", (Object)(todoAmt.compareTo(BigDecimal.ZERO) <= 0 ? ArrivalStatusEnum.ARRIVAL_PAY.getValue() : ArrivalStatusEnum.ARRIVAL_CONFIRM.getValue()));
    }

    private static BigDecimal getLockAmt(Set<Long> paybillIds) {
        if (EmptyUtil.isEmpty(paybillIds)) {
            return BigDecimal.ZERO;
        }
        DynamicObjectCollection payBills = QueryServiceHelper.query((String)"cas_paybill", (String)"actpayamt", (QFilter[])new QFilter[]{new QFilter("id", "in", paybillIds)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)payBills)) {
            return BigDecimal.ZERO;
        }
        return payBills.parallelStream().map(o -> o.getBigDecimal("actpayamt")).reduce(BigDecimal::add).get();
    }

    public static DynamicObject loadSuretyRelease(Long bizId, String billType) {
        return QueryServiceHelper.queryOne((String)"fbd_suretyreleasebill", (String)String.join((CharSequence)",", "id", "amount", "totalamount"), (QFilter[])new QFilter[]{new QFilter("repaybillid", "=", (Object)bizId).and("repaybilltype", "=", (Object)billType)});
    }

    static interface doLockExcute {
        public void doOperate(DynamicObject var1);
    }
}

