/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackOperateEnum;
import kd.tmc.lc.bean.LetterWriteBackParam;
import kd.tmc.lc.common.enums.LetterCreditStatusEnum;
import kd.tmc.lc.common.enums.TradeChannelEnum;
import kd.tmc.lc.resource.LcMseResourceEnum;

public class LetterWriteBackHelper {
    private static final Log logger = LogFactory.getLog(LetterWriteBackHelper.class);
    private static final String KEY_LETTERPAY = "letterpay";

    public static void updateLetterEntryBill(LetterWriteBackParam payBill, DynamicObject sourBill) {
        Long payBillId = payBill.getPayBillId();
        String settletNumber = payBill.getSettletNumber();
        if (EmptyUtil.isEmpty((Long)payBillId) || EmptyUtil.isEmpty((String)settletNumber)) {
            throw new KDBizException(LcMseResourceEnum.LetterWriteBackHelper_13.loadKDString());
        }
        LetterWriteBackHelper.writeBackLetterBill(sourBill, paybill -> {
            LetterWriteBackHelper.updateOldLetterBill(payBillId, settletNumber);
            DynamicObjectCollection entrys = sourBill.getDynamicObjectCollection("billentry");
            entrys.removeIf(o -> EmptyUtil.isNoEmpty((Long)o.getLong("e_billid")) && o.getLong("e_billid") == payBillId.longValue());
            DynamicObject entry = entrys.addNew();
            entry.set("e_billtype", (Object)"cas_paybill");
            entry.set("e_billno", (Object)payBill.getPayBillNo());
            entry.set("e_billid", (Object)payBillId);
            entry.set("e_bizdate", (Object)payBill.getBizDate());
            entry.set("e_currency", (Object)payBill.getCurrencypk());
            entry.set("e_amount", (Object)payBill.getAmount());
            entry.set("e_createtime", (Object)DateUtils.getCurrentTime());
            BigDecimal entryAmount = entrys.stream().map(o -> o.getBigDecimal("e_amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            if (entryAmount.compareTo(sourBill.getBigDecimal("amount")) > 0) {
                DynamicObject currency = sourBill.getDynamicObject("currency");
                throw new KDBizException(LcMseResourceEnum.LetterWriteBackHelper_14.loadKDString(entryAmount.setScale(LetterWriteBackHelper.getAmtprecision(currency)), sourBill.getBigDecimal("amount").setScale(LetterWriteBackHelper.getAmtprecision(currency))));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourBill});
        });
    }

    public static void deleteLetterEntryBill(LetterWriteBackParam payBill, DynamicObject sourBill) {
        Long payBillId = payBill.getPayBillId();
        LetterWriteBackHelper.writeBackLetterBill(sourBill, paybill -> {
            DynamicObjectCollection entrys = sourBill.getDynamicObjectCollection("billentry");
            int entrySize = entrys.size();
            entrys.removeIf(o -> EmptyUtil.isNoEmpty((Long)o.getLong("e_billid")) && o.getLong("e_billid") == payBillId.longValue());
            if (entrySize != entrys.size()) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourBill});
            } else {
                logger.info("delete not match payBillId:", (Object)payBillId);
            }
        });
    }

    private static void writeBackLetterBill(DynamicObject sourBill, doLockExcute exc) {
        String letterId = sourBill.getString("id");
        boolean isLockSuc = MutexServiceHelper.request((String)letterId, (String)"lc_lettercredit", (String)KEY_LETTERPAY);
        if (!isLockSuc) {
            throw new KDBizException(LcMseResourceEnum.LetterWriteBackHelper_0.loadKDString(sourBill.getString("billno")));
        }
        try {
            exc.doOperate(sourBill);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            MutexServiceHelper.release((String)letterId, (String)"lc_lettercredit", (String)KEY_LETTERPAY);
        }
    }

    public static void validataLetterStatus(DynamicObject sourBill, LetterWriteBackParam param) {
        String msg;
        String settletNumber = param.getSettletNumber();
        String operate = param.getOperate();
        boolean isPayValidata = PayBillWriteBackOperateEnum.PAYVALIDATE.getValue().equals(operate);
        String string = msg = isPayValidata ? LcMseResourceEnum.LetterWriteBackHelper_2.loadKDString() : LcMseResourceEnum.LetterWriteBackHelper_1.loadKDString();
        if (EmptyUtil.isEmpty((String)settletNumber)) {
            throw new KDBizException(LcMseResourceEnum.LetterWriteBackHelper_3.loadKDString());
        }
        if (EmptyUtil.isEmpty((DynamicObject)sourBill)) {
            throw new KDBizException(LcMseResourceEnum.LetterWriteBackHelper_4.loadKDString(settletNumber));
        }
        DynamicObjectCollection entrys = sourBill.getDynamicObjectCollection("billentry");
        Set payBillIds = entrys.stream().map(o -> o.getLong("e_billid")).collect(Collectors.toSet());
        if ("cas_paybill".equals(sourBill.getString("sourcebilltype")) && !payBillIds.contains(param.getPayBillId())) {
            throw new KDBizException(LcMseResourceEnum.LetterWriteBackHelper_5.loadKDString(settletNumber));
        }
        if (!BillStatusEnum.isAudit((String)sourBill.getString("billstatus"))) {
            throw new KDBizException(LcMseResourceEnum.LetterWriteBackHelper_6.loadKDString(settletNumber, msg));
        }
        if (!isPayValidata && !LetterCreditStatusEnum.isRegister((String)sourBill.getString("creditstatus"))) {
            throw new KDBizException(LcMseResourceEnum.LetterWriteBackHelper_7.loadKDString(settletNumber));
        }
        if (isPayValidata && !LetterCreditStatusEnum.isRegister((String)sourBill.getString("creditstatus")) && !LetterCreditStatusEnum.isClose((String)sourBill.getString("creditstatus"))) {
            throw new KDBizException(LcMseResourceEnum.LetterWriteBackHelper_8.loadKDString(settletNumber));
        }
        if (TradeChannelEnum.isOnline((String)sourBill.getString("tradechannel")) && !BeBillStatusEnum.isTS((String)sourBill.getString("bebankstatus"))) {
            throw new KDBizException(LcMseResourceEnum.LetterWriteBackHelper_9.loadKDString(settletNumber, msg));
        }
        DynamicObject org = sourBill.getDynamicObject("org");
        if (EmptyUtil.isEmpty((Long)param.getPayerId()) || org != null && org.getLong("id") != param.getPayerId().longValue()) {
            throw new KDBizException(LcMseResourceEnum.LetterWriteBackHelper_10.loadKDString(settletNumber, org.getString("name")));
        }
        DynamicObject bank = sourBill.getDynamicObject("bank");
        if (EmptyUtil.isEmpty((Long)param.getPayBankId()) || bank != null && bank.getLong("id") != param.getPayBankId().longValue()) {
            throw new KDBizException(LcMseResourceEnum.LetterWriteBackHelper_11.loadKDString(settletNumber, bank.getString("name")));
        }
        if (!sourBill.getString("benefitertype").equals(param.getPayeeType()) || !LetterWriteBackHelper.getWithTrim(sourBill.getString("benefiterother")).equals(LetterWriteBackHelper.getWithTrim(param.getPayee()))) {
            throw new KDBizException(LcMseResourceEnum.LetterWriteBackHelper_12.loadKDString(settletNumber, LetterWriteBackHelper.getWithTrim(sourBill.getString("benefiterother"))));
        }
    }

    private static void updateOldLetterBill(Long payBillId, String settletNumber) {
        QFilter filter = new QFilter("id", "=", (Object)payBillId).and(QFilter.isNotNull((String)"settletnumber"));
        DynamicObject oldPayBill = QueryServiceHelper.queryOne((String)"cas_paybill", (String)"settletnumber", (QFilter[])new QFilter[]{filter});
        if (EmptyUtil.isEmpty((DynamicObject)oldPayBill) || oldPayBill.getString("settletnumber").equals(settletNumber)) {
            return;
        }
        DynamicObject letterBill = TmcDataServiceHelper.loadSingle((String)"lc_lettercredit", (String)"billentry.e_billno,billentry.e_billid", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)oldPayBill.getString("settletnumber"))});
        if (EmptyUtil.isEmpty((DynamicObject)letterBill)) {
            return;
        }
        DynamicObjectCollection billEntrys = letterBill.getDynamicObjectCollection("billentry");
        billEntrys.removeIf(o -> EmptyUtil.isNoEmpty((Long)o.getLong("e_billid")) && o.getLong("e_billid") == payBillId.longValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{letterBill});
    }

    private static String getWithTrim(String val) {
        return val != null ? val.trim() : "";
    }

    public static List<LetterWriteBackParam> getParamList(List<Map<String, Object>> params) {
        ArrayList<LetterWriteBackParam> paramList = new ArrayList<LetterWriteBackParam>(params.size());
        if (EmptyUtil.isEmpty(params)) {
            return paramList;
        }
        LetterWriteBackParam letterParam = null;
        for (Map<String, Object> param : params) {
            letterParam = new LetterWriteBackParam();
            letterParam.setOperate((String)param.get("operate"));
            letterParam.setPayBillId((Long)param.get("targetpk"));
            letterParam.setPayBillNo((String)param.get("targetbillno"));
            letterParam.setAmount((BigDecimal)param.get("amount"));
            letterParam.setBizDate((Date)param.get("bizdate"));
            letterParam.setCurrencypk((Long)param.get("currencypk"));
            letterParam.setSettletNumber((String)param.get("settletnumber"));
            letterParam.setPayerId((Long)param.get("payerid"));
            letterParam.setPayBankId((Long)param.get("paybankid"));
            letterParam.setPayeeType((String)param.get("payeetype"));
            letterParam.setPayee((String)param.get("payee"));
            paramList.add(letterParam);
        }
        return paramList;
    }

    public static int getAmtprecision(DynamicObject currency) {
        return currency != null ? currency.getInt("amtprecision") : 2;
    }

    static interface doLockExcute {
        public void doOperate(DynamicObject var1);
    }
}

