/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.helper;

import java.math.BigDecimal;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.recwriteback.RecBillWriteBackParam;
import kd.tmc.lc.common.enums.ArrivalWayEnum;
import kd.tmc.lc.common.enums.LetterCreditStatusEnum;
import kd.tmc.lc.common.enums.PresentStatusEnum;
import kd.tmc.lc.common.helper.LcParameterHelper;
import kd.tmc.lc.resource.LcMseResourceEnum;

public class PresentWritebackHelper {
    private static final String OP_KEY = "present_Writeback";

    private static void writeBackPresentBill(DynamicObject sourBill, doLockExcute exc) {
        String presentId = sourBill.getString("id");
        boolean isLockSuc = MutexServiceHelper.request((String)presentId, (String)"lc_present", (String)OP_KEY);
        if (!isLockSuc) {
            throw new KDBizException(LcMseResourceEnum.PresentWritebackHelper_7.loadKDString(sourBill.getString("billno")));
        }
        try {
            exc.doOperate(sourBill);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            MutexServiceHelper.release((String)presentId, (String)"lc_present", (String)OP_KEY);
        }
    }

    public static void validatePresentBill(RecBillWriteBackParam param, DynamicObject presentBill) {
        if (!BillStatusEnum.isAudit((String)presentBill.getString("billstatus"))) {
            throw new KDBizException(LcMseResourceEnum.PresentWritebackHelper_0.loadKDString(presentBill.getString("billno")));
        }
        if (!PresentStatusEnum.isConfirm((String)presentBill.getString("arrivalstatus"))) {
            throw new KDBizException(LcMseResourceEnum.PresentWritebackHelper_1.loadKDString(presentBill.getString("billno")));
        }
        if (ArrivalWayEnum.isProtest((String)presentBill.getString("arrivalway"))) {
            throw new KDBizException(LcMseResourceEnum.PresentWritebackHelper_2.loadKDString(presentBill.getString("billno")));
        }
        if (presentBill.getBoolean("isinit")) {
            throw new KDBizException(LcMseResourceEnum.PresentWritebackHelper_3.loadKDString(presentBill.getString("billno")));
        }
        String recMethod = LcParameterHelper.getAppStringParameter((long)presentBill.getDynamicObject("org").getLong("id"), (String)"recmethod");
        if (BaseEnableEnum.ENABLE.getValue().equals(recMethod)) {
            throw new KDBizException(LcMseResourceEnum.PresentWritebackHelper_4.loadKDString());
        }
        if (presentBill.getBoolean("ispayconfig")) {
            throw new KDBizException(LcMseResourceEnum.PresentWritebackHelper_5.loadKDString(presentBill.getString("billno")));
        }
        if (presentBill.getBoolean("isforfaiting")) {
            throw new KDBizException(LcMseResourceEnum.PresentWritebackHelper_6.loadKDString(presentBill.getString("billno")));
        }
        RecBillWriteBackParam.RecBillInfo recBill = param.getRecBill();
        if (EmptyUtil.isNoEmpty((Object)recBill) && !recBill.getCurrencyId().equals(presentBill.getDynamicObject("arrivalcurrency").getLong("id"))) {
            throw new KDBizException(LcMseResourceEnum.PresentWritebackHelper_9.loadKDString(presentBill.getString("billno")));
        }
    }

    public static void validateSettletNum(RecBillWriteBackParam param, DynamicObject presentBill) {
        if (EmptyUtil.isEmpty((String)param.getRecBill().getSettletNumber())) {
            throw new KDBizException(LcMseResourceEnum.PresentWritebackHelper_11.loadKDString());
        }
        if (!presentBill.getString("arrivalno").equals(param.getRecBill().getSettletNumber())) {
            throw new KDBizException(LcMseResourceEnum.PresentWritebackHelper_10.loadKDString(presentBill.getString("arrivalno"), param.getRecBill().getSettletNumber()));
        }
    }

    public static void validateCancelReceive(DynamicObject presentBill) {
        DynamicObject bill = QueryServiceHelper.queryOne((String)"lc_present", (String)"lettercredit", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)presentBill.getLong("id"))});
        long recLettBillId = bill.getLong("lettercredit");
        if (EmptyUtil.isEmpty((Long)recLettBillId)) {
            return;
        }
        DynamicObject recLettBill = QueryServiceHelper.queryOne((String)"lc_receipt", (String)"billno,creditstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)recLettBillId)});
        if (recLettBill != null && LetterCreditStatusEnum.isClose((String)recLettBill.getString("creditstatus"))) {
            throw new KDBizException(LcMseResourceEnum.PresentWritebackHelper_8.loadKDString(recLettBill.getString("billno")));
        }
    }

    public static void doSaveAndSubmitExecute(RecBillWriteBackParam param, DynamicObject presentBill) {
        PresentWritebackHelper.writeBackPresentBill(presentBill, recPresent -> {
            BigDecimal lockAmt;
            BigDecimal todoAmount;
            BigDecimal recAmount;
            QFilter qFilter;
            RecBillWriteBackParam.RecBillInfo recBill = param.getRecBill();
            Long recBillId = recBill.getRecBillId();
            BigDecimal dataBaseAmt = BigDecimal.ZERO;
            String settletnumber = "";
            DynamicObject recBillFromDb = QueryServiceHelper.queryOne((String)"cas_recbill", (String)"actrecamt,fee,settletnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)recBillId)});
            if (EmptyUtil.isNoEmpty((DynamicObject)recBillFromDb)) {
                BigDecimal actrecamt = recBillFromDb.getBigDecimal("actrecamt");
                BigDecimal fee = recBillFromDb.getBigDecimal("fee");
                dataBaseAmt = actrecamt.add(fee);
                settletnumber = recBillFromDb.getString("settletnumber");
            }
            String billNo = recBill.getRecBillNo();
            String invoiceNo = presentBill.getString("arrivalno");
            DynamicObject oldPreBill = null;
            if (EmptyUtil.isNoEmpty((String)settletnumber) && !settletnumber.equals(invoiceNo) && EmptyUtil.isNoEmpty((DynamicObject)(oldPreBill = TmcDataServiceHelper.loadSingle((String)"lc_present", (String)"id,entrys,lockamount,receiptno,isreceipt", (QFilter[])(qFilter = new QFilter("arrivalno", "=", (Object)settletnumber)).toArray())))) {
                DynamicObjectCollection entrys = oldPreBill.getDynamicObjectCollection("entrys");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
                    for (int i = 0; i < entrys.size(); ++i) {
                        DynamicObject entry = (DynamicObject)entrys.get(i);
                        String receiptNo = entry.getString("receiptno");
                        if (!billNo.equals(receiptNo)) continue;
                        entrys.remove(i);
                        break;
                    }
                }
                if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
                    oldPreBill.set("isreceipt", (Object)"0");
                }
                oldPreBill.set("lockamount", (Object)oldPreBill.getBigDecimal("lockamount").subtract(dataBaseAmt));
                dataBaseAmt = BigDecimal.ZERO;
            }
            if ((recAmount = recBill.getRecAmount()).compareTo((todoAmount = presentBill.getBigDecimal("todoamount")).subtract(lockAmt = presentBill.getBigDecimal("lockamount").subtract(dataBaseAmt))) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ea4\u5355\u5173\u8054\u7684\u6240\u6709\u6536\u6b3e\u5355\u7684\u6536\u6b3e\u91d1\u989d+\u624b\u7eed\u8d39\u5408\u8ba1\uff0c\u4e0d\u5141\u8bb8\u8d85\u8fc7\u4ea4\u5355\u7684\u672a\u6536\u91d1\u989d\u3002", (String)"LetterCreditWriteBackRecService_1", (String)"tmc-lc-mservice", (Object[])new Object[0]));
            }
            DynamicObjectCollection entrys = presentBill.getDynamicObjectCollection("entrys");
            DynamicObject recEntry = entrys.stream().filter(o -> recBillId.longValue() == o.getLong("receiptid")).findFirst().orElse(null);
            if (EmptyUtil.isEmpty((DynamicObject)recEntry)) {
                int seq = entrys.size() + 1;
                DynamicObject addNew = entrys.addNew();
                addNew.set("seq", (Object)seq);
                addNew.set("receiptno", (Object)billNo);
                addNew.set("receiptid", (Object)recBillId);
                addNew.set("writetime", (Object)DateUtils.getCurrentTime());
                presentBill.set("isreceipt", (Object)"1");
            } else {
                recEntry.set("receiptno", (Object)billNo);
            }
            presentBill.set("lockamount", (Object)lockAmt.add(recAmount));
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{presentBill});
                    if (EmptyUtil.isNoEmpty((DynamicObject)oldPreBill)) {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{oldPreBill});
                    }
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        });
    }

    public static void doDeleteExecute(RecBillWriteBackParam param, DynamicObject presentBill) {
        RecBillWriteBackParam.RecBillInfo recBill = param.getRecBill();
        Long recBillId = recBill.getRecBillId();
        PresentWritebackHelper.writeBackPresentBill(presentBill, recPresent -> {
            DynamicObjectCollection entrys = presentBill.getDynamicObjectCollection("entrys");
            entrys.removeIf(o -> recBillId.equals(o.getLong("receiptid")));
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
                presentBill.set("isreceipt", (Object)"0");
            }
            BigDecimal lockAmount = BigDecimal.ZERO;
            BigDecimal doneAmount = BigDecimal.ZERO;
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
                DynamicObjectCollection recBills = PresentWritebackHelper.getRecBills(entrys);
                lockAmount = PresentWritebackHelper.getTotalAmount(recBills, true);
                doneAmount = PresentWritebackHelper.getTotalAmount(recBills, false);
            }
            presentBill.set("lockamount", (Object)lockAmount);
            presentBill.set("doneamount", (Object)doneAmount);
            BigDecimal todoAmount = presentBill.getBigDecimal("arrivalamount").subtract(presentBill.getBigDecimal("doneamount"));
            presentBill.set("todoamount", (Object)(todoAmount.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : todoAmount));
            PresentWritebackHelper.saveSourBill(presentBill);
        });
    }

    public static void doReceiveExecute(RecBillWriteBackParam param, DynamicObject presentBill) {
        RecBillWriteBackParam.RecBillInfo recBill = param.getRecBill();
        Long recBillId = recBill.getRecBillId();
        PresentWritebackHelper.writeBackPresentBill(presentBill, recPresent -> {
            BigDecimal actrecamt = EmptyUtil.isEmpty((BigDecimal)recBill.getAmount()) ? BigDecimal.ZERO : recBill.getAmount();
            BigDecimal fee = EmptyUtil.isEmpty((BigDecimal)recBill.getFee()) ? BigDecimal.ZERO : recBill.getFee();
            BigDecimal recAmount = actrecamt.add(fee);
            DynamicObjectCollection entrys = presentBill.getDynamicObjectCollection("entrys");
            DynamicObject entry = entrys.stream().filter(o -> recBillId.equals(o.getLong("receiptid"))).findFirst().orElse(null);
            if (EmptyUtil.isNoEmpty((DynamicObject)entry)) {
                entry.set("prereceiptamount", (Object)recAmount);
                entry.set("businessdate", (Object)recBill.getBizDate());
                entry.set("receiptcurrency", (Object)recBill.getCurrencyId());
                entry.set("receiptamount", (Object)actrecamt);
                entry.set("serviceamount", (Object)fee);
                entry.set("receiptremark", (Object)recBill.getDescription());
            }
            presentBill.set("doneamount", (Object)presentBill.getBigDecimal("doneamount").add(recAmount));
            BigDecimal todoAmount = presentBill.getBigDecimal("arrivalamount").subtract(presentBill.getBigDecimal("doneamount"));
            presentBill.set("todoamount", (Object)(todoAmount.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : todoAmount));
            presentBill.set("lockamount", (Object)presentBill.getBigDecimal("lockamount").subtract(recAmount));
            BigDecimal todoAmt = presentBill.getBigDecimal("todoamount");
            if (todoAmt.compareTo(BigDecimal.ZERO) <= 0) {
                presentBill.set("arrivalstatus", (Object)PresentStatusEnum.PRESENT_RECIECT.getValue());
            }
            PresentWritebackHelper.saveSourBill(presentBill);
        });
    }

    public static void doCancelReceiveExecute(RecBillWriteBackParam param, DynamicObject presentBill) {
        RecBillWriteBackParam.RecBillInfo recBill = param.getRecBill();
        Long recBillId = recBill.getRecBillId();
        PresentWritebackHelper.writeBackPresentBill(presentBill, recPresent -> {
            DynamicObjectCollection entrys = presentBill.getDynamicObjectCollection("entrys");
            DynamicObject entry = entrys.stream().filter(o -> recBillId.equals(o.getLong("receiptid"))).findFirst().orElse(null);
            if (EmptyUtil.isNoEmpty((DynamicObject)entry)) {
                entry.set("prereceiptamount", (Object)BigDecimal.ZERO);
                entry.set("businessdate", null);
                entry.set("receiptcurrency", null);
                entry.set("receiptamount", (Object)BigDecimal.ZERO);
                entry.set("serviceamount", (Object)BigDecimal.ZERO);
                entry.set("receiptremark", null);
            }
            BigDecimal recAmount = param.getRecBill().getRecAmount();
            presentBill.set("doneamount", (Object)presentBill.getBigDecimal("doneamount").add(recAmount));
            BigDecimal todoAmount = presentBill.getBigDecimal("arrivalamount").subtract(presentBill.getBigDecimal("doneamount"));
            presentBill.set("todoamount", (Object)(todoAmount.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : todoAmount));
            presentBill.set("lockamount", (Object)presentBill.getBigDecimal("lockamount").subtract(recAmount));
            presentBill.set("arrivalstatus", (Object)PresentStatusEnum.PRESENT_CONFIRM.getValue());
            PresentWritebackHelper.saveSourBill(presentBill);
        });
    }

    private static DynamicObjectCollection getRecBills(DynamicObjectCollection entrys) {
        Set recBillIds = entrys.stream().map(o -> o.getLong("receiptid")).collect(Collectors.toSet());
        QFilter filter = new QFilter("id", "in", recBillIds).and("billstatus", "!=", (Object)"G");
        DynamicObjectCollection recBills = QueryServiceHelper.query((String)"cas_recbill", (String)"billstatus,actrecamt,fee", (QFilter[])new QFilter[]{filter});
        return recBills;
    }

    private static BigDecimal getTotalAmount(DynamicObjectCollection recBills, boolean isLockAmount) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)recBills)) {
            return BigDecimal.ZERO;
        }
        Stream<DynamicObject> billStream = recBills.stream().filter(o -> BillStatusEnum.isPayed((String)o.getString("billstatus")));
        if (isLockAmount) {
            billStream = recBills.stream().filter(o -> !BillStatusEnum.isPayed((String)o.getString("billstatus")));
        }
        return billStream.map(o -> o.getBigDecimal("actrecamt").add(o.getBigDecimal("fee"))).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private static void saveSourBill(DynamicObject sourBill) {
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourBill});
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    static interface doLockExcute {
        public void doOperate(DynamicObject var1);
    }
}

