/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.service;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.recwriteback.AbstractRecBillWriteBackService;
import kd.tmc.fbp.service.recwriteback.RecBillWriteBackParam;
import kd.tmc.lc.common.enums.ArrivalWayEnum;
import kd.tmc.lc.resource.LcMseResourceEnum;

public class ForfaitingWriteBackRecService
extends AbstractRecBillWriteBackService {
    protected void doSaveValidateExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSaveValidateExecute(param, sourceBill);
        if (!BillStatusEnum.isAudit((String)sourceBill.getString("billstatus"))) {
            throw new KDBizException(LcMseResourceEnum.ForfaitingWriteBackRecService_0.loadKDString(sourceBill.getString("billno")));
        }
        String arrivalWay = sourceBill.getString("arrivalway");
        if (ArrivalWayEnum.PROTEST.getValue().equals(arrivalWay)) {
            throw new KDBizException(LcMseResourceEnum.ForfaitingWriteBackRecService_1.loadKDString(sourceBill.getString("billno")));
        }
    }

    protected void doSubmitValidateExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        this.doSaveValidateExecute(param, sourceBill);
    }

    protected void doSaveExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSaveExecute(param, sourceBill);
        sourceBill.set("isreceipt", (Object)"1");
        this.DBTxBizUpdate(sourceBill);
    }

    protected void doSubmitExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        this.doSaveExecute(param, sourceBill);
    }

    protected void doDeleteExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doDeleteExecute(param, sourceBill);
        DynamicObjectCollection recBills = this.getRecBillBySourceBill(sourceBill, "id", param.getRecBill().getRecBillId());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)recBills)) {
            sourceBill.set("isreceipt", (Object)"0");
        }
        this.DBTxBizUpdate(sourceBill);
    }

    protected DynamicObject getSourceBill(RecBillWriteBackParam param) {
        DynamicObject sourceBill = TmcDataServiceHelper.loadSingle((String)"lc_forfaiting", (String)"billno,billstatus,recnetamount,buyoutcurrency,isreceipt,arrivalway", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)param.getRecBill().getSourceBillId())});
        return sourceBill;
    }

    protected Long getSourceBillCurrencyId(RecBillWriteBackParam param, DynamicObject sourceBill) {
        return sourceBill.getDynamicObject("buyoutcurrency").getLong("id");
    }

    protected BigDecimal getSourceBillRecAmount(RecBillWriteBackParam param, DynamicObject sourceBill) {
        return sourceBill.getBigDecimal("recnetamount");
    }
}

