/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.service;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackOperateEnum;
import kd.tmc.lc.bean.LetterWriteBackParam;
import kd.tmc.lc.helper.LetterWriteBackHelper;
import kd.tmc.lc.resource.LcMseResourceEnum;

public class LetterCreditOpenService {
    private static final Log logger = LogFactory.getLog(LetterCreditOpenService.class);

    public OperationResult execute(Object params) {
        List paramList = (List)params;
        logger.info("letterCreditm params:{}", (Object)paramList);
        List<LetterWriteBackParam> letterParamList = LetterWriteBackHelper.getParamList(paramList);
        if (EmptyUtil.isEmpty(letterParamList)) {
            logger.info("letterParamList is null");
            OperationResult result = new OperationResult();
            result.setSuccess(false);
            result.setMessage(LcMseResourceEnum.LetterCreditOpenService_3.loadKDString());
            return result;
        }
        String operate = letterParamList.get(0).getOperate();
        if (operate.endsWith("Validate")) {
            return this.operateValidate(letterParamList);
        }
        return this.operateWriteBack(letterParamList);
    }

    private OperationResult operateValidate(List<LetterWriteBackParam> letterParamList) {
        OperationResult result = new OperationResult();
        result.setSuccess(true);
        List validateErrors = result.getValidateResult().getValidateErrors();
        for (LetterWriteBackParam param : letterParamList) {
            try {
                this.doLetterExecute(param);
                result.getSuccessPkIds().add(param.getPayBillId());
            }
            catch (Exception e) {
                logger.error("paycheckfail", (Throwable)e);
                logger.info("paycheckfail payBillId:{}", (Object)param.getPayBillId());
                ValidateResult validateResult = new ValidateResult();
                validateErrors.add(validateResult);
                OperateErrorInfo info = new OperateErrorInfo();
                info.setMessage(e.getMessage());
                info.setPkValue((Object)param.getPayBillId());
                info.setErrorLevel(ErrorLevel.Error.name());
                validateResult.addErrorInfo(info);
            }
        }
        if (validateErrors.size() > 0) {
            result.setSuccess(false);
            result.setMessage(LcMseResourceEnum.LetterCreditOpenService_2.loadKDString());
        }
        return result;
    }

    private OperationResult operateWriteBack(List<LetterWriteBackParam> letterParamList) {
        OperationResult result = new OperationResult();
        result.setSuccess(true);
        try (TXHandle tx = TX.requiresNew();){
            try {
                for (LetterWriteBackParam param : letterParamList) {
                    this.doLetterExecute(param);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                tx.markRollback();
                result.setSuccess(false);
                result.setMessage(LcMseResourceEnum.LetterCreditOpenService_4.loadKDString(e.getMessage()));
            }
        }
        return result;
    }

    private void doLetterExecute(LetterWriteBackParam param) {
        DynamicObject letterCreditBill = this.getLetterCreditBill(param);
        if (EmptyUtil.isEmpty((DynamicObject)letterCreditBill)) {
            throw new KDBizException(LcMseResourceEnum.LetterWriteBackHelper_4.loadKDString(param.getSettletNumber()));
        }
        PayBillWriteBackOperateEnum operateEnum = PayBillWriteBackOperateEnum.getByValue((String)param.getOperate());
        switch (operateEnum) {
            case SAVE: {
                this.doSaveExecute(param, letterCreditBill);
                break;
            }
            case SUBMIT: {
                this.doSubmitExecute(param, letterCreditBill);
                break;
            }
            case PAY: {
                this.doPayExecute(param, letterCreditBill);
                break;
            }
            case DELETE: {
                this.doDeleteExecute(param, letterCreditBill);
                break;
            }
            case SAVEVALIDATE: {
                this.doSaveValidateExecute(param, letterCreditBill);
                break;
            }
            case SUBMITVALIDATE: {
                this.doSubmitValidateExecute(param, letterCreditBill);
                break;
            }
            case AUDITVALIDATE: {
                this.doAuditValidateExecute(param, letterCreditBill);
                break;
            }
            case PAYVALIDATE: {
                this.doPayValidateExecute(param, letterCreditBill);
                break;
            }
        }
    }

    protected void doSaveExecute(LetterWriteBackParam param, DynamicObject sourceBill) {
        LetterWriteBackHelper.updateLetterEntryBill(param, sourceBill);
    }

    protected void doSubmitExecute(LetterWriteBackParam param, DynamicObject sourceBill) {
        LetterWriteBackHelper.updateLetterEntryBill(param, sourceBill);
    }

    protected void doPayExecute(LetterWriteBackParam param, DynamicObject sourceBill) {
        LetterWriteBackHelper.updateLetterEntryBill(param, sourceBill);
    }

    protected void doDeleteExecute(LetterWriteBackParam param, DynamicObject sourceBill) {
        LetterWriteBackHelper.deleteLetterEntryBill(param, sourceBill);
    }

    protected void doSaveValidateExecute(LetterWriteBackParam param, DynamicObject sourceBill) {
        LetterWriteBackHelper.validataLetterStatus(sourceBill, param);
        this.checkPayBill(param, sourceBill);
    }

    protected void doSubmitValidateExecute(LetterWriteBackParam param, DynamicObject sourceBill) {
        LetterWriteBackHelper.validataLetterStatus(sourceBill, param);
        this.checkPayBill(param, sourceBill);
    }

    protected void doAuditValidateExecute(LetterWriteBackParam param, DynamicObject sourceBill) {
        LetterWriteBackHelper.validataLetterStatus(sourceBill, param);
        this.checkPayBill(param, sourceBill);
    }

    protected void doPayValidateExecute(LetterWriteBackParam param, DynamicObject sourceBill) {
        LetterWriteBackHelper.validataLetterStatus(sourceBill, param);
        this.checkPayBill(param, sourceBill);
    }

    protected BigDecimal getSourceBillLockPayAmount(DynamicObject sourceBill, Long payBillId) {
        String creditNo = sourceBill.getString("billno");
        QFilter filter = new QFilter("billstatus", "not in", Arrays.asList("G", "F", "H")).and("settletnumber", "=", (Object)creditNo).and("settletype.settlementtype", "=", (Object)"16");
        if (EmptyUtil.isNoEmpty((Long)payBillId)) {
            filter.and("id", "!=", (Object)payBillId);
        }
        DynamicObjectCollection paybills = QueryServiceHelper.query((String)"cas_paybill", (String)"actpayamt", (QFilter[])filter.toArray());
        return paybills.stream().map(p -> p.getBigDecimal("actpayamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    protected DynamicObject getLetterCreditBill(LetterWriteBackParam payBillInfo) {
        String selectProps = "billno,creditno,org,bank,benefitertype,benefiterother,creditstatus,billstatus,currency,amount,tradechannel,bebankstatus,sourcebilltype,billentry.e_billtype,billentry.e_billno,billentry.e_billid,billentry.e_bizdate,billentry.e_currency,billentry.e_amount,billentry.e_createtime";
        QFilter qFilter = null;
        qFilter = EmptyUtil.isEmpty((String)payBillInfo.getSettletNumber()) ? new QFilter("id", "=", (Object)payBillInfo.getSourceBillId()) : new QFilter("billno", "=", (Object)payBillInfo.getSettletNumber());
        DynamicObject sourceBill = TmcDataServiceHelper.loadSingle((String)"lc_lettercredit", (String)selectProps, (QFilter[])qFilter.toArray());
        return sourceBill;
    }

    protected void checkPayBill(LetterWriteBackParam param, DynamicObject sourceBill) {
        BigDecimal sourceBillLockPayAmount;
        BigDecimal subAmount;
        DynamicObject currency = sourceBill.getDynamicObject("currency");
        Long currencypk = param.getCurrencypk();
        if (currency != null && currencypk != null && currency.getLong("id") != currencypk.longValue()) {
            throw new KDBizException(LcMseResourceEnum.LetterCreditOpenService_0.loadKDString(sourceBill.getString("creditno")));
        }
        BigDecimal amount = sourceBill.getBigDecimal("amount");
        BigDecimal payAmount = param.getAmount();
        if (payAmount.compareTo(subAmount = amount.subtract(sourceBillLockPayAmount = this.getSourceBillLockPayAmount(sourceBill, param.getPayBillId()))) > 0) {
            throw new KDBizException(LcMseResourceEnum.LetterCreditOpenService_1.loadKDString(sourceBill.getString("creditno"), subAmount.setScale(LetterWriteBackHelper.getAmtprecision(currency))));
        }
    }
}

