/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.service;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.paywriteback.AbstractPayBillWriteBackService;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackOperateEnum;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackParam;
import kd.tmc.lc.common.helper.LetterCreditHelper;
import kd.tmc.lc.helper.ArrivalWriteBackHelper;

public class LetterCreditWriteBackPayService
extends AbstractPayBillWriteBackService {
    protected void doSaveExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        ArrivalWriteBackHelper.doSaveAndSubmitExecute(param, sourceBill);
    }

    protected void doSubmitExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        ArrivalWriteBackHelper.doSaveAndSubmitExecute(param, sourceBill);
    }

    protected void doPayExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        ArrivalWriteBackHelper.doPayExecute(param, sourceBill);
    }

    protected void doCancelPayExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        ArrivalWriteBackHelper.doCancelPayExecute(param, sourceBill);
    }

    protected void doChargebackExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        ArrivalWriteBackHelper.doChargebackExecute(param, sourceBill);
    }

    protected void doRefundExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doRefundExecute(param, sourceBill);
    }

    protected void doRenoteExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        ArrivalWriteBackHelper.doRenoteExecute(param, sourceBill);
    }

    protected void doCancelRefundExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doCancelRefundExecute(param, sourceBill);
    }

    protected void doCancelRenoteExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doCancelRenoteExecute(param, sourceBill);
    }

    protected void doDeleteExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        ArrivalWriteBackHelper.doDeleteExecute(param, sourceBill);
    }

    protected void doSaveValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        ArrivalWriteBackHelper.checkPaymentidentify(param, sourceBill);
        ArrivalWriteBackHelper.checkLcBill(sourceBill, param.getPayBill().getSettletNumber());
        ArrivalWriteBackHelper.checkLcBillStatus(sourceBill);
        ArrivalWriteBackHelper.checkSettleNumAndBillId(param, sourceBill);
        super.doSaveValidateExecute(param, sourceBill);
    }

    protected void doSubmitValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        ArrivalWriteBackHelper.checkPaymentidentify(param, sourceBill);
        ArrivalWriteBackHelper.checkLcBill(sourceBill, param.getPayBill().getSettletNumber());
        ArrivalWriteBackHelper.checkLcBillStatus(sourceBill);
        ArrivalWriteBackHelper.checkSettleNumAndBillId(param, sourceBill);
        super.doSubmitValidateExecute(param, sourceBill);
    }

    protected void doPayValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        ArrivalWriteBackHelper.checkPaymentidentify(param, sourceBill);
        ArrivalWriteBackHelper.checkLcBill(sourceBill, param.getPayBill().getSettletNumber());
        super.doPayValidateExecute(param, sourceBill);
    }

    protected void doCancelPayValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doCancelPayValidateExecute(param, sourceBill);
        DynamicObject letterCredit = sourceBill.getDynamicObject("lettercredit");
        String creditBillno = LetterCreditHelper.getIsCloseCreditStatus((DynamicObject)letterCredit);
        if (!"".equals(creditBillno)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5230\u5355\u5173\u8054\u7684\u5f00\u8bc1\u5904\u7406:%s\u4fe1\u7528\u72b6\u6001\u4e3a\u201c\u5df2\u95ed\u5377\u201d\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"LetterCreditWriteBackService_3", (String)"tmc-lc-mservice", (Object[])new Object[0]), creditBillno));
        }
    }

    protected BigDecimal getSourceBillLockPayAmount(DynamicObject sourceBill, Long payBillId) {
        long sourceBillId = sourceBill.getLong("id");
        Object[] targetBillIds = TmcBotpHelper.getTargetBillIds((String)sourceBill.getDataEntityType().getName(), (Object)sourceBillId, (String)"cas_paybill");
        if (EmptyUtil.isEmpty((Object[])targetBillIds)) {
            return BigDecimal.ZERO;
        }
        QFilter filter = new QFilter("id", "in", (Object)targetBillIds).and("billstatus", "not in", Arrays.asList("G", "F")).and("settletnumber", "=", (Object)sourceBill.getString("arrivalno")).and("id", "!=", (Object)payBillId);
        DynamicObjectCollection paybills = QueryServiceHelper.query((String)"cas_paybill", (String)"actpayamt", (QFilter[])filter.toArray());
        return paybills.stream().map(p -> p.getBigDecimal("actpayamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    protected DynamicObject getSourceBill(PayBillWriteBackParam param) {
        String selectProps;
        DynamicObject sourceBill;
        PayBillWriteBackParam.PayBillInfo payBillInfo = param.getPayBill();
        String operate = param.getOperate();
        QFilter qFilter = new QFilter("arrivalno", "=", (Object)payBillInfo.getSettletNumber());
        if (EmptyUtil.isEmpty((String)payBillInfo.getSettletNumber())) {
            if (PayBillWriteBackOperateEnum.isRefundOrRenote((String)operate)) {
                qFilter = new QFilter("id", "=", (Object)payBillInfo.getSourceBillId());
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u5f02\u5e38\uff1a\u4ed8\u6b3e\u5904\u7406\u8fd4\u56de\u5230\u5355\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4ed8\u6b3e\u5904\u7406\u7ed3\u7b97\u53f7\u3002", (String)"ArrivalWriteBackHelper_3", (String)"tmc-lc-mservice", (Object[])new Object[0]));
            }
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(sourceBill = TmcDataServiceHelper.loadSingle((String)"lc_arrival", (String)(selectProps = "billno,arrivalno,lettercredit,arrivalcurrency,arrivalamount,doneamount,todoamount,lockamount,arrivalstatus,arrivaltype,arrivalway,isinit,eassrcid,ispayconfig"), (QFilter[])qFilter.toArray())))) {
            payBillInfo.setSettletNumber(sourceBill.getString("arrivalno"));
        }
        return sourceBill;
    }

    protected DynamicObject getSourceBill(PayBillWriteBackParam.PayBillInfo payBillInfo) {
        return null;
    }

    protected Long getSourceBillCurrencyId(DynamicObject sourceBill) {
        return sourceBill.getDynamicObject("arrivalcurrency").getLong("id");
    }

    protected BigDecimal getSourceBillPayAmount(DynamicObject sourceBill) {
        BigDecimal arrAmount = sourceBill.getBigDecimal("arrivalamount");
        DynamicObject suretyBill = ArrivalWriteBackHelper.loadSuretyRelease(sourceBill.getLong("id"), sourceBill.getDataEntityType().getName());
        if (EmptyUtil.isNoEmpty((DynamicObject)suretyBill)) {
            arrAmount = arrAmount.subtract(suretyBill.getBigDecimal("totalamount"));
        }
        return arrAmount;
    }

    protected void mergeBySourceBillId(List<PayBillWriteBackParam> writeBackParams) {
        PayBillWriteBackParam payBillWriteBackParam = writeBackParams.get(0);
        List<String> operates = Arrays.asList(PayBillWriteBackOperateEnum.CHARGEBACK.getValue(), PayBillWriteBackOperateEnum.PAY.getValue());
        if (operates.contains(payBillWriteBackParam.getOperate())) {
            super.mergeBySourceBillId(writeBackParams);
        }
    }

    protected void checkEntryChange(List<Map<String, Object>> params) {
    }
}

